/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import b.h.la;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public final class RubyDebuggerFactory {
    private static final Logger a;
    private static final int c = 1098;
    private static final Pattern b;
    private static final long d;

    public static RubyDebuggerProxy startRubyDebug(Descriptor descriptor, String rdebugExecutable, String interpreter, int timeout) throws IOException, RubyDebuggerException {
        long l2 = d ^ 0x7863880AED5CL;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (interpreter != null) {
            arrayList.add(interpreter);
        }
        if (descriptor.isJRuby()) {
            RubyDebuggerFactory.adjustForJRuby(arrayList);
        }
        arrayList.addAll(descriptor.getAddtionalOptions());
        if (interpreter != null) {
            RubyDebuggerFactory.a(arrayList, descriptor);
        }
        arrayList.add(rdebugExecutable);
        String string = descriptor.a();
        if (string != null) {
            arrayList.add('_' + string + '_');
        }
        arrayList.add("-p");
        arrayList.add(String.valueOf(descriptor.getPort()));
        if (descriptor.isVerbose()) {
            arrayList.add("--xml-debug");
        }
        arrayList.add("--");
        arrayList.add(descriptor.getDebuggeePath());
        if (descriptor.getScriptArguments() != null) {
            arrayList.addAll(Arrays.asList(descriptor.getScriptArguments()));
        }
        return RubyDebuggerFactory.a(descriptor, arrayList, timeout);
    }

    public static void adjustForJRuby(List<? super String> args) {
        long l2 = d ^ 0x1FC6986254B1L;
        args.add("-J-Djruby.compile.mode=OFF");
        args.add("-J-Djruby.debug.fullTrace=true");
    }

    private static RubyDebuggerProxy a(Descriptor descriptor, List<String> list2, int n2) throws IOException, RubyDebuggerException {
        long l2 = d ^ 0x1CCCAF201899L;
        a.debug("Running [basedir: " + descriptor.getBaseDirectory() + "]: \"" + Util.getProcessAsString(list2) + "\"");
        ProcessBuilder processBuilder = new ProcessBuilder(list2);
        processBuilder.directory(descriptor.getBaseDirectory());
        if (descriptor.getEnvironment() != null) {
            processBuilder.environment().putAll(descriptor.getEnvironment());
        }
        a.debug("Environment: " + processBuilder.environment());
        String string = descriptor.a();
        boolean bl2 = string == null || Util.compareVersions(string, "0.1.10") > 0;
        RubyDebuggerProxy rubyDebuggerProxy = new RubyDebuggerProxy(n2, false, bl2, false);
        RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, "127.0.0.1", descriptor.getPort(), processBuilder.start(), descriptor.getDebuggeePath(), descriptor.getBaseDirectory());
        rubyDebuggerProxy.setDebugTarget(rubyDebugTarget);
        return rubyDebuggerProxy;
    }

    private static String a() throws IOException {
        long l2 = d ^ 0x59EFB764CBC1L;
        File file = File.createTempFile("io-synchronizer", ".rb");
        file.deleteOnExit();
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.println("$stdout.sync=true");
        printWriter.println("$stderr.sync=true");
        fileWriter.close();
        return file.getCanonicalPath();
    }

    private static void a(List<? super String> list2, Descriptor descriptor) throws IOException {
        long l2 = d ^ 0x589257ADBDD0L;
        if (descriptor.isSynchronizedOutput()) {
            String string = RubyDebuggerFactory.a();
            list2.add("-r");
            list2.add(string);
        }
    }

    static String substitute(String value, Map<String, String> varMap) {
        long l2 = d ^ 0x414BB6AFC68DL;
        try {
            Matcher matcher = b.matcher(value);
            boolean bl2 = matcher.find();
            if (bl2) {
                StringBuffer stringBuffer = new StringBuffer();
                do {
                    String string;
                    String string2;
                    if ((string2 = varMap.get(string = matcher.group(1))) == null) {
                        string2 = System.getProperty(string);
                    }
                    string2 = string2 != null ? string2.replace("\\", "\\\\").replace("$", "\\$") : "\\$\\{" + string + "\\}";
                    matcher.appendReplacement(stringBuffer, string2);
                } while (bl2 = matcher.find());
                matcher.appendTail(stringBuffer);
                value = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            a.error(exception.getLocalizedMessage(), (Throwable)exception);
        }
        return value;
    }

    static {
        d = la.a(8000634413838776909L, -451941340861598516L, MethodHandles.lookup().lookupClass()).a(262056214271780L);
        long l2 = d ^ 0x70172975DC0DL;
        a = Logger.getInstance(RubyDebuggerFactory.class);
        b = Pattern.compile("\\$\\{([^}]+)\\}");
    }

    public static final class Descriptor {
        private int d = -1;
        private boolean k;
        private boolean h;
        private String i;
        private File e;
        private String[] a;
        private Map<? extends String, ? extends String> c;
        private boolean b;
        private Collection<? extends String> j;
        private boolean f;
        private String g;

        public boolean isVerbose() {
            return this.k;
        }

        public void setVerbose(boolean verbose) {
            this.k = verbose;
        }

        public boolean defaultPortUsed() {
            return this.h;
        }

        public void useDefaultPort(boolean useDefaultPort) {
            this.h = useDefaultPort;
        }

        public String getDebuggeePath() {
            return this.i;
        }

        public void setDebuggeePath(String debuggeePath) {
            this.i = debuggeePath;
        }

        public void setBaseDirectory(File baseDir) {
            this.e = baseDir;
        }

        public File getBaseDirectory() {
            return this.e != null ? this.e : new File(this.getDebuggeePath()).getParentFile();
        }

        public String[] getScriptArguments() {
            return this.a;
        }

        public void setScriptArguments(String[] scriptArguments) {
            this.a = scriptArguments;
        }

        public Map<? extends String, ? extends String> getEnvironment() {
            return this.c;
        }

        public void setEnvironment(Map<? extends String, ? extends String> environment) {
            this.c = environment;
        }

        public boolean isSynchronizedOutput() {
            return this.b;
        }

        public void setSynchronizedOutput(boolean synchronizedOutput) {
            this.b = synchronizedOutput;
        }

        public Collection<? extends String> getAddtionalOptions() {
            return this.j == null ? Collections.emptySet() : this.j;
        }

        public void setAdditionalOptions(Collection<? extends String> additionalOptions) {
            this.j = additionalOptions;
        }

        int getPort() {
            if (this.d == -1) {
                this.d = this.defaultPortUsed() ? 1098 : Util.findFreePort();
            }
            return this.d;
        }

        public void setJRuby(boolean jruby) {
            this.f = jruby;
        }

        boolean isJRuby() {
            return this.f;
        }

        public void setRubyDebugIDEVersion(String rubyDebugIDEVersion) {
            this.g = rubyDebugIDEVersion;
        }

        private String a() {
            return this.g;
        }
    }
}

