/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public enum Case {
    MIXED(false),
    LOWER(false),
    UPPER(false),
    EXACT(true);

    public final boolean sensitive;

    private Case(boolean sensitive) {
        this.sensitive = sensitive;
    }

    public String apply(String s) {
        switch (this) {
            case EXACT: {
                return s;
            }
            case MIXED: {
                return s;
            }
            case LOWER: {
                return StringUtil.toLowerCase((String)s);
            }
            case UPPER: {
                return StringUtil.toUpperCase((String)s);
            }
        }
        throw new AssertionError((Object)this);
    }

    @Contract(value="_,!null->!null")
    public static Case fromString(@Nullable String str, @Nullable Case def) {
        if (str == null) {
            return def;
        }
        for (Case mode : Case.values()) {
            if (!Comparing.equal((String)str, (String)mode.name(), (boolean)false)) continue;
            return mode;
        }
        return def;
    }

    public static Case guessForName(@Nullable String str, Boolean isQuoted, Case plainMode, Case quotedMode) {
        if (str == null) {
            return plainMode;
        }
        if (Boolean.TRUE.equals(isQuoted)) {
            return quotedMode;
        }
        if (Boolean.FALSE.equals(isQuoted)) {
            return plainMode;
        }
        Case strMode = Case.forString(str);
        if (strMode != MIXED && (plainMode == strMode || quotedMode == strMode)) {
            return strMode;
        }
        if (plainMode == EXACT || quotedMode == EXACT) {
            return EXACT;
        }
        if (plainMode == MIXED || quotedMode == MIXED) {
            return MIXED;
        }
        return plainMode;
    }

    @Nullable
    public static Case forString(@Nullable String str) {
        Case result = null;
        if (str == null) {
            return null;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            Case cur;
            boolean lowerCase;
            char c = str.charAt(i);
            boolean upperCase = Character.isUpperCase(c);
            if (upperCase == (lowerCase = Character.isLowerCase(c))) continue;
            Case case_ = cur = upperCase ? UPPER : LOWER;
            if (result == null) {
                result = cur;
                continue;
            }
            if (result == cur) continue;
            result = MIXED;
            break;
        }
        return result;
    }
}

