/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsRootSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryMapping {
    public static final String PROJECT_CONSTANT = "<Project>";
    public static final VcsDirectoryMapping[] EMPTY_ARRAY = new VcsDirectoryMapping[0];
    @NotNull
    private final String myDirectory;
    private String myVcs;
    private VcsRootSettings myRootSettings;

    public VcsDirectoryMapping(@NotNull String directory, String vcs) {
        if (directory == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(0);
        }
        this(directory, vcs, null);
    }

    public VcsDirectoryMapping(@NotNull String directory, @Nullable String vcs, @Nullable VcsRootSettings rootSettings) {
        if (directory == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(1);
        }
        this.myDirectory = directory;
        this.myVcs = vcs;
        this.myRootSettings = rootSettings;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String systemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myDirectory);
        if (string == null) {
            VcsDirectoryMapping.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getVcs() {
        return this.myVcs;
    }

    public void setVcs(String vcs) {
        this.myVcs = vcs;
    }

    @Nullable
    public VcsRootSettings getRootSettings() {
        return this.myRootSettings;
    }

    public void setRootSettings(VcsRootSettings rootSettings) {
        this.myRootSettings = rootSettings;
    }

    public boolean isDefaultMapping() {
        return this.myDirectory.length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDirectoryMapping mapping = (VcsDirectoryMapping)o;
        if (!this.myDirectory.equals(mapping.myDirectory)) {
            return false;
        }
        if (this.myVcs != null ? !this.myVcs.equals(mapping.myVcs) : mapping.myVcs != null) {
            return false;
        }
        return !(this.myRootSettings != null ? !this.myRootSettings.equals(mapping.myRootSettings) : mapping.myRootSettings != null);
    }

    public int hashCode() {
        int result2 = this.myDirectory.hashCode();
        result2 = 31 * result2 + (this.myVcs != null ? this.myVcs.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return this.isDefaultMapping() ? PROJECT_CONSTANT : this.myDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsDirectoryMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsDirectoryMapping";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "systemIndependentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

