/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA;

import gnu.CORBA.typecodes.ArrayTypeCode;
import gnu.CORBA.typecodes.FixedTypeCode;
import gnu.CORBA.typecodes.GeneralTypeCode;
import gnu.CORBA.typecodes.PrimitiveTypeCode;
import gnu.CORBA.typecodes.RecordTypeCode;
import gnu.CORBA.typecodes.StringTypeCode;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class TypeCodeHelper {
    public static TypeCode read(InputStream in) throws BadKind, Bounds {
        PrimitiveTypeCode rt;
        TCKind kind = TCKind.from_int(in.read_long());
        switch (kind.value()) {
            case 19: 
            case 20: {
                ArrayTypeCode p = new ArrayTypeCode(kind);
                p.setLength(in.read_long());
                rt = p;
                break;
            }
            case 18: 
            case 27: {
                StringTypeCode s = new StringTypeCode(kind);
                s.setLength(in.read_long());
                rt = s;
                break;
            }
            case 28: {
                FixedTypeCode fx = new FixedTypeCode();
                fx.setDigits(in.read_short());
                fx.setScale(in.read_short());
                rt = fx;
                break;
            }
            case 14: 
            case 31: 
            case 32: {
                GeneralTypeCode g = new GeneralTypeCode(kind);
                g.setId(in.read_string());
                g.setName(in.read_string());
                rt = g;
                break;
            }
            case 21: 
            case 30: {
                GeneralTypeCode g = new GeneralTypeCode(kind);
                g.setId(in.read_string());
                g.setName(in.read_string());
                g.setContentType(in.read_TypeCode());
                rt = g;
                break;
            }
            case 15: 
            case 22: {
                RecordTypeCode r = new RecordTypeCode(kind);
                r.setId(in.read_string());
                r.setName(in.read_string());
                int n = in.read_long();
                int i = 0;
                while (i < n) {
                    RecordTypeCode.Field f = r.field();
                    f.name = in.read_string();
                    f.type = in.read_TypeCode();
                    ++i;
                }
                rt = r;
                break;
            }
            case 17: {
                RecordTypeCode r = new RecordTypeCode(kind);
                r.setId(in.read_string());
                r.setName(in.read_string());
                int n = in.read_long();
                int i = 0;
                while (i < n) {
                    RecordTypeCode.Field f = r.field();
                    f.name = in.read_string();
                    ++i;
                }
                rt = r;
                break;
            }
            case 16: {
                RecordTypeCode r = new RecordTypeCode(kind);
                r.setId(in.read_string());
                r.setName(in.read_string());
                r.setDiscriminator_type(in.read_TypeCode());
                r.setDefaultIndex(in.read_long());
                int n = in.read_long();
                int i = 0;
                while (i < n) {
                    RecordTypeCode.Field f = r.field();
                    f.label = in.read_any();
                    f.name = in.read_string();
                    f.type = in.read_TypeCode();
                    ++i;
                }
                rt = r;
                break;
            }
            case 29: {
                RecordTypeCode r = new RecordTypeCode(kind);
                r.setId(in.read_string());
                r.setName(in.read_string());
                r.setTypeModifier(in.read_short());
                r.setConcreteBase_type(in.read_TypeCode());
                int n = in.read_long();
                int i = 0;
                while (i < n) {
                    RecordTypeCode.Field f = r.field();
                    f.name = in.read_string();
                    f.type = in.read_TypeCode();
                    f.visibility = in.read_short();
                    ++i;
                }
                rt = r;
                break;
            }
            default: {
                rt = new PrimitiveTypeCode(kind);
            }
        }
        return rt;
    }

    public static void write(OutputStream out, TypeCode x) throws BadKind, Bounds {
        out.write_long(x.kind().value());
        switch (x.kind().value()) {
            case 18: 
            case 27: {
                out.write_long(x.length());
                break;
            }
            case 19: 
            case 20: {
                TypeCodeHelper.write(out, x.content_type());
                out.write_long(x.length());
                break;
            }
            case 28: {
                out.write_short(x.fixed_digits());
                out.write_short(x.fixed_scale());
                break;
            }
            case 14: 
            case 31: 
            case 32: {
                out.write_string(x.id());
                out.write_string(x.name());
                break;
            }
            case 21: 
            case 30: {
                out.write_string(x.id());
                out.write_string(x.name());
                TypeCodeHelper.write(out, x.content_type());
                break;
            }
            case 15: 
            case 22: {
                out.write_string(x.id());
                out.write_string(x.name());
                out.write_long(x.member_count());
                int i = 0;
                while (i < x.member_count()) {
                    out.write_string(x.member_name(i));
                    TypeCodeHelper.write(out, x.member_type(i));
                    ++i;
                }
                break;
            }
            case 17: {
                out.write_string(x.id());
                out.write_string(x.name());
                out.write_long(x.member_count());
                int i = 0;
                while (i < x.member_count()) {
                    out.write_string(x.member_name(i));
                    ++i;
                }
                break;
            }
            case 16: {
                out.write_string(x.id());
                out.write_string(x.name());
                TypeCodeHelper.write(out, x.discriminator_type());
                out.write_long(x.default_index());
                out.write_long(x.member_count());
                int i = 0;
                while (i < x.member_count()) {
                    out.write_any(x.member_label(i));
                    out.write_string(x.member_name(i));
                    TypeCodeHelper.write(out, x.member_type(i));
                    ++i;
                }
                break;
            }
            case 29: {
                out.write_string(x.id());
                out.write_string(x.name());
                out.write_short(x.type_modifier());
                TypeCodeHelper.write(out, x.concrete_base_type());
                out.write_long(x.member_count());
                int i = 0;
                while (i < x.member_count()) {
                    out.write_string(x.member_name(i));
                    TypeCodeHelper.write(out, x.member_type(i));
                    out.write_short(x.member_visibility(i));
                    ++i;
                }
                break;
            }
        }
    }
}

