/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;

public class KunststoffCheckBoxIcon
extends MetalCheckBoxIcon {
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ColorUIResource colorShadow;
        super.paintIcon(c, g, x, y);
        int controlSize = this.getControlSize();
        ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
        if (colorReflection != null) {
            Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
            Rectangle rect = new Rectangle(x, y, controlSize, controlSize / 2);
            KunststoffUtilities.drawGradient(g, colorReflection, colorReflectionFaded, rect, true);
        }
        if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
            Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
            Rectangle rect = new Rectangle(x, x + controlSize / 2, controlSize, controlSize / 2);
            KunststoffUtilities.drawGradient(g, colorShadowFaded, colorShadow, rect, true);
        }
    }
}

