/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.squirrel_sql.client.gui.IProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.gui.ProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DeleteTablesCommand
implements ICommand {
    private final ILogger s_log = LoggerController.createLogger(DeleteTablesCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DeleteTablesCommand.class);
    private final ISession _session;
    private final List<ITableInfo> _tables;
    private HashSet<String> matViewLookup = null;
    private IObjectTreeAPI _tree;
    private IProgressCallBackFactory progressCallBackFactory = new ProgressCallBackFactory();

    public DeleteTablesCommand(IObjectTreeAPI tree, List<ITableInfo> tables) {
        if (tree == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (tables == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo[] == null");
        }
        this._session = tree.getSession();
        this._tree = tree;
        this._tables = tables;
    }

    @Override
    public void execute() {
        ProgressCallBack cb = this.progressCallBackFactory.create(this._session.getApplication().getMainFrame(), i18n.PROGRESS_DIALOG_TITLE, this._tables.size());
        cb.setLoadingPrefix(i18n.LOADING_PREFIX);
        DeleteExecuter executer = new DeleteExecuter(cb);
        this._session.getApplication().getThreadPool().addTask(executer);
    }

    private boolean isMaterializedView(ITableInfo ti, ISession session) {
        if (!DialectFactory.isOracle(session.getMetaData())) {
            return false;
        }
        if (this.matViewLookup == null) {
            this.initMatViewLookup(session, ti.getSchemaName());
        }
        return this.matViewLookup.contains(ti.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMatViewLookup(ISession session, String schema) {
        ResultSet rs;
        block4: {
            this.matViewLookup = new HashSet();
            String sql = "SELECT TABLE_NAME FROM ALL_TAB_COMMENTS where COMMENTS like 'snapshot%' and OWNER = ? ";
            PreparedStatement stmt = null;
            rs = null;
            try {
                stmt = session.getSQLConnection().prepareStatement(sql);
                stmt.setString(1, schema);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                String tableName = rs.getString(1);
                this.matViewLookup.add(tableName);
            }
            catch (SQLException e) {
                try {
                    this.s_log.error("Unexpected exception while attempting to find mat. views in schema: " + schema, e);
                }
                catch (Throwable throwable) {
                    SQLUtilities.closeResultSet(rs, true);
                    throw throwable;
                }
                SQLUtilities.closeResultSet(rs, true);
            }
        }
        SQLUtilities.closeResultSet(rs, true);
    }

    public void setProgressCallBackFactory(IProgressCallBackFactory progressCallBackFactory) {
        this.progressCallBackFactory = progressCallBackFactory;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class DeleteExecuter
    implements Runnable {
        ProgressCallBack _cb = null;

        public DeleteExecuter(ProgressCallBack cb) {
            Utilities.checkNull("DeleteExecuter.init", "cb", cb);
            this._cb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SQLDatabaseMetaData md = DeleteTablesCommand.this._session.getSQLConnection().getSQLMetaData();
            List<ITableInfo> orderedTables = DeleteTablesCommand.this._tables;
            try {
                orderedTables = SQLUtilities.getDeletionOrder(DeleteTablesCommand.this._tables, md, this._cb);
            }
            catch (Exception e) {
                try {
                    DeleteTablesCommand.this.s_log.error("Unexpected exception while attempting to order tables", e);
                }
                catch (Throwable throwable) {
                    GUIUtils.processOnSwingEventThread(new Runnable(){

                        @Override
                        public void run() {
                            DeleteExecuter.this._cb.setVisible(false);
                        }
                    });
                    throw throwable;
                }
                GUIUtils.processOnSwingEventThread(new /* invalid duplicate definition of identical inner class */);
            }
            GUIUtils.processOnSwingEventThread(new /* invalid duplicate definition of identical inner class */);
            String sqlSep = DeleteTablesCommand.this._session.getQueryTokenizer().getSQLStatementSeparator();
            String cascadeClause = null;
            try {
                cascadeClause = md.getCascadeClause();
            }
            catch (SQLException e) {
                DeleteTablesCommand.this.s_log.error("Unexpected exception while attempting to get cascade clause", e);
            }
            StringBuilder buf = new StringBuilder();
            for (ITableInfo ti : orderedTables) {
                if (DeleteTablesCommand.this.isMaterializedView(ti, DeleteTablesCommand.this._session)) continue;
                buf.append("DELETE FROM ").append(ti.getQualifiedName());
                if (cascadeClause != null && !cascadeClause.equals("")) {
                    buf.append(" ").append(cascadeClause);
                }
                buf.append(" ").append(sqlSep).append(" ").append('\n');
            }
            if (buf.length() == 0) {
                return;
            }
            SQLExecuterTask executer = new SQLExecuterTask(DeleteTablesCommand.this._session, buf.toString(), null);
            executer.run();
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    DeleteTablesCommand.this._tree.refreshSelectedNodes();
                }
            });
        }
    }

    static interface i18n {
        public static final String PROGRESS_DIALOG_TITLE = DeleteTablesCommand.access$000().getString("DeleteTablesCommand.progressDialogTitle");
        public static final String LOADING_PREFIX = DeleteTablesCommand.access$000().getString("DeleteTablesCommand.loadingPrefix");
    }
}

