/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.openxml;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters3.xml.openxml.EditOpenXMLOptionsDialog;
import org.omegat.filters3.xml.openxml.OpenXMLDialect;
import org.omegat.filters3.xml.openxml.OpenXMLOptions;
import org.omegat.filters3.xml.openxml.OpenXMLXMLFilter;
import org.omegat.util.Log;
import org.omegat.util.OStrings;

public class OpenXMLFilter
extends AbstractFilter {
    private static final Logger LOGGER = Logger.getLogger(OpenXMLFilter.class.getName());
    private String documents;
    private Pattern translatable;
    private static final Pattern DIGITS = Pattern.compile("(\\d+)\\.xml");

    private void defineDOCUMENTSOptions(Map<String, String> config) {
        StringBuilder sb = new StringBuilder("(document\\d?\\.xml)");
        OpenXMLOptions options = new OpenXMLOptions(config);
        if (options.getTranslateComments()) {
            sb.append("|(comments\\.xml)");
        }
        if (options.getTranslateFootnotes()) {
            sb.append("|(footnotes\\.xml)");
        }
        if (options.getTranslateEndnotes()) {
            sb.append("|(endnotes\\.xml)");
        }
        if (options.getTranslateHeaders()) {
            sb.append("|(header\\d+\\.xml)");
        }
        if (options.getTranslateFooters()) {
            sb.append("|(footer\\d+\\.xml)");
        }
        if (options.getTranslateDocumentProperties()) {
            sb.append("|(core\\.xml)");
        }
        sb.append("|(sharedStrings\\.xml)");
        if (options.getTranslateExcelComments()) {
            sb.append("|(comments\\d+\\.xml)");
        }
        sb.append("|(slide\\d+\\.xml)");
        if (options.getTranslateSlideMasters()) {
            sb.append("|(slideMaster\\d+\\.xml)");
        }
        if (options.getTranslateSlideLayouts()) {
            sb.append("|(slideLayout\\d+\\.xml)");
        }
        if (options.getTranslateSlideComments()) {
            sb.append("|(notesSlide\\d+\\.xml)");
        }
        if (options.getTranslateDiagrams()) {
            sb.append("|(data\\d+\\.xml)");
        }
        if (options.getTranslateCharts()) {
            sb.append("|(chart\\d+\\.xml)");
        }
        if (options.getTranslateDrawings()) {
            sb.append("|(drawing\\d+\\.xml)");
        }
        if (options.getTranslateSheetNames()) {
            sb.append("|(workbook\\.xml)");
        }
        if (options.getTranslateLinks()) {
            sb.append("|(\\w+\\d*\\.xml\\.rels)");
        }
        sb.append("|(page\\d+\\.xml)");
        this.documents = sb.toString();
        this.translatable = Pattern.compile(this.documents);
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext fc) {
        this.defineDOCUMENTSOptions(config);
        try (ZipFile file = new ZipFile(inFile);){
            String shortname;
            Matcher filematch;
            Enumeration<? extends ZipEntry> entries = file.entries();
            do {
                if (!entries.hasMoreElements()) return false;
                ZipEntry entry = entries.nextElement();
                shortname = entry.getName();
            } while (!(filematch = this.translatable.matcher(shortname = OpenXMLFilter.removePath(shortname))).matches());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Error checking if file is supported by OpenXMLFilter: " + inFile, e);
        }
        return false;
    }

    private OpenXMLXMLFilter createXMLFilter() {
        OpenXMLXMLFilter xmlfilter = new OpenXMLXMLFilter();
        xmlfilter.setCallbacks(this.entryParseCallback, this.entryTranslateCallback);
        OpenXMLDialect dialect = (OpenXMLDialect)xmlfilter.getDialect();
        dialect.defineDialect(new OpenXMLOptions(this.processOptions));
        return xmlfilter;
    }

    private static File tmp() throws IOException {
        return File.createTempFile("o-xml-temp", ".xml");
    }

    private static String removePath(String fileName) {
        if (fileName.lastIndexOf(47) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        } else if (fileName.lastIndexOf(92) >= 0) {
            fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
        }
        return fileName;
    }

    private static String removeXML(String fileName) {
        if (fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(".xml"));
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        this.defineDOCUMENTSOptions(this.processOptions);
        try (ZipOutputStream zipout = null;
             ZipFile zipfile = new ZipFile(inFile);){
            if (outFile != null) {
                zipout = new ZipOutputStream(new FileOutputStream(outFile));
            }
            Enumeration<? extends ZipEntry> unsortedZipcontents = zipfile.entries();
            ArrayList<? extends ZipEntry> filelist = Collections.list(unsortedZipcontents);
            Collections.sort(filelist, this::compareZipEntries);
            for (ZipEntry zipEntry : filelist) {
                String shortname = OpenXMLFilter.removePath(zipEntry.getName());
                if (this.translatable.matcher(shortname).matches()) {
                    File tmpin = OpenXMLFilter.tmp();
                    FileUtils.copyInputStreamToFile((InputStream)zipfile.getInputStream(zipEntry), (File)tmpin);
                    File tmpout = null;
                    if (zipout != null) {
                        tmpout = OpenXMLFilter.tmp();
                    }
                    try {
                        this.createXMLFilter().processFile(tmpin, tmpout, fc);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        throw new TranslationException(e.getLocalizedMessage() + "\n" + OStrings.getString("OpenXML_ERROR_IN_FILE") + inFile, e);
                    }
                    if (zipout != null) {
                        ZipEntry outEntry = new ZipEntry(zipEntry.getName());
                        zipout.putNextEntry(outEntry);
                        FileUtils.copyFile((File)tmpout, (OutputStream)zipout);
                        zipout.closeEntry();
                    }
                    if (!tmpin.delete()) {
                        tmpin.deleteOnExit();
                    }
                    if (tmpout == null || tmpout.delete()) continue;
                    tmpout.deleteOnExit();
                    continue;
                }
                if (zipout == null) continue;
                ZipEntry outEntry = new ZipEntry(zipEntry.getName());
                zipout.putNextEntry(outEntry);
                try (InputStream is = zipfile.getInputStream(zipEntry);){
                    IOUtils.copy((InputStream)is, (OutputStream)zipout);
                }
                zipout.closeEntry();
            }
        }
    }

    public int compareZipEntries(ZipEntry z1, ZipEntry z2) {
        int index2;
        String s1 = z1.getName();
        String s2 = z2.getName();
        String[] words1 = s1.split("\\d+\\.");
        String[] words2 = s2.split("\\d+\\.");
        if (words1.length > 1 && words2.length > 1 && words1[0].equals(words2[0])) {
            int number1 = 0;
            int number2 = 0;
            Matcher getDigits = DIGITS.matcher(s1);
            if (getDigits.find()) {
                number1 = Integer.parseInt(getDigits.group(1));
            }
            if ((getDigits = DIGITS.matcher(s2)).find()) {
                number2 = Integer.parseInt(getDigits.group(1));
            }
            if (number1 > number2) {
                return 1;
            }
            if (number1 < number2) {
                return -1;
            }
            return 0;
        }
        String shortname1 = OpenXMLFilter.removePath(words1[0]);
        shortname1 = OpenXMLFilter.removeXML(shortname1);
        String shortname2 = OpenXMLFilter.removePath(words2[0]);
        shortname2 = OpenXMLFilter.removeXML(shortname2);
        if (shortname1.indexOf("sharedStrings") >= 0 || shortname2.indexOf("sharedStrings") >= 0) {
            if (shortname2.indexOf("sharedStrings") >= 0) {
                return 1;
            }
            return -1;
        }
        int index1 = this.documents.indexOf(shortname1);
        if (index1 > (index2 = this.documents.indexOf(shortname2))) {
            return 1;
        }
        if (index1 < index2) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("OpenXML_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.doc?"), new Instance("*.dotx"), new Instance("*.xls?"), new Instance("*.ppt?"), new Instance("*.vsdx")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        throw new IOException("Not Implemented!");
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Window parent, Map<String, String> currentOptions) {
        try {
            EditOpenXMLOptionsDialog dialog = new EditOpenXMLOptionsDialog(parent, currentOptions);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }

    @Override
    public String getInEncodingLastParsedFile() {
        return "OpenXML";
    }
}

