/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import org.omegat.util.PatternConsts;

public class XMLReader
extends Reader {
    private BufferedReader reader;
    boolean readFirstTime = true;

    public XMLReader(String fileName) throws IOException {
        this(fileName, null);
    }

    public XMLReader(String fileName, String encoding) throws IOException {
        this.reader = new BufferedReader(this.createReader(new FileInputStream(fileName), encoding));
    }

    public XMLReader(InputStream inputStream, String encoding) throws IOException {
        this.reader = new BufferedReader(this.createReader(inputStream, encoding));
    }

    private Reader createReader(InputStream inputStream, String defaultEncoding) throws IOException {
        String buffer;
        Matcher matcherXml;
        BufferedInputStream is = new BufferedInputStream(inputStream);
        is.mark(65536);
        int char1 = is.read();
        int char2 = is.read();
        int char3 = is.read();
        String encoding = null;
        if (char1 == 254 && char2 == 255) {
            encoding = "UTF-16BE";
        } else if (char1 == 255 && char2 == 254) {
            encoding = "UTF-16LE";
        } else if (char1 == 239 && char2 == 187 && char3 == 191) {
            encoding = "UTF-8";
        }
        is.reset();
        if (encoding != null) {
            return new InputStreamReader((InputStream)is, encoding);
        }
        is.mark(65536);
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        if (len > 0 && (matcherXml = PatternConsts.XML_ENCODING.matcher(buffer = defaultEncoding == null ? new String(buf, 0, len, Charset.defaultCharset()) : new String(buf, 0, len, defaultEncoding))).find()) {
            encoding = matcherXml.group(1);
        }
        is.reset();
        if (encoding != null) {
            return new InputStreamReader((InputStream)is, encoding);
        }
        try {
            return new InputStreamReader((InputStream)is, defaultEncoding);
        }
        catch (Exception e) {
            return new InputStreamReader((InputStream)is, Charset.defaultCharset());
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.readFirstTime) {
            this.readFirstTime = false;
            this.reader.mark(1);
            int ch = this.reader.read();
            if (ch != 65279) {
                this.reader.reset();
            }
        }
        return this.reader.read(cbuf, off, len);
    }
}

