/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.dsl.data;

import io.github.eb4j.dsl.data.DictionaryData;
import io.github.eb4j.dsl.data.DslEntry;
import io.github.eb4j.dsl.index.DslIndex;
import java.util.List;
import org.trie4j.MapTrie;
import org.trie4j.patricia.MapPatriciaTrie;

public final class DictionaryDataBuilder<T> {
    public DictionaryData<T> build(List<DslIndex.Entry> entries) {
        MapPatriciaTrie mapPatriciaTrie = new MapPatriciaTrie();
        for (DslIndex.Entry en : entries) {
            this.doAdd((MapTrie<Object>)mapPatriciaTrie, en.getHeadWord(), en.getOffset(), en.getSize(), en.getHeaderOffset(), en.getHeaderSize());
            String lowerKey = en.getHeadWord().toLowerCase();
            if (en.getHeadWord().equals(lowerKey)) continue;
            this.doAdd((MapTrie<Object>)mapPatriciaTrie, lowerKey, en.getOffset(), en.getSize(), en.getHeaderOffset(), en.getHeaderSize());
        }
        return new DictionaryData((MapTrie<Object>)mapPatriciaTrie);
    }

    private void doAdd(MapTrie<Object> mapPatriciaTrie, String key, long offset, int size, long headerOffiset, int headerSize) {
        Object[] stored = mapPatriciaTrie.get(key);
        if (stored == null) {
            mapPatriciaTrie.insert(key, (Object)new DslEntry(headerOffiset, headerSize, offset, size));
        } else {
            stored = stored instanceof Object[] ? this.extendArray(stored, new DslEntry(headerOffiset, headerSize, offset, size)) : new Object[]{stored, new DslEntry(headerOffiset, headerSize, offset, size)};
            mapPatriciaTrie.put(key, (Object)stored);
        }
    }

    Object[] extendArray(Object[] array, Object value) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }
}

