/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.dsl.visitor;

import io.github.eb4j.dsl.DslArticle;
import io.github.eb4j.dsl.data.LanguageCode;
import io.github.eb4j.dsl.data.LanguageName;
import io.github.eb4j.dsl.visitor.DslVisitor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class HtmlDslVisitor
extends DslVisitor<String> {
    private static final String[] IMAGE_EXTS = new String[]{"png", "jpg", "PNG", "JPG", "jpeg"};
    private static final Map<String, String> TAGMAP = new HashMap<String, String>();
    private static final Map<String, String> ENDTAGMAP = new HashMap<String, String>();
    private final LanguageCode langCode = new LanguageCode();
    private final LanguageName langName = new LanguageName();
    private final File basePath;
    private StringBuilder sb;
    private boolean specialTag;
    private String current;

    public HtmlDslVisitor() {
        this.basePath = new File(".");
        this.specialTag = false;
    }

    public HtmlDslVisitor(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            throw new IOException("Directory not found!");
        }
        this.basePath = dir;
        this.specialTag = false;
    }

    @Override
    public void start() {
        this.sb = new StringBuilder();
    }

    @Override
    public void finish() {
    }

    @Override
    public void visit(DslArticle.Tag tag) {
        if (TAGMAP.containsKey(tag.getTagName())) {
            this.sb.append(TAGMAP.get(tag.getTagName()));
            return;
        }
        if (tag.isTagName("url") || tag.isTagName("s") || tag.isTagName("video")) {
            this.specialTag = true;
            return;
        }
        if (tag.isTagName("c")) {
            if (tag.hasAttribute()) {
                this.sb.append("<span style=\"color: ").append(tag.getAttribute().getValue()).append("\">");
            } else {
                this.sb.append("<span style=\"color: green\">");
            }
        } else if (tag.isTagName("'")) {
            this.sb.append("<span style=\"color: red\">");
        } else if (tag.isTagName("lang")) {
            if (tag.hasAttribute() && tag.getAttribute().getKey().equals("id")) {
                int i = Integer.parseInt(tag.getAttribute().getValue());
                if (this.langCode.containsKey(i)) {
                    this.sb.append("<span class=\"lang_").append((String)this.langCode.get(i)).append("\">");
                    return;
                }
            } else if (tag.hasAttribute() && tag.getAttribute().getKey().equals("name") && this.langName.containsKey(tag.getAttribute().getValue())) {
                this.sb.append("<span class=\"lang_").append((String)this.langName.get(tag.getAttribute().getValue())).append("\">");
                return;
            }
            this.sb.append("<span>");
        }
    }

    private String getMediaUrl() {
        return new File(this.basePath, this.current).toURI().toString();
    }

    private boolean isMediaImage() {
        String ext = FilenameUtils.getExtension((String)this.current);
        for (String e : IMAGE_EXTS) {
            if (!e.equals(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(DslArticle.EndTag endTag) {
        if (this.specialTag) {
            if (this.current == null) {
                return;
            }
            if (endTag.isTagName("url")) {
                this.sb.append("<a href=\"").append(this.current).append("\">").append(this.current).append("</a>");
            } else if (endTag.isTagName("video") || endTag.isTagName("s") && !this.isMediaImage()) {
                this.sb.append("<a href=\"").append(this.getMediaUrl()).append("\">").append(this.current).append("</a>");
            } else if (endTag.isTagName("s")) {
                this.sb.append("<img src=\"").append(this.getMediaUrl()).append("\" />");
            }
            this.specialTag = false;
            this.current = null;
        }
        if (ENDTAGMAP.containsKey(endTag.getTagName())) {
            this.sb.append(ENDTAGMAP.get(endTag.getTagName()));
        }
    }

    @Override
    public String getObject() {
        if (this.sb == null) {
            return "";
        }
        return this.sb.toString();
    }

    @Override
    public void visit(DslArticle.Text t) {
        this.current = t.getText();
        if (!this.specialTag) {
            this.sb.append(t);
        }
    }

    @Override
    public void visit(DslArticle.Attribute a) {
    }

    @Override
    public void visit(DslArticle.Newline n) {
        this.sb.append("\n");
    }

    static {
        TAGMAP.put("b", "<strong>");
        ENDTAGMAP.put("b", "</strong>");
        TAGMAP.put("br", "<br/>");
        TAGMAP.put("i", "<span style='font-style: italic'>");
        ENDTAGMAP.put("i", "</span>");
        TAGMAP.put("t", "<span class=\"term\">");
        ENDTAGMAP.put("t", "&nbsp;</span>");
        TAGMAP.put("u", "<span style='text-decoration:underline'>");
        ENDTAGMAP.put("u", "</span>");
        TAGMAP.put("sup", "<sup>");
        ENDTAGMAP.put("sup", "</sup>");
        TAGMAP.put("sub", "</sub>");
        ENDTAGMAP.put("sub", "</sub>");
        ENDTAGMAP.put("c", "</span>");
        ENDTAGMAP.put("'", "</span>");
        TAGMAP.put("m", "<p>");
        TAGMAP.put("m1", "<p style=\"text-indent: 30px\">");
        TAGMAP.put("m2", "<p style=\"text-indent: 60px\">");
        TAGMAP.put("m3", "<p style=\"text-indent: 90px\">");
        TAGMAP.put("m4", "<p style=\"text-indent: 90px\">");
        TAGMAP.put("m5", "<p style=\"text-indent: 90px\">");
        TAGMAP.put("m6", "<p style=\"text-indent: 90px\">");
        TAGMAP.put("m7", "<p style=\"text-indent: 90px\">");
        TAGMAP.put("m8", "<p style=\"text-indent: 90px\">");
        TAGMAP.put("m9", "<p style=\"text-indent: 90px\">");
        ENDTAGMAP.put("m", "</p>");
        ENDTAGMAP.put("lang", "</span>");
        TAGMAP.put("*", "<span class=\"details\">");
        ENDTAGMAP.put("*", "</span>");
    }
}

