/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HeaderUtil;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalAprInputBuffer
extends AbstractInputBuffer<Long> {
    private static final Log log = LogFactory.getLog(InternalAprInputBuffer.class);
    private ByteBuffer bbuf;
    private long socket;
    private SocketWrapper<Long> wrapper;

    public InternalAprInputBuffer(Request request, int headerBufferSize, boolean rejectIllegalHeader, HttpParser httpParser) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.bbuf = headerBufferSize < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
        this.rejectIllegalHeaderName = rejectIllegalHeader;
        this.httpParser = httpParser;
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    @Override
    public void recycle() {
        this.socket = 0L;
        this.wrapper = null;
        super.recycle();
    }

    @Override
    public boolean parseRequestLine(boolean useAvailableData) throws IOException {
        int start = 0;
        do {
            if (this.pos >= this.lastValid) {
                if (useAvailableData) {
                    return false;
                }
                if (!this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
            }
            if (this.request.getStartTime() < 0L) {
                this.request.setStartTime(System.currentTimeMillis());
            }
            this.chr = this.buf[this.pos++];
        } while (this.chr == 13 || this.chr == 10);
        --this.pos;
        start = this.pos;
        if (this.pos >= this.lastValid) {
            if (useAvailableData) {
                return false;
            }
            if (!this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
        }
        boolean space = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                this.request.method().setBytes(this.buf, start, this.pos - start);
            } else if (!HttpParser.isToken(this.buf[this.pos])) {
                String invalidMethodValue = this.parseInvalid(start, this.buf);
                throw new IllegalArgumentException(sm.getString("iib.invalidmethod", new Object[]{invalidMethodValue}));
            }
            ++this.pos;
        }
        while (space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        int end = 0;
        int questionPos = -1;
        boolean eol = false;
        while (!space) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos - 1] == 13 && this.buf[this.pos] != 10) {
                this.request.protocol().setString("HTTP/1.1");
                String invalidRequestTarget = this.parseInvalid(start, this.buf);
                throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{invalidRequestTarget}));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                space = true;
                end = this.pos;
            } else if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos] == 10) {
                    space = true;
                    this.request.protocol().setString("");
                    eol = true;
                    end = this.buf[this.pos - 1] == 13 ? this.pos - 1 : this.pos;
                } else if (this.buf[this.pos] == 63 && questionPos == -1) {
                    questionPos = this.pos;
                } else {
                    if (questionPos != -1 && !this.httpParser.isQueryRelaxed(this.buf[this.pos])) {
                        String invalidRequestTarget = this.parseInvalid(start, this.buf);
                        throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{invalidRequestTarget}));
                    }
                    if (this.httpParser.isNotRequestTargetRelaxed(this.buf[this.pos])) {
                        String invalidRequestTarget = this.parseInvalid(start, this.buf);
                        throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{invalidRequestTarget}));
                    }
                }
            }
            ++this.pos;
        }
        this.request.unparsedURI().setBytes(this.buf, start, end - start);
        if (questionPos >= 0) {
            this.request.queryString().setBytes(this.buf, questionPos + 1, end - questionPos - 1);
            this.request.requestURI().setBytes(this.buf, start, questionPos - start);
        } else {
            this.request.requestURI().setBytes(this.buf, start, end - start);
        }
        while (space && !eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                ++this.pos;
                continue;
            }
            space = false;
        }
        start = this.pos;
        end = 0;
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] != 13) {
                if (this.buf[this.pos - 1] == 13 && this.buf[this.pos] == 10) {
                    end = this.pos - 1;
                    eol = true;
                } else if (!HttpParser.isHttpProtocol(this.buf[this.pos])) {
                    String invalidProtocol = this.parseInvalid(start, this.buf);
                    throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol", new Object[]{invalidProtocol}));
                }
            }
            ++this.pos;
        }
        if (end - start > 0) {
            this.request.protocol().setBytes(this.buf, start, end - start);
        }
        if (this.request.protocol().isNull()) {
            throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol"));
        }
        return true;
    }

    @Override
    public boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        while (this.parseHeader()) {
        }
        this.parsingHeader = false;
        this.end = this.pos;
        return true;
    }

    private boolean parseHeader() throws IOException {
        int start;
        while (true) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13 || this.prevChr == 13) {
                if (this.prevChr == 13 && this.chr == 10) {
                    ++this.pos;
                    return false;
                }
                if (this.prevChr != 13) break;
                --this.pos;
                break;
            }
            ++this.pos;
        }
        int lineStart = start = this.pos;
        boolean colon = false;
        MessageBytes headerValue = null;
        while (!colon) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.buf[this.pos] == 58) {
                colon = true;
                headerValue = this.headers.addValue(this.buf, start, this.pos - start);
            } else if (!HttpParser.isToken(this.buf[this.pos])) {
                this.skipLine(lineStart, start);
                return true;
            }
            this.chr = this.buf[this.pos];
            if (this.chr >= 65 && this.chr <= 90) {
                this.buf[this.pos] = (byte)(this.chr - -32);
            }
            ++this.pos;
        }
        start = this.pos;
        int realPos = this.pos;
        boolean eol = false;
        boolean validLine = true;
        while (validLine) {
            boolean space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            int lastSignificantChar = realPos;
            while (!eol) {
                if (this.pos >= this.lastValid && !this.fill()) {
                    throw new EOFException(sm.getString("iib.eof.error"));
                }
                this.prevChr = this.chr;
                this.chr = this.buf[this.pos];
                if (this.chr != 13) {
                    if (this.prevChr == 13 && this.chr == 10) {
                        eol = true;
                    } else {
                        if (this.prevChr == 13) {
                            this.headers.removeHeader(this.headers.size() - 1);
                            this.skipLine(lineStart, start);
                            return true;
                        }
                        if (this.chr != 9 && HttpParser.isControl(this.chr)) {
                            this.headers.removeHeader(this.headers.size() - 1);
                            this.skipLine(lineStart, start);
                            return true;
                        }
                        if (this.buf[this.pos] == 32) {
                            this.buf[realPos] = this.buf[this.pos];
                            ++realPos;
                        } else {
                            this.buf[realPos] = this.buf[this.pos];
                            lastSignificantChar = ++realPos;
                        }
                    }
                }
                ++this.pos;
            }
            realPos = lastSignificantChar;
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            byte peek = this.buf[this.pos];
            if (peek != 32 && peek != 9) {
                validLine = false;
                continue;
            }
            eol = false;
            this.buf[realPos] = peek;
            ++realPos;
        }
        headerValue.setBytes(this.buf, start, realPos - start);
        return true;
    }

    private void skipLine(int lineStart, int start) throws IOException {
        boolean eol = false;
        int lastRealByte = start;
        if (this.pos - 1 > start) {
            lastRealByte = this.pos - 1;
        }
        while (!eol) {
            if (this.pos >= this.lastValid && !this.fill()) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13) {
                if (this.prevChr == 13 && this.chr == 10) {
                    eol = true;
                } else {
                    lastRealByte = this.pos;
                }
            }
            ++this.pos;
        }
        if (this.rejectIllegalHeaderName || log.isDebugEnabled()) {
            String message = sm.getString("iib.invalidheader", new Object[]{HeaderUtil.toPrintableString(this.buf, lineStart, lastRealByte - lineStart + 1)});
            if (this.rejectIllegalHeaderName) {
                throw new IllegalArgumentException(message);
            }
            log.debug((Object)message);
        }
    }

    @Override
    public int doRead(ByteChunk chunk, Request req) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(chunk, req);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(chunk, req);
    }

    @Override
    protected void init(SocketWrapper<Long> socketWrapper, AbstractEndpoint<Long> endpoint) throws IOException {
        this.wrapper = socketWrapper;
        this.socket = socketWrapper.getSocket();
        Socket.setrbb(this.socket, this.bbuf);
    }

    @Override
    protected boolean fill(boolean block) throws IOException {
        return this.fill();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean fill() throws IOException {
        int nRead = 0;
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            this.bbuf.clear();
            nRead = Socket.recvbb(this.socket, 0, this.buf.length - this.lastValid);
            if (nRead <= 0) {
                if (-nRead != 120002) throw new IOException(sm.getString("iib.failedread"));
                return false;
            }
            this.bbuf.limit(nRead);
            this.bbuf.get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
            this.bbuf.clear();
            nRead = Socket.recvbb(this.socket, 0, this.buf.length - this.lastValid);
            if (nRead > 0) {
                this.bbuf.limit(nRead);
                this.bbuf.get(this.buf, this.pos, nRead);
                this.lastValid = this.pos + nRead;
            } else {
                if (-nRead == 120005) throw new SocketTimeoutException(sm.getString("iib.failedread"));
                if (-nRead == 120001) {
                    throw new SocketTimeoutException(sm.getString("iib.failedread"));
                }
                if (nRead == 0) {
                    return false;
                }
                if (-nRead != 20014) throw new IOException(sm.getString("iib.failedread"));
                if (!this.wrapper.isSecure()) throw new IOException(sm.getString("iib.failedread"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("iib.apr.sslGeneralError", new Object[]{this.socket, this.wrapper}));
                }
            }
        }
        if (nRead <= 0) return false;
        return true;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalAprInputBuffer.this.pos >= InternalAprInputBuffer.this.lastValid && !InternalAprInputBuffer.this.fill()) {
                return -1;
            }
            int length = InternalAprInputBuffer.this.lastValid - InternalAprInputBuffer.this.pos;
            chunk.setBytes(InternalAprInputBuffer.this.buf, InternalAprInputBuffer.this.pos, length);
            InternalAprInputBuffer.this.pos = InternalAprInputBuffer.this.lastValid;
            return length;
        }

        @Override
        public int available() {
            if (InternalAprInputBuffer.this.lastValid > InternalAprInputBuffer.this.pos) {
                return InternalAprInputBuffer.this.lastValid - InternalAprInputBuffer.this.pos;
            }
            return 0;
        }
    }
}

