/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import edu.umd.marbl.mhap.utils.Interval;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class IntervalNode<Type> {
    private SortedMap<Interval<Type>, List<Interval<Type>>> intervals = new TreeMap<Interval<Type>, List<Interval<Type>>>();
    private long center;
    private IntervalNode<Type> leftNode;
    private IntervalNode<Type> rightNode;

    public IntervalNode() {
        this.center = 0L;
        this.leftNode = null;
        this.rightNode = null;
    }

    public IntervalNode(List<Interval<Type>> intervalList) {
        long median;
        TreeSet<Long> endpoints = new TreeSet<Long>();
        for (Interval<Type> interval : intervalList) {
            endpoints.add(interval.getStart());
            endpoints.add(interval.getEnd());
        }
        this.center = median = this.getMedian(endpoints).longValue();
        ArrayList<Interval<Type>> left = new ArrayList<Interval<Type>>();
        ArrayList<Interval<Type>> right = new ArrayList<Interval<Type>>();
        for (Interval<Type> interval : intervalList) {
            if (interval.getEnd() < median) {
                left.add(interval);
                continue;
            }
            if (interval.getStart() > median) {
                right.add(interval);
                continue;
            }
            ArrayList<Interval<Type>> posting = (ArrayList<Interval<Type>>)this.intervals.get(interval);
            if (posting == null) {
                posting = new ArrayList<Interval<Type>>();
                this.intervals.put(interval, posting);
            }
            posting.add(interval);
        }
        if (left.size() > 0) {
            this.leftNode = new IntervalNode<Type>(left);
        }
        if (right.size() > 0) {
            this.rightNode = new IntervalNode<Type>(right);
        }
    }

    public List<Interval<Type>> stab(long time) {
        ArrayList<Interval<Type>> result = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().contains(time)) {
                for (Interval<Type> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() <= time) continue;
            break;
        }
        if (time < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.stab(time));
        } else if (time > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.stab(time));
        }
        return result;
    }

    public List<Interval<Type>> query(Interval<?> target) {
        ArrayList<Interval<Type>> result = new ArrayList<Interval<Type>>();
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            if (entry.getKey().intersects(target)) {
                for (Interval<Type> interval : entry.getValue()) {
                    result.add(interval);
                }
                continue;
            }
            if (entry.getKey().getStart() <= target.getEnd()) continue;
            break;
        }
        if (target.getStart() < this.center && this.leftNode != null) {
            result.addAll(this.leftNode.query(target));
        }
        if (target.getEnd() > this.center && this.rightNode != null) {
            result.addAll(this.rightNode.query(target));
        }
        return result;
    }

    public long getCenter() {
        return this.center;
    }

    public void setCenter(long center) {
        this.center = center;
    }

    public IntervalNode<Type> getLeft() {
        return this.leftNode;
    }

    public void setLeft(IntervalNode<Type> left) {
        this.leftNode = left;
    }

    public IntervalNode<Type> getRight() {
        return this.rightNode;
    }

    public void setRight(IntervalNode<Type> right) {
        this.rightNode = right;
    }

    private Long getMedian(SortedSet<Long> set) {
        int i = 0;
        int middle = set.size() / 2;
        for (Long point : set) {
            if (i == middle) {
                return point;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.center + ": ");
        for (Map.Entry<Interval<Type>, List<Interval<Type>>> entry : this.intervals.entrySet()) {
            sb.append("[" + entry.getKey().getStart() + "," + entry.getKey().getEnd() + "]:{");
            for (Interval<Type> interval : entry.getValue()) {
                sb.append("(" + interval.getStart() + "," + interval.getEnd() + "," + interval.getData() + ")");
            }
            sb.append("} ");
        }
        return sb.toString();
    }
}

