/*
 * Decompiled with CFR 0.152.
 */
package jaligner;

import jaligner.Sequence;
import jaligner.matrix.Matrix;
import jaligner.util.Commons;
import java.text.DecimalFormat;

public final class Alignment {
    public static final char GAP = '-';
    private static final String SEQUENCE1 = "jaligner_1";
    private static final String SEQUENCE2 = "jaligner_2";
    private Matrix matrix;
    private float open;
    private float extend;
    private float score;
    private char[] sequence1;
    private String name1;
    private int start1;
    private char[] sequence2;
    private String name2;
    private int start2;
    private char[] markupLine;
    private int identity;
    private int similarity;
    private int gaps;
    private Sequence originalSequence1;
    private Sequence originalSequence2;

    public float getExtend() {
        return this.extend;
    }

    public void setExtend(float extend) {
        this.extend = extend;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public String getName1() {
        return this.name1 == null || this.name1.trim().length() == 0 ? SEQUENCE1 : this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2 == null || this.name2.trim().length() == 0 ? SEQUENCE2 : this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public float getOpen() {
        return this.open;
    }

    public void setOpen(float open) {
        this.open = open;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public int getLength() {
        return this.sequence1.length;
    }

    public char[] getSequence1() {
        return this.sequence1;
    }

    public void setSequence1(char[] sequence1) {
        this.sequence1 = sequence1;
    }

    public char[] getSequence2() {
        return this.sequence2;
    }

    public void setSequence2(char[] sequence2) {
        this.sequence2 = sequence2;
    }

    public int getStart1() {
        return this.start1;
    }

    public void setStart1(int start1) {
        this.start1 = start1;
    }

    public int getStart2() {
        return this.start2;
    }

    public void setStart2(int start2) {
        this.start2 = start2;
    }

    public int getGaps() {
        return this.gaps;
    }

    public void setGaps(int gaps) {
        this.gaps = gaps;
    }

    public int getIdentity() {
        return this.identity;
    }

    public void setIdentity(int identity) {
        this.identity = identity;
    }

    public char[] getMarkupLine() {
        return this.markupLine;
    }

    public void setMarkupLine(char[] markupLine) {
        this.markupLine = markupLine;
    }

    public int getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(int similarity) {
        this.similarity = similarity;
    }

    public String getSummary() {
        StringBuffer buffer = new StringBuffer();
        DecimalFormat f1 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("0.00%");
        int length = this.getSequence1().length;
        buffer.append("Sequence #1: " + this.getName1());
        buffer.append(Commons.getLineSeparator());
        buffer.append("Sequence #2: " + this.getName2());
        buffer.append(Commons.getLineSeparator());
        buffer.append("Length #1: " + this.getOriginalSequence1().length());
        buffer.append(Commons.getLineSeparator());
        buffer.append("Length #2: " + this.getOriginalSequence2().length());
        buffer.append(Commons.getLineSeparator());
        buffer.append("Matrix: " + (this.matrix.getId() == null ? "" : this.matrix.getId()));
        buffer.append(Commons.getLineSeparator());
        buffer.append("Gap open: " + this.open);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Gap extend: " + this.extend);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Length: " + length);
        buffer.append(Commons.getLineSeparator());
        buffer.append("Identity: " + this.identity + "/" + length + " (" + f2.format((float)this.identity / (float)length) + ")");
        buffer.append(Commons.getLineSeparator());
        buffer.append("Similarity: " + this.similarity + "/" + length + " (" + f2.format((float)this.similarity / (float)length) + ")");
        buffer.append(Commons.getLineSeparator());
        buffer.append("Gaps: " + this.gaps + "/" + length + " (" + f2.format((float)this.gaps / (float)length) + ")");
        buffer.append(Commons.getLineSeparator());
        buffer.append("Score: " + f1.format(this.score));
        buffer.append(Commons.getLineSeparator());
        return buffer.toString();
    }

    public float calculateScore() {
        float calcScore = 0.0f;
        boolean previous1wasGap = false;
        boolean previous2wasGap = false;
        int start = 0;
        int end = this.sequence1.length - 1;
        for (int i = start; i <= end; ++i) {
            char c1 = this.sequence1[i];
            char c2 = this.sequence2[i];
            if (c1 == '-') {
                calcScore = previous1wasGap ? (calcScore -= this.extend) : (calcScore -= this.open);
                previous1wasGap = true;
                previous2wasGap = false;
                continue;
            }
            if (c2 == '-') {
                calcScore = previous2wasGap ? (calcScore -= this.extend) : (calcScore -= this.open);
                previous1wasGap = false;
                previous2wasGap = true;
                continue;
            }
            calcScore += this.matrix.getScore(c1, c2);
            previous1wasGap = false;
            previous2wasGap = false;
        }
        return calcScore;
    }

    public float getScoreWithNoTerminalGaps() {
        float calcScore = 0.0f;
        boolean previous1wasGap = false;
        boolean previous2wasGap = false;
        int start = 0;
        int end = this.sequence1.length - 1;
        if (this.sequence1[start] == '-') {
            while (this.sequence1[start] == '-') {
                ++start;
            }
        } else if (this.sequence2[start] == '-') {
            while (this.sequence2[start] == '-') {
                ++start;
            }
        }
        if (this.sequence1[end] == '-') {
            while (this.sequence1[end] == '-') {
                --end;
            }
        } else if (this.sequence2[end] == '-') {
            while (this.sequence2[end] == '-') {
                --end;
            }
        }
        for (int i = start; i <= end; ++i) {
            char c1 = this.sequence1[i];
            char c2 = this.sequence2[i];
            if (c1 == '-') {
                calcScore = previous1wasGap ? (calcScore -= this.extend) : (calcScore -= this.open);
                previous1wasGap = true;
                previous2wasGap = false;
                continue;
            }
            if (c2 == '-') {
                calcScore = previous2wasGap ? (calcScore -= this.extend) : (calcScore -= this.open);
                previous1wasGap = false;
                previous2wasGap = true;
                continue;
            }
            calcScore += this.matrix.getScore(c1, c2);
            previous1wasGap = false;
            previous2wasGap = false;
        }
        return calcScore;
    }

    public boolean checkScore() {
        return this.calculateScore() == this.score;
    }

    public Sequence getOriginalSequence1() {
        return this.originalSequence1;
    }

    public void setOriginalSequence1(Sequence originalSequence1) {
        this.originalSequence1 = originalSequence1;
    }

    public Sequence getOriginalSequence2() {
        return this.originalSequence2;
    }

    public void setOriginalSequence2(Sequence originalSequence2) {
        this.originalSequence2 = originalSequence2;
    }

    public int getGaps1() {
        int count = 0;
        int n = this.sequence1.length;
        for (int i = 0; i < n; ++i) {
            if (this.sequence1[i] != '-') continue;
            ++count;
        }
        return count;
    }

    public int getGaps2() {
        int count = 0;
        int n = this.sequence2.length;
        for (int i = 0; i < n; ++i) {
            if (this.sequence2[i] != '-') continue;
            ++count;
        }
        return count;
    }

    public static Alignment add(Alignment a1, Alignment a2) {
        if (a1 == null) {
            if (a2 == null) {
                return null;
            }
            return Alignment.copy(a2);
        }
        if (a2 == null) {
            return Alignment.copy(a1);
        }
        Alignment sum = new Alignment();
        StringBuffer buffer = new StringBuffer();
        buffer.append(a1.getOriginalSequence1());
        buffer.append(a2.getOriginalSequence1());
        sum.setOriginalSequence1(new Sequence(buffer.toString()));
        buffer = new StringBuffer();
        buffer.append(a1.getOriginalSequence2());
        buffer.append(a2.getOriginalSequence2());
        sum.setOriginalSequence2(new Sequence(buffer.toString()));
        buffer = new StringBuffer();
        buffer.append(a1.getSequence1());
        buffer.append(a2.getSequence1());
        sum.setSequence1(buffer.toString().toCharArray());
        buffer = new StringBuffer();
        buffer.append(a1.getSequence2());
        buffer.append(a2.getSequence2());
        sum.setSequence2(buffer.toString().toCharArray());
        buffer = new StringBuffer();
        buffer.append(a1.getMarkupLine());
        buffer.append(a2.getMarkupLine());
        sum.setMarkupLine(buffer.toString().toCharArray());
        sum.setScore(a1.getScore() + a2.getScore());
        sum.setGaps(a1.getGaps() + a2.getGaps());
        sum.setStart1(a1.getStart1());
        sum.setStart2(a1.getStart2());
        sum.setExtend(a1.getExtend());
        sum.setOpen(a1.getOpen());
        sum.setMatrix(a1.getMatrix());
        return sum;
    }

    public static Alignment copy(Alignment alignment) {
        Alignment copy = new Alignment();
        copy.setSequence1(alignment.getSequence1());
        copy.setSequence2(alignment.getSequence2());
        copy.setMarkupLine(alignment.getMarkupLine());
        copy.setScore(alignment.getScore());
        copy.setGaps(alignment.getGaps());
        copy.setStart1(alignment.getStart1());
        copy.setStart2(alignment.getStart2());
        copy.setExtend(alignment.getExtend());
        copy.setOpen(alignment.getOpen());
        copy.setMatrix(alignment.getMatrix());
        copy.setOriginalSequence1(alignment.getOriginalSequence1());
        copy.setOriginalSequence2(alignment.getOriginalSequence2());
        return copy;
    }
}

