/* -*- Mode: C; c-file-style: "gnu" -*-
   classpath.h -- Class path operations (directories, zip files, and jars).
   Created: Chris Toshok <toshok@hungry.com>, 21-May-1997
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _classpath_h
#define _classpath_h

#include "zipfile.h"

#ifdef __cplusplus
extern "C" {
#endif

  typedef enum {
    CP_NONE, /* error value -- means not a directory, zip, or jar file */
    CP_DIR,
    CP_ZIP,
    CP_JAR
  } ClassPathEntryType;

  typedef struct {
    ClassPathEntryType type;
    char *path;
    struct ZipFile zip; /* used for zip's and jar's */
  } ClasspathEntry;

  JNIEXPORT void JNICALL CLASSPATH_create(const char *spec, ClasspathEntry **entries, int *num_entries);
  JNIEXPORT void JNICALL CLASSPATH_destroy(ClasspathEntry *entries, int num_entries);
  JNIEXPORT char* JNICALL CLASSPATH_getSystemClasspath(void);

#ifdef __cplusplus
};
#endif

#endif /* _classpath_h */
