/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.ThreadUtils;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.RoundTripWorkloadSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundTripWorker
implements TaskWorker {
    private static final int THROTTLE_PERIOD_MS = 100;
    private static final int VALUE_SIZE = 512;
    private static final int LOG_INTERVAL_MS = 5000;
    private static final int LOG_NUM_MESSAGES = 10;
    private static final String TOPIC_NAME = "round_trip_topic";
    private static final Logger log = LoggerFactory.getLogger(RoundTripWorker.class);
    private final ToReceiveTracker toReceiveTracker = new ToReceiveTracker();
    private final String id;
    private final RoundTripWorkloadSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private ExecutorService executor;
    private KafkaFutureImpl<String> doneFuture;
    private KafkaProducer<String, byte[]> producer;
    private KafkaConsumer<String, byte[]> consumer;
    private CountDownLatch unackedSends;

    public RoundTripWorker(String id, RoundTripWorkloadSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void start(Platform platform, AtomicReference<String> status, KafkaFutureImpl<String> doneFuture) throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("RoundTripWorker is already running.");
        }
        log.info("{}: Activating RoundTripWorker.", (Object)this.id);
        this.executor = Executors.newCachedThreadPool(ThreadUtils.createThreadFactory("RoundTripWorker%d", false));
        this.doneFuture = doneFuture;
        this.producer = null;
        this.consumer = null;
        this.unackedSends = new CountDownLatch(this.spec.maxMessages());
        this.executor.submit(new Prepare());
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("ProduceBenchWorker is not running.");
        }
        log.info("{}: Deactivating RoundTripWorkloadWorker.", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.executor.shutdownNow();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
        Utils.closeQuietly(this.consumer, (String)"consumer");
        Utils.closeQuietly(this.producer, (String)"producer");
        this.consumer = null;
        this.producer = null;
        this.unackedSends = null;
        this.executor = null;
        this.doneFuture = null;
    }

    class ConsumerRunnable
    implements Runnable {
        private final Properties props = new Properties();

        ConsumerRunnable() {
            this.props.put("bootstrap.servers", RoundTripWorker.this.spec.bootstrapServers());
            this.props.put("client.id", "consumer." + RoundTripWorker.this.id);
            this.props.put("group.id", "round-trip-consumer-group-1");
            this.props.put("auto.offset.reset", "earliest");
            this.props.put("request.timeout.ms", (Object)105000);
            this.props.put("max.poll.interval.ms", (Object)100000);
            RoundTripWorker.this.consumer = new KafkaConsumer(this.props, (Deserializer)new StringDeserializer(), (Deserializer)new ByteArrayDeserializer());
            RoundTripWorker.this.consumer.subscribe(Collections.singleton(RoundTripWorker.TOPIC_NAME));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block11: {
                uniqueMessagesReceived = 0L;
                messagesReceived = 0L;
                pollInvoked = 0L;
                RoundTripWorker.access$200().debug("{}: Starting RoundTripWorker#ConsumerRunnable.", (Object)RoundTripWorker.access$500(RoundTripWorker.this));
                try {
                    lastLogTimeMs = Time.SYSTEM.milliseconds();
lbl7:
                    // 3 sources

                    while (true) {
                        try {
                            ++pollInvoked;
                            records = RoundTripWorker.access$900(RoundTripWorker.this).poll(50L);
                            for (ConsumerRecord record : records.records("round_trip_topic")) {
                                messageIndex = Integer.parseInt((String)record.key());
                                ++messagesReceived;
                                if (!RoundTripWorker.access$700(RoundTripWorker.this).removePending(messageIndex) || ++uniqueMessagesReceived < (long)RoundTripWorker.access$100(RoundTripWorker.this).maxMessages()) continue;
                                RoundTripWorker.access$200().info("{}: Consumer received the full count of {} unique messages.  Waiting for all sends to be acked...", (Object)RoundTripWorker.access$500(RoundTripWorker.this), (Object)RoundTripWorker.access$100(RoundTripWorker.this).maxMessages());
                                RoundTripWorker.access$800(RoundTripWorker.this).await();
                                RoundTripWorker.access$200().info("{}: all sends have been acked.", (Object)RoundTripWorker.access$500(RoundTripWorker.this));
                                RoundTripWorker.access$400(RoundTripWorker.this).complete((Object)"");
                                break block11;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (WakeupException e) {
                            RoundTripWorker.access$200().debug("{}: Consumer got WakeupException", (Object)RoundTripWorker.access$500(RoundTripWorker.this), (Object)e);
                        }
                        catch (TimeoutException e) {
                            RoundTripWorker.access$200().debug("{}: Consumer got TimeoutException", (Object)RoundTripWorker.access$500(RoundTripWorker.this), (Object)e);
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    WorkerUtils.abort(RoundTripWorker.access$200(), "ConsumerRunnable", e, (KafkaFutureImpl<String>)RoundTripWorker.access$400(RoundTripWorker.this));
                    RoundTripWorker.access$200().info("{}: ConsumerRunnable is exiting.  Invoked poll {} time(s).  messagesReceived = {}; uniqueMessagesReceived = {}.", new Object[]{RoundTripWorker.access$500(RoundTripWorker.this), pollInvoked, messagesReceived, uniqueMessagesReceived});
                    return;
                }
                catch (Throwable var13_13) {
                    RoundTripWorker.access$200().info("{}: ConsumerRunnable is exiting.  Invoked poll {} time(s).  messagesReceived = {}; uniqueMessagesReceived = {}.", new Object[]{RoundTripWorker.access$500(RoundTripWorker.this), pollInvoked, messagesReceived, uniqueMessagesReceived});
                    throw var13_13;
                }
            }
            RoundTripWorker.access$200().info("{}: ConsumerRunnable is exiting.  Invoked poll {} time(s).  messagesReceived = {}; uniqueMessagesReceived = {}.", new Object[]{RoundTripWorker.access$500(RoundTripWorker.this), pollInvoked, messagesReceived, uniqueMessagesReceived});
            return;
lbl-1000:
            // 1 sources

            {
                curTimeMs = Time.SYSTEM.milliseconds();
                if (curTimeMs <= lastLogTimeMs + 5000L) ** GOTO lbl7
                RoundTripWorker.access$700(RoundTripWorker.this).log();
                lastLogTimeMs = curTimeMs;
                ** continue;
            }
        }
    }

    private class ToReceiveTracker {
        private final TreeSet<Integer> pending = new TreeSet();

        private ToReceiveTracker() {
        }

        synchronized void addPending(int messageIndex) {
            this.pending.add(messageIndex);
        }

        synchronized boolean removePending(int messageIndex) {
            return this.pending.remove(messageIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void log() {
            int numToReceive;
            ArrayList<Integer> list = new ArrayList<Integer>(10);
            ToReceiveTracker toReceiveTracker = this;
            synchronized (toReceiveTracker) {
                numToReceive = this.pending.size();
                Iterator<Integer> iter = this.pending.iterator();
                while (iter.hasNext() && list.size() < 10) {
                    Integer i = iter.next();
                    list.add(i);
                }
            }
            log.info("{}: consumer waiting for {} message(s), starting with: {}", new Object[]{RoundTripWorker.this.id, numToReceive, Utils.join(list, (String)", ")});
        }
    }

    class ProducerRunnable
    implements Runnable {
        private final Throttle throttle;

        ProducerRunnable() {
            Properties props = new Properties();
            props.put("bootstrap.servers", RoundTripWorker.this.spec.bootstrapServers());
            props.put("batch.size", (Object)16384);
            props.put("buffer.memory", (Object)65536L);
            props.put("max.block.ms", (Object)1000L);
            props.put("client.id", "producer." + RoundTripWorker.this.id);
            props.put("acks", "all");
            props.put("request.timeout.ms", (Object)105000);
            RoundTripWorker.this.producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
            int perPeriod = WorkerUtils.perSecToPerPeriod(RoundTripWorker.this.spec.targetMessagesPerSec(), 100L);
            this.throttle = new Throttle(perPeriod, 100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] value = new byte[512];
            final ToSendTracker toSendTracker = new ToSendTracker(RoundTripWorker.this.spec.maxMessages());
            long messagesSent = 0L;
            long uniqueMessagesSent = 0L;
            log.debug("{}: Starting RoundTripWorker#ProducerRunnable.", (Object)RoundTripWorker.this.id);
            try {
                ToSendTrackerResult result;
                while ((result = toSendTracker.next()) != null) {
                    this.throttle.increment();
                    final int messageIndex = result.index;
                    if (result.firstSend) {
                        RoundTripWorker.this.toReceiveTracker.addPending(messageIndex);
                        ++uniqueMessagesSent;
                    }
                    ++messagesSent;
                    ProducerRecord record = new ProducerRecord(RoundTripWorker.TOPIC_NAME, Integer.valueOf(0), (Object)String.valueOf(messageIndex), (Object)value);
                    RoundTripWorker.this.producer.send(record, new Callback(){

                        public void onCompletion(RecordMetadata metadata, Exception exception) {
                            if (exception == null) {
                                RoundTripWorker.this.unackedSends.countDown();
                            } else {
                                log.info("{}: Got exception when sending message {}: {}", new Object[]{RoundTripWorker.this.id, messageIndex, exception.getMessage()});
                                toSendTracker.addFailed(messageIndex);
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                try {
                    WorkerUtils.abort(log, "ProducerRunnable", e, (KafkaFutureImpl<String>)RoundTripWorker.this.doneFuture);
                }
                catch (Throwable throwable) {
                    log.info("{}: ProducerRunnable is exiting.  messagesSent={}; uniqueMessagesSent={}; ackedSends={}.", new Object[]{RoundTripWorker.this.id, messagesSent, uniqueMessagesSent, (long)RoundTripWorker.this.spec.maxMessages() - RoundTripWorker.this.unackedSends.getCount()});
                    throw throwable;
                }
                log.info("{}: ProducerRunnable is exiting.  messagesSent={}; uniqueMessagesSent={}; ackedSends={}.", new Object[]{RoundTripWorker.this.id, messagesSent, uniqueMessagesSent, (long)RoundTripWorker.this.spec.maxMessages() - RoundTripWorker.this.unackedSends.getCount()});
            }
            log.info("{}: ProducerRunnable is exiting.  messagesSent={}; uniqueMessagesSent={}; ackedSends={}.", new Object[]{RoundTripWorker.this.id, messagesSent, uniqueMessagesSent, (long)RoundTripWorker.this.spec.maxMessages() - RoundTripWorker.this.unackedSends.getCount()});
        }
    }

    private static class ToSendTracker {
        private final int maxMessages;
        private final List<Integer> failed = new ArrayList<Integer>();
        private int frontier = 0;

        ToSendTracker(int maxMessages) {
            this.maxMessages = maxMessages;
        }

        synchronized void addFailed(int index) {
            this.failed.add(index);
        }

        synchronized ToSendTrackerResult next() {
            if (this.failed.isEmpty()) {
                if (this.frontier >= this.maxMessages) {
                    return null;
                }
                return new ToSendTrackerResult(this.frontier++, true);
            }
            return new ToSendTrackerResult(this.failed.remove(0), false);
        }
    }

    private static class ToSendTrackerResult {
        final int index;
        final boolean firstSend;

        ToSendTrackerResult(int index, boolean firstSend) {
            this.index = index;
            this.firstSend = firstSend;
        }
    }

    class Prepare
    implements Runnable {
        Prepare() {
        }

        @Override
        public void run() {
            try {
                if (RoundTripWorker.this.spec.targetMessagesPerSec() <= 0) {
                    throw new ConfigException("Can't have targetMessagesPerSec <= 0.");
                }
                if (RoundTripWorker.this.spec.partitionAssignments() == null || RoundTripWorker.this.spec.partitionAssignments().isEmpty()) {
                    throw new ConfigException("Invalid null or empty partitionAssignments.");
                }
                WorkerUtils.createTopics(log, RoundTripWorker.this.spec.bootstrapServers(), Collections.singletonList(new NewTopic(RoundTripWorker.TOPIC_NAME, RoundTripWorker.this.spec.partitionAssignments())));
                RoundTripWorker.this.executor.submit(new ProducerRunnable());
                RoundTripWorker.this.executor.submit(new ConsumerRunnable());
            }
            catch (Throwable e) {
                WorkerUtils.abort(log, "Prepare", e, (KafkaFutureImpl<String>)RoundTripWorker.this.doneFuture);
            }
        }
    }
}

