/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_subject_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_SUBJECT_BASE_HPP
#define OBJECTS_BLAST_BLAST4_SUBJECT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBioseq;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_subject_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_subject_Base(void);
    // destructor
    virtual ~CBlast4_subject_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,   ///< No variant selected
        e_Database,
        e_Sequences,
        e_Seq_loc_list
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Seq_loc_list+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TDatabase;
    typedef list< CRef< CBioseq > > TSequences;
    typedef list< CRef< CSeq_loc > > TSeq_loc_list;

    // getters
    // setters

    // typedef string TDatabase
    bool IsDatabase(void) const;
    const TDatabase& GetDatabase(void) const;
    TDatabase& SetDatabase(void);
    void SetDatabase(const TDatabase& value);

    // typedef list< CRef< CBioseq > > TSequences
    bool IsSequences(void) const;
    const TSequences& GetSequences(void) const;
    TSequences& SetSequences(void);

    // typedef list< CRef< CSeq_loc > > TSeq_loc_list
    bool IsSeq_loc_list(void) const;
    const TSeq_loc_list& GetSeq_loc_list(void) const;
    TSeq_loc_list& SetSeq_loc_list(void);


private:
    // copy constructor and assignment operator
    CBlast4_subject_Base(const CBlast4_subject_Base& );
    CBlast4_subject_Base& operator=(const CBlast4_subject_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TSequences> m_Sequences;
        NCBI_NS_NCBI::CUnionBuffer<TSeq_loc_list> m_Seq_loc_list;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBlast4_subject_Base::E_Choice CBlast4_subject_Base::Which(void) const
{
    return m_choice;
}

inline
void CBlast4_subject_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBlast4_subject_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBlast4_subject_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBlast4_subject_Base::IsDatabase(void) const
{
    return m_choice == e_Database;
}

inline
const CBlast4_subject_Base::TDatabase& CBlast4_subject_Base::GetDatabase(void) const
{
    CheckSelected(e_Database);
    return *m_string;
}

inline
CBlast4_subject_Base::TDatabase& CBlast4_subject_Base::SetDatabase(void)
{
    Select(e_Database, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBlast4_subject_Base::IsSequences(void) const
{
    return m_choice == e_Sequences;
}

inline
const CBlast4_subject_Base::TSequences& CBlast4_subject_Base::GetSequences(void) const
{
    CheckSelected(e_Sequences);
    return *m_Sequences;
}

inline
CBlast4_subject_Base::TSequences& CBlast4_subject_Base::SetSequences(void)
{
    Select(e_Sequences, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Sequences;
}

inline
bool CBlast4_subject_Base::IsSeq_loc_list(void) const
{
    return m_choice == e_Seq_loc_list;
}

inline
const CBlast4_subject_Base::TSeq_loc_list& CBlast4_subject_Base::GetSeq_loc_list(void) const
{
    CheckSelected(e_Seq_loc_list);
    return *m_Seq_loc_list;
}

inline
CBlast4_subject_Base::TSeq_loc_list& CBlast4_subject_Base::SetSeq_loc_list(void)
{
    Select(e_Seq_loc_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seq_loc_list;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_SUBJECT_BASE_HPP
