/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_get_seq_parts_reques_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST_GET_SEQ_PARTS_REQUES_BASE_HPP
#define OBJECTS_BLAST_BLAST_GET_SEQ_PARTS_REQUES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_database;
class CSeq_interval;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Fetch parts of sequences from a BLAST database
class NCBI_BLAST_EXPORT CBlast4_get_seq_parts_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_get_seq_parts_request_Base(void);
    // destructor
    virtual ~CBlast4_get_seq_parts_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBlast4_database TDatabase;
    typedef list< CRef< CSeq_interval > > TSeq_locations;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_database,
        e_seq_locations
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Name of the BLAST database from which to retrieve the sequence data
    /// mandatory
    /// typedef CBlast4_database TDatabase
    ///  Check whether the Database data member has been assigned a value.
    bool IsSetDatabase(void) const;
    /// Check whether it is safe or not to call GetDatabase method.
    bool CanGetDatabase(void) const;
    void ResetDatabase(void);
    const TDatabase& GetDatabase(void) const;
    void SetDatabase(TDatabase& value);
    TDatabase& SetDatabase(void);

    /// Allows the specification of ranges of sequence data needed.
    /// If the sequence(s) interval's end is 0, no data will be fetched. 
    /// If end is past the length of the sequence, it will be adjusted to the
    /// end of the sequence (this allows fetching of the first chunk in
    /// cases where the length is not yet known).
    /// mandatory
    /// typedef list< CRef< CSeq_interval > > TSeq_locations
    ///  Check whether the Seq_locations data member has been assigned a value.
    bool IsSetSeq_locations(void) const;
    /// Check whether it is safe or not to call GetSeq_locations method.
    bool CanGetSeq_locations(void) const;
    void ResetSeq_locations(void);
    const TSeq_locations& GetSeq_locations(void) const;
    TSeq_locations& SetSeq_locations(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_get_seq_parts_request_Base(const CBlast4_get_seq_parts_request_Base&);
    CBlast4_get_seq_parts_request_Base& operator=(const CBlast4_get_seq_parts_request_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDatabase > m_Database;
    list< CRef< CSeq_interval > > m_Seq_locations;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_get_seq_parts_request_Base::IsSetDatabase(void) const
{
    return m_Database.NotEmpty();
}

inline
bool CBlast4_get_seq_parts_request_Base::CanGetDatabase(void) const
{
    return true;
}

inline
const CBlast4_get_seq_parts_request_Base::TDatabase& CBlast4_get_seq_parts_request_Base::GetDatabase(void) const
{
    if ( !m_Database ) {
        const_cast<CBlast4_get_seq_parts_request_Base*>(this)->ResetDatabase();
    }
    return (*m_Database);
}

inline
CBlast4_get_seq_parts_request_Base::TDatabase& CBlast4_get_seq_parts_request_Base::SetDatabase(void)
{
    if ( !m_Database ) {
        ResetDatabase();
    }
    return (*m_Database);
}

inline
bool CBlast4_get_seq_parts_request_Base::IsSetSeq_locations(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_get_seq_parts_request_Base::CanGetSeq_locations(void) const
{
    return true;
}

inline
const CBlast4_get_seq_parts_request_Base::TSeq_locations& CBlast4_get_seq_parts_request_Base::GetSeq_locations(void) const
{
    return m_Seq_locations;
}

inline
CBlast4_get_seq_parts_request_Base::TSeq_locations& CBlast4_get_seq_parts_request_Base::SetSeq_locations(void)
{
    m_set_State[0] |= 0x4;
    return m_Seq_locations;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST_GET_SEQ_PARTS_REQUES_BASE_HPP
