/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file FeatDispGroup_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'featdef.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_FEATDEF_FEATDISPGROUP_BASE_HPP
#define OBJECTS_FEATDEF_FEATDISPGROUP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_FEATDEF_EXPORT CFeatDispGroup_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFeatDispGroup_Base(void);
    // destructor
    virtual ~CFeatDispGroup_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TGroupkey;
    typedef string TGroupname;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_groupkey,
        e_groupname
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TGroupkey
    ///  Check whether the Groupkey data member has been assigned a value.
    bool IsSetGroupkey(void) const;
    /// Check whether it is safe or not to call GetGroupkey method.
    bool CanGetGroupkey(void) const;
    void ResetGroupkey(void);
    TGroupkey GetGroupkey(void) const;
    void SetGroupkey(TGroupkey value);
    TGroupkey& SetGroupkey(void);

    /// mandatory
    /// typedef string TGroupname
    ///  Check whether the Groupname data member has been assigned a value.
    bool IsSetGroupname(void) const;
    /// Check whether it is safe or not to call GetGroupname method.
    bool CanGetGroupname(void) const;
    void ResetGroupname(void);
    const TGroupname& GetGroupname(void) const;
    void SetGroupname(const TGroupname& value);
    void SetGroupname(TGroupname&& value);
    TGroupname& SetGroupname(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFeatDispGroup_Base(const CFeatDispGroup_Base&);
    CFeatDispGroup_Base& operator=(const CFeatDispGroup_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Groupkey;
    string m_Groupname;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFeatDispGroup_Base::IsSetGroupkey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFeatDispGroup_Base::CanGetGroupkey(void) const
{
    return IsSetGroupkey();
}

inline
void CFeatDispGroup_Base::ResetGroupkey(void)
{
    m_Groupkey = 0;
    m_set_State[0] &= ~0x3;
}

inline
CFeatDispGroup_Base::TGroupkey CFeatDispGroup_Base::GetGroupkey(void) const
{
    if (!CanGetGroupkey()) {
        ThrowUnassigned(0);
    }
    return m_Groupkey;
}

inline
void CFeatDispGroup_Base::SetGroupkey(CFeatDispGroup_Base::TGroupkey value)
{
    m_Groupkey = value;
    m_set_State[0] |= 0x3;
}

inline
CFeatDispGroup_Base::TGroupkey& CFeatDispGroup_Base::SetGroupkey(void)
{
#ifdef _DEBUG
    if (!IsSetGroupkey()) {
        memset(&m_Groupkey,UnassignedByte(),sizeof(m_Groupkey));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Groupkey;
}

inline
bool CFeatDispGroup_Base::IsSetGroupname(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CFeatDispGroup_Base::CanGetGroupname(void) const
{
    return IsSetGroupname();
}

inline
const CFeatDispGroup_Base::TGroupname& CFeatDispGroup_Base::GetGroupname(void) const
{
    if (!CanGetGroupname()) {
        ThrowUnassigned(1);
    }
    return m_Groupname;
}

inline
void CFeatDispGroup_Base::SetGroupname(const CFeatDispGroup_Base::TGroupname& value)
{
    m_Groupname = value;
    m_set_State[0] |= 0xc;
}

inline
void CFeatDispGroup_Base::SetGroupname(CFeatDispGroup_Base::TGroupname&& value)
{
    m_Groupname = std::forward<CFeatDispGroup_Base::TGroupname>(value);
    m_set_State[0] |= 0xc;
}

inline
CFeatDispGroup_Base::TGroupname& CFeatDispGroup_Base::SetGroupname(void)
{
#ifdef _DEBUG
    if (!IsSetGroupname()) {
        m_Groupname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Groupname;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_FEATDEF_FEATDISPGROUP_BASE_HPP
