/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ProjectAnnot_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_PROJECTANNOT_BASE_HPP
#define OBJECTS_GBPROJ_PROJECTANNOT_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAnnotdesc;
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CProjectAnnot_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProjectAnnot_Base(void);
    // destructor
    virtual ~CProjectAnnot_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CDate TCreate_date;
    typedef CDate TModified_date;
    typedef CAnnotdesc TAnnot;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_create_date,
        e_modified_date,
        e_annot
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CDate TCreate_date
    ///  Check whether the Create_date data member has been assigned a value.
    bool IsSetCreate_date(void) const;
    /// Check whether it is safe or not to call GetCreate_date method.
    bool CanGetCreate_date(void) const;
    void ResetCreate_date(void);
    const TCreate_date& GetCreate_date(void) const;
    void SetCreate_date(TCreate_date& value);
    TCreate_date& SetCreate_date(void);

    /// optional
    /// typedef CDate TModified_date
    ///  Check whether the Modified_date data member has been assigned a value.
    bool IsSetModified_date(void) const;
    /// Check whether it is safe or not to call GetModified_date method.
    bool CanGetModified_date(void) const;
    void ResetModified_date(void);
    const TModified_date& GetModified_date(void) const;
    void SetModified_date(TModified_date& value);
    TModified_date& SetModified_date(void);

    /// mandatory
    /// typedef CAnnotdesc TAnnot
    ///  Check whether the Annot data member has been assigned a value.
    bool IsSetAnnot(void) const;
    /// Check whether it is safe or not to call GetAnnot method.
    bool CanGetAnnot(void) const;
    void ResetAnnot(void);
    const TAnnot& GetAnnot(void) const;
    void SetAnnot(TAnnot& value);
    TAnnot& SetAnnot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProjectAnnot_Base(const CProjectAnnot_Base&);
    CProjectAnnot_Base& operator=(const CProjectAnnot_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TCreate_date > m_Create_date;
    CRef< TModified_date > m_Modified_date;
    CRef< TAnnot > m_Annot;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProjectAnnot_Base::IsSetCreate_date(void) const
{
    return m_Create_date.NotEmpty();
}

inline
bool CProjectAnnot_Base::CanGetCreate_date(void) const
{
    return true;
}

inline
const CProjectAnnot_Base::TCreate_date& CProjectAnnot_Base::GetCreate_date(void) const
{
    if ( !m_Create_date ) {
        const_cast<CProjectAnnot_Base*>(this)->ResetCreate_date();
    }
    return (*m_Create_date);
}

inline
CProjectAnnot_Base::TCreate_date& CProjectAnnot_Base::SetCreate_date(void)
{
    if ( !m_Create_date ) {
        ResetCreate_date();
    }
    return (*m_Create_date);
}

inline
bool CProjectAnnot_Base::IsSetModified_date(void) const
{
    return m_Modified_date.NotEmpty();
}

inline
bool CProjectAnnot_Base::CanGetModified_date(void) const
{
    return IsSetModified_date();
}

inline
const CProjectAnnot_Base::TModified_date& CProjectAnnot_Base::GetModified_date(void) const
{
    if (!CanGetModified_date()) {
        ThrowUnassigned(1);
    }
    return (*m_Modified_date);
}

inline
bool CProjectAnnot_Base::IsSetAnnot(void) const
{
    return m_Annot.NotEmpty();
}

inline
bool CProjectAnnot_Base::CanGetAnnot(void) const
{
    return true;
}

inline
const CProjectAnnot_Base::TAnnot& CProjectAnnot_Base::GetAnnot(void) const
{
    if ( !m_Annot ) {
        const_cast<CProjectAnnot_Base*>(this)->ResetAnnot();
    }
    return (*m_Annot);
}

inline
CProjectAnnot_Base::TAnnot& CProjectAnnot_Base::SetAnnot(void)
{
    if ( !m_Annot ) {
        ResetAnnot();
    }
    return (*m_Annot);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_PROJECTANNOT_BASE_HPP
