/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBL_Data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genesbyloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENESBYLOC_GBL_DATA_BASE_HPP
#define OBJECTS_GENESBYLOC_GBL_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGBL_Gene;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENESBYLOC_EXPORT CGBL_Data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGBL_Data_Base(void);
    // destructor
    virtual ~CGBL_Data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TTotal;
    typedef int TReturned;
    typedef list< CRef< CGBL_Gene > > TGenes;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_total,
        e_returned,
        e_genes
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// total number of genes found
    /// mandatory
    /// typedef int TTotal
    ///  Check whether the Total data member has been assigned a value.
    bool IsSetTotal(void) const;
    /// Check whether it is safe or not to call GetTotal method.
    bool CanGetTotal(void) const;
    void ResetTotal(void);
    TTotal GetTotal(void) const;
    void SetTotal(TTotal value);
    TTotal& SetTotal(void);

    /// number of gene records returned in the reply data, may be less than the total gene count
    /// mandatory
    /// typedef int TReturned
    ///  Check whether the Returned data member has been assigned a value.
    bool IsSetReturned(void) const;
    /// Check whether it is safe or not to call GetReturned method.
    bool CanGetReturned(void) const;
    void ResetReturned(void);
    TReturned GetReturned(void) const;
    void SetReturned(TReturned value);
    TReturned& SetReturned(void);

    /// optional
    /// typedef list< CRef< CGBL_Gene > > TGenes
    ///  Check whether the Genes data member has been assigned a value.
    bool IsSetGenes(void) const;
    /// Check whether it is safe or not to call GetGenes method.
    bool CanGetGenes(void) const;
    void ResetGenes(void);
    const TGenes& GetGenes(void) const;
    TGenes& SetGenes(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGBL_Data_Base(const CGBL_Data_Base&);
    CGBL_Data_Base& operator=(const CGBL_Data_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Total;
    int m_Returned;
    list< CRef< CGBL_Gene > > m_Genes;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGBL_Data_Base::IsSetTotal(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGBL_Data_Base::CanGetTotal(void) const
{
    return IsSetTotal();
}

inline
void CGBL_Data_Base::ResetTotal(void)
{
    m_Total = 0;
    m_set_State[0] &= ~0x3;
}

inline
CGBL_Data_Base::TTotal CGBL_Data_Base::GetTotal(void) const
{
    if (!CanGetTotal()) {
        ThrowUnassigned(0);
    }
    return m_Total;
}

inline
void CGBL_Data_Base::SetTotal(CGBL_Data_Base::TTotal value)
{
    m_Total = value;
    m_set_State[0] |= 0x3;
}

inline
CGBL_Data_Base::TTotal& CGBL_Data_Base::SetTotal(void)
{
#ifdef _DEBUG
    if (!IsSetTotal()) {
        memset(&m_Total,UnassignedByte(),sizeof(m_Total));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Total;
}

inline
bool CGBL_Data_Base::IsSetReturned(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGBL_Data_Base::CanGetReturned(void) const
{
    return IsSetReturned();
}

inline
void CGBL_Data_Base::ResetReturned(void)
{
    m_Returned = 0;
    m_set_State[0] &= ~0xc;
}

inline
CGBL_Data_Base::TReturned CGBL_Data_Base::GetReturned(void) const
{
    if (!CanGetReturned()) {
        ThrowUnassigned(1);
    }
    return m_Returned;
}

inline
void CGBL_Data_Base::SetReturned(CGBL_Data_Base::TReturned value)
{
    m_Returned = value;
    m_set_State[0] |= 0xc;
}

inline
CGBL_Data_Base::TReturned& CGBL_Data_Base::SetReturned(void)
{
#ifdef _DEBUG
    if (!IsSetReturned()) {
        memset(&m_Returned,UnassignedByte(),sizeof(m_Returned));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Returned;
}

inline
bool CGBL_Data_Base::IsSetGenes(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGBL_Data_Base::CanGetGenes(void) const
{
    return true;
}

inline
const CGBL_Data_Base::TGenes& CGBL_Data_Base::GetGenes(void) const
{
    return m_Genes;
}

inline
CGBL_Data_Base::TGenes& CGBL_Data_Base::SetGenes(void)
{
    m_set_State[0] |= 0x10;
    return m_Genes;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENESBYLOC_GBL_DATA_BASE_HPP
