/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_SequenceInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GCCLIENT_SEQUENCEINFO_BASE_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_SEQUENCEINFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGCClient_SequenceInfo_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGCClient_SequenceInfo_Base(void);
    // destructor
    virtual ~CGCClient_SequenceInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ERole {
        eRole_chromosome_top_level = 3,
        eRole_scaffold_top_level   = 1,
        eRole_other                = 0
    };
    
    /// Access to ERole's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ERole)(void);
    
    // types
    typedef string TSequence_acc;
    typedef int TRole;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sequence_acc,
        e_role
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TSequence_acc
    ///  Check whether the Sequence_acc data member has been assigned a value.
    bool IsSetSequence_acc(void) const;
    /// Check whether it is safe or not to call GetSequence_acc method.
    bool CanGetSequence_acc(void) const;
    void ResetSequence_acc(void);
    const TSequence_acc& GetSequence_acc(void) const;
    void SetSequence_acc(const TSequence_acc& value);
    void SetSequence_acc(TSequence_acc&& value);
    TSequence_acc& SetSequence_acc(void);

    /// mandatory
    /// typedef int TRole
    ///  Check whether the Role data member has been assigned a value.
    bool IsSetRole(void) const;
    /// Check whether it is safe or not to call GetRole method.
    bool CanGetRole(void) const;
    void ResetRole(void);
    TRole GetRole(void) const;
    void SetRole(TRole value);
    TRole& SetRole(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGCClient_SequenceInfo_Base(const CGCClient_SequenceInfo_Base&);
    CGCClient_SequenceInfo_Base& operator=(const CGCClient_SequenceInfo_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Sequence_acc;
    int m_Role;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGCClient_SequenceInfo_Base::IsSetSequence_acc(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_SequenceInfo_Base::CanGetSequence_acc(void) const
{
    return IsSetSequence_acc();
}

inline
const CGCClient_SequenceInfo_Base::TSequence_acc& CGCClient_SequenceInfo_Base::GetSequence_acc(void) const
{
    if (!CanGetSequence_acc()) {
        ThrowUnassigned(0);
    }
    return m_Sequence_acc;
}

inline
void CGCClient_SequenceInfo_Base::SetSequence_acc(const CGCClient_SequenceInfo_Base::TSequence_acc& value)
{
    m_Sequence_acc = value;
    m_set_State[0] |= 0x3;
}

inline
void CGCClient_SequenceInfo_Base::SetSequence_acc(CGCClient_SequenceInfo_Base::TSequence_acc&& value)
{
    m_Sequence_acc = std::forward<CGCClient_SequenceInfo_Base::TSequence_acc>(value);
    m_set_State[0] |= 0x3;
}

inline
CGCClient_SequenceInfo_Base::TSequence_acc& CGCClient_SequenceInfo_Base::SetSequence_acc(void)
{
#ifdef _DEBUG
    if (!IsSetSequence_acc()) {
        m_Sequence_acc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Sequence_acc;
}

inline
bool CGCClient_SequenceInfo_Base::IsSetRole(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGCClient_SequenceInfo_Base::CanGetRole(void) const
{
    return IsSetRole();
}

inline
void CGCClient_SequenceInfo_Base::ResetRole(void)
{
    m_Role = (ERole)(0);
    m_set_State[0] &= ~0xc;
}

inline
CGCClient_SequenceInfo_Base::TRole CGCClient_SequenceInfo_Base::GetRole(void) const
{
    if (!CanGetRole()) {
        ThrowUnassigned(1);
    }
    return m_Role;
}

inline
void CGCClient_SequenceInfo_Base::SetRole(CGCClient_SequenceInfo_Base::TRole value)
{
    m_Role = value;
    m_set_State[0] |= 0xc;
}

inline
CGCClient_SequenceInfo_Base::TRole& CGCClient_SequenceInfo_Base::SetRole(void)
{
#ifdef _DEBUG
    if (!IsSetRole()) {
        memset(&m_Role,UnassignedByte(),sizeof(m_Role));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Role;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_SEQUENCEINFO_BASE_HPP
