/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_AssemblyUnit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_ASSEMBLYUNIT_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_ASSEMBLYUNIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CGC_AssemblyDesc;
class CGC_Replicon;
class CGC_Scaf_stats;
class CGC_SequenceStats;
class CGC_TaggedSequences;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_AssemblyUnit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_AssemblyUnit_Base(void);
    // destructor
    virtual ~CGC_AssemblyUnit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// 'class' defines the semantics of how to interpret this item
    enum EClass {
        eClass_haploid_unit   =   1,  ///<  units for haploid/diploid assemblies
        eClass_alt_loci       =   2,  ///< this unit represents one or more alternate loci for a haploid  assembly
        eClass_assembly_patch =   3,  ///< assembly-patch
        eClass_other          = 255  ///< stopper
    };
    
    /// Access to EClass's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EClass)(void);
    
    // types
    typedef list< CRef< CDbtag > > TId;
    typedef int TClass;
    typedef CGC_AssemblyDesc TDesc;
    typedef list< CRef< CGC_Replicon > > TMols;
    typedef list< CRef< CGC_TaggedSequences > > TOther_sequences;
    typedef CGC_SequenceStats TStats;
    typedef list< CRef< CGC_Scaf_stats > > TUnplaced_stats;
    typedef list< CRef< CGC_Scaf_stats > > TUnplaced_unlocalized_stats;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_class,
        e_desc,
        e_mols,
        e_other_sequences,
        e_stats,
        e_unplaced_stats,
        e_unplaced_unlocalized_stats
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// The identifier of this assembly
    /// Contains: GenColl internal id, GenColl accession.version,
    ///            AGP id, UCSC name, Ensembl name
    /// Types of DbTags used:
    /// db "GenColl", tag id <assembly-release-id>
    /// db "GenColl", tag str <assembly-accession.version>
    /// db "AGP", tag id <agp-sumbission-id>
    /// db "GenColl_Chain", tag id <assembly-chain-id>
    /// "Ensembl_name" and "UCSC_name" will not appear in the Unit level since
    /// these organizations do not define assembly-units.
    /// mandatory
    /// typedef list< CRef< CDbtag > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// mandatory
    /// typedef int TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    TClass GetClass(void) const;
    void SetClass(TClass value);
    TClass& SetClass(void);

    /// descriptors live in a shared data block
    /// mandatory
    /// typedef CGC_AssemblyDesc TDesc
    ///  Check whether the Desc data member has been assigned a value.
    bool IsSetDesc(void) const;
    /// Check whether it is safe or not to call GetDesc method.
    bool CanGetDesc(void) const;
    void ResetDesc(void);
    const TDesc& GetDesc(void) const;
    void SetDesc(TDesc& value);
    TDesc& SetDesc(void);

    /// collections of molecules for this assembly
    /// optional
    /// typedef list< CRef< CGC_Replicon > > TMols
    ///  Check whether the Mols data member has been assigned a value.
    bool IsSetMols(void) const;
    /// Check whether it is safe or not to call GetMols method.
    bool CanGetMols(void) const;
    void ResetMols(void);
    const TMols& GetMols(void) const;
    TMols& SetMols(void);

    /// On primary assembly-unit: here will be the unplaced sequences
    /// On alt-loci: list of sequences aligned/unaligned to primary unit
    /// optional
    /// typedef list< CRef< CGC_TaggedSequences > > TOther_sequences
    ///  Check whether the Other_sequences data member has been assigned a value.
    bool IsSetOther_sequences(void) const;
    /// Check whether it is safe or not to call GetOther_sequences method.
    bool CanGetOther_sequences(void) const;
    void ResetOther_sequences(void);
    const TOther_sequences& GetOther_sequences(void) const;
    TOther_sequences& SetOther_sequences(void);

    /// statistics
    /// "stats" field holds stats for all chromosomes combined:
    ///     ordered/unordered scaffolds
    /// "unplaced-stats" holds stats for ChrUn which is omitted from "stats"
    /// optional
    /// typedef CGC_SequenceStats TStats
    ///  Check whether the Stats data member has been assigned a value.
    bool IsSetStats(void) const;
    /// Check whether it is safe or not to call GetStats method.
    bool CanGetStats(void) const;
    void ResetStats(void);
    const TStats& GetStats(void) const;
    void SetStats(TStats& value);
    TStats& SetStats(void);

    /// optional
    /// typedef list< CRef< CGC_Scaf_stats > > TUnplaced_stats
    ///  Check whether the Unplaced_stats data member has been assigned a value.
    bool IsSetUnplaced_stats(void) const;
    /// Check whether it is safe or not to call GetUnplaced_stats method.
    bool CanGetUnplaced_stats(void) const;
    void ResetUnplaced_stats(void);
    const TUnplaced_stats& GetUnplaced_stats(void) const;
    TUnplaced_stats& SetUnplaced_stats(void);

    /// optional
    /// typedef list< CRef< CGC_Scaf_stats > > TUnplaced_unlocalized_stats
    ///  Check whether the Unplaced_unlocalized_stats data member has been assigned a value.
    bool IsSetUnplaced_unlocalized_stats(void) const;
    /// Check whether it is safe or not to call GetUnplaced_unlocalized_stats method.
    bool CanGetUnplaced_unlocalized_stats(void) const;
    void ResetUnplaced_unlocalized_stats(void);
    const TUnplaced_unlocalized_stats& GetUnplaced_unlocalized_stats(void) const;
    TUnplaced_unlocalized_stats& SetUnplaced_unlocalized_stats(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_AssemblyUnit_Base(const CGC_AssemblyUnit_Base&);
    CGC_AssemblyUnit_Base& operator=(const CGC_AssemblyUnit_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CDbtag > > m_Id;
    int m_Class;
    CRef< TDesc > m_Desc;
    list< CRef< CGC_Replicon > > m_Mols;
    list< CRef< CGC_TaggedSequences > > m_Other_sequences;
    CRef< TStats > m_Stats;
    list< CRef< CGC_Scaf_stats > > m_Unplaced_stats;
    list< CRef< CGC_Scaf_stats > > m_Unplaced_unlocalized_stats;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_AssemblyUnit_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_AssemblyUnit_Base::CanGetId(void) const
{
    return true;
}

inline
const CGC_AssemblyUnit_Base::TId& CGC_AssemblyUnit_Base::GetId(void) const
{
    return m_Id;
}

inline
CGC_AssemblyUnit_Base::TId& CGC_AssemblyUnit_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CGC_AssemblyUnit_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_AssemblyUnit_Base::CanGetClass(void) const
{
    return IsSetClass();
}

inline
void CGC_AssemblyUnit_Base::ResetClass(void)
{
    m_Class = (EClass)(0);
    m_set_State[0] &= ~0xc;
}

inline
CGC_AssemblyUnit_Base::TClass CGC_AssemblyUnit_Base::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(1);
    }
    return m_Class;
}

inline
void CGC_AssemblyUnit_Base::SetClass(CGC_AssemblyUnit_Base::TClass value)
{
    m_Class = value;
    m_set_State[0] |= 0xc;
}

inline
CGC_AssemblyUnit_Base::TClass& CGC_AssemblyUnit_Base::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        memset(&m_Class,UnassignedByte(),sizeof(m_Class));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Class;
}

inline
bool CGC_AssemblyUnit_Base::IsSetDesc(void) const
{
    return m_Desc.NotEmpty();
}

inline
bool CGC_AssemblyUnit_Base::CanGetDesc(void) const
{
    return true;
}

inline
const CGC_AssemblyUnit_Base::TDesc& CGC_AssemblyUnit_Base::GetDesc(void) const
{
    if ( !m_Desc ) {
        const_cast<CGC_AssemblyUnit_Base*>(this)->ResetDesc();
    }
    return (*m_Desc);
}

inline
CGC_AssemblyUnit_Base::TDesc& CGC_AssemblyUnit_Base::SetDesc(void)
{
    if ( !m_Desc ) {
        ResetDesc();
    }
    return (*m_Desc);
}

inline
bool CGC_AssemblyUnit_Base::IsSetMols(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGC_AssemblyUnit_Base::CanGetMols(void) const
{
    return true;
}

inline
const CGC_AssemblyUnit_Base::TMols& CGC_AssemblyUnit_Base::GetMols(void) const
{
    return m_Mols;
}

inline
CGC_AssemblyUnit_Base::TMols& CGC_AssemblyUnit_Base::SetMols(void)
{
    m_set_State[0] |= 0x40;
    return m_Mols;
}

inline
bool CGC_AssemblyUnit_Base::IsSetOther_sequences(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGC_AssemblyUnit_Base::CanGetOther_sequences(void) const
{
    return true;
}

inline
const CGC_AssemblyUnit_Base::TOther_sequences& CGC_AssemblyUnit_Base::GetOther_sequences(void) const
{
    return m_Other_sequences;
}

inline
CGC_AssemblyUnit_Base::TOther_sequences& CGC_AssemblyUnit_Base::SetOther_sequences(void)
{
    m_set_State[0] |= 0x100;
    return m_Other_sequences;
}

inline
bool CGC_AssemblyUnit_Base::IsSetStats(void) const
{
    return m_Stats.NotEmpty();
}

inline
bool CGC_AssemblyUnit_Base::CanGetStats(void) const
{
    return IsSetStats();
}

inline
const CGC_AssemblyUnit_Base::TStats& CGC_AssemblyUnit_Base::GetStats(void) const
{
    if (!CanGetStats()) {
        ThrowUnassigned(5);
    }
    return (*m_Stats);
}

inline
bool CGC_AssemblyUnit_Base::IsSetUnplaced_stats(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CGC_AssemblyUnit_Base::CanGetUnplaced_stats(void) const
{
    return true;
}

inline
const CGC_AssemblyUnit_Base::TUnplaced_stats& CGC_AssemblyUnit_Base::GetUnplaced_stats(void) const
{
    return m_Unplaced_stats;
}

inline
CGC_AssemblyUnit_Base::TUnplaced_stats& CGC_AssemblyUnit_Base::SetUnplaced_stats(void)
{
    m_set_State[0] |= 0x1000;
    return m_Unplaced_stats;
}

inline
bool CGC_AssemblyUnit_Base::IsSetUnplaced_unlocalized_stats(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CGC_AssemblyUnit_Base::CanGetUnplaced_unlocalized_stats(void) const
{
    return true;
}

inline
const CGC_AssemblyUnit_Base::TUnplaced_unlocalized_stats& CGC_AssemblyUnit_Base::GetUnplaced_unlocalized_stats(void) const
{
    return m_Unplaced_unlocalized_stats;
}

inline
CGC_AssemblyUnit_Base::TUnplaced_unlocalized_stats& CGC_AssemblyUnit_Base::SetUnplaced_unlocalized_stats(void)
{
    m_set_State[0] |= 0x4000;
    return m_Unplaced_unlocalized_stats;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_ASSEMBLYUNIT_BASE_HPP
