/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Conver_feature_dst_options_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_CONVER_FEATURE_DST_OPTIONS_BASE_HPP
#define OBJECTS_MACRO_CONVER_FEATURE_DST_OPTIONS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/macro/Bond_type.hpp>
#include <objects/macro/Site_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CRegion_type;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CConvert_feature_dst_options_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CConvert_feature_dst_options_Base(void);
    // destructor
    virtual ~CConvert_feature_dst_options_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Bond,
        e_Site,
        e_Region,
        e_Ncrna_class,
        e_Remove_original
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Remove_original+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef EBond_type TBond;
    typedef ESite_type TSite;
    typedef CRegion_type TRegion;
    typedef string TNcrna_class;
    typedef bool TRemove_original;

    // getters
    // setters

    // typedef EBond_type TBond
    bool IsBond(void) const;
    TBond GetBond(void) const;
    TBond& SetBond(void);
    void SetBond(TBond value);

    // typedef ESite_type TSite
    bool IsSite(void) const;
    TSite GetSite(void) const;
    TSite& SetSite(void);
    void SetSite(TSite value);

    // typedef CRegion_type TRegion
    bool IsRegion(void) const;
    const TRegion& GetRegion(void) const;
    TRegion& SetRegion(void);
    void SetRegion(TRegion& value);

    // typedef string TNcrna_class
    bool IsNcrna_class(void) const;
    const TNcrna_class& GetNcrna_class(void) const;
    TNcrna_class& SetNcrna_class(void);
    void SetNcrna_class(const TNcrna_class& value);

    // typedef bool TRemove_original
    bool IsRemove_original(void) const;
    TRemove_original GetRemove_original(void) const;
    TRemove_original& SetRemove_original(void);
    void SetRemove_original(TRemove_original value);


private:
    // copy constructor and assignment operator
    CConvert_feature_dst_options_Base(const CConvert_feature_dst_options_Base& );
    CConvert_feature_dst_options_Base& operator=(const CConvert_feature_dst_options_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TBond m_Bond;
        TSite m_Site;
        TRemove_original m_Remove_original;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CConvert_feature_dst_options_Base::E_Choice CConvert_feature_dst_options_Base::Which(void) const
{
    return m_choice;
}

inline
void CConvert_feature_dst_options_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CConvert_feature_dst_options_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CConvert_feature_dst_options_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CConvert_feature_dst_options_Base::IsBond(void) const
{
    return m_choice == e_Bond;
}

inline
CConvert_feature_dst_options_Base::TBond CConvert_feature_dst_options_Base::GetBond(void) const
{
    CheckSelected(e_Bond);
    return m_Bond;
}

inline
CConvert_feature_dst_options_Base::TBond& CConvert_feature_dst_options_Base::SetBond(void)
{
    Select(e_Bond, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bond;
}

inline
void CConvert_feature_dst_options_Base::SetBond(CConvert_feature_dst_options_Base::TBond value)
{
    Select(e_Bond, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bond = value;
}

inline
bool CConvert_feature_dst_options_Base::IsSite(void) const
{
    return m_choice == e_Site;
}

inline
CConvert_feature_dst_options_Base::TSite CConvert_feature_dst_options_Base::GetSite(void) const
{
    CheckSelected(e_Site);
    return m_Site;
}

inline
CConvert_feature_dst_options_Base::TSite& CConvert_feature_dst_options_Base::SetSite(void)
{
    Select(e_Site, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Site;
}

inline
void CConvert_feature_dst_options_Base::SetSite(CConvert_feature_dst_options_Base::TSite value)
{
    Select(e_Site, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Site = value;
}

inline
bool CConvert_feature_dst_options_Base::IsRegion(void) const
{
    return m_choice == e_Region;
}

inline
bool CConvert_feature_dst_options_Base::IsNcrna_class(void) const
{
    return m_choice == e_Ncrna_class;
}

inline
const CConvert_feature_dst_options_Base::TNcrna_class& CConvert_feature_dst_options_Base::GetNcrna_class(void) const
{
    CheckSelected(e_Ncrna_class);
    return *m_string;
}

inline
CConvert_feature_dst_options_Base::TNcrna_class& CConvert_feature_dst_options_Base::SetNcrna_class(void)
{
    Select(e_Ncrna_class, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CConvert_feature_dst_options_Base::IsRemove_original(void) const
{
    return m_choice == e_Remove_original;
}

inline
CConvert_feature_dst_options_Base::TRemove_original CConvert_feature_dst_options_Base::GetRemove_original(void) const
{
    CheckSelected(e_Remove_original);
    return m_Remove_original;
}

inline
CConvert_feature_dst_options_Base::TRemove_original& CConvert_feature_dst_options_Base::SetRemove_original(void)
{
    Select(e_Remove_original, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Remove_original;
}

inline
void CConvert_feature_dst_options_Base::SetRemove_original(CConvert_feature_dst_options_Base::TRemove_original value)
{
    Select(e_Remove_original, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Remove_original = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_CONVER_FEATURE_DST_OPTIONS_BASE_HPP
