/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Copy_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_COPY_ACTION_BASE_HPP
#define OBJECTS_MACRO_COPY_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/ExistingTextOption.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CField_pair_type;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCopy_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCopy_action_Base(void);
    // destructor
    virtual ~CCopy_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CField_pair_type TFields;
    typedef EExistingTextOption TExisting_text;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_fields,
        e_existing_text
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CField_pair_type TFields
    ///  Check whether the Fields data member has been assigned a value.
    bool IsSetFields(void) const;
    /// Check whether it is safe or not to call GetFields method.
    bool CanGetFields(void) const;
    void ResetFields(void);
    const TFields& GetFields(void) const;
    void SetFields(TFields& value);
    TFields& SetFields(void);

    /// mandatory
    /// typedef EExistingTextOption TExisting_text
    ///  Check whether the Existing_text data member has been assigned a value.
    bool IsSetExisting_text(void) const;
    /// Check whether it is safe or not to call GetExisting_text method.
    bool CanGetExisting_text(void) const;
    void ResetExisting_text(void);
    TExisting_text GetExisting_text(void) const;
    void SetExisting_text(TExisting_text value);
    TExisting_text& SetExisting_text(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCopy_action_Base(const CCopy_action_Base&);
    CCopy_action_Base& operator=(const CCopy_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TFields > m_Fields;
    EExistingTextOption m_Existing_text;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCopy_action_Base::IsSetFields(void) const
{
    return m_Fields.NotEmpty();
}

inline
bool CCopy_action_Base::CanGetFields(void) const
{
    return true;
}

inline
const CCopy_action_Base::TFields& CCopy_action_Base::GetFields(void) const
{
    if ( !m_Fields ) {
        const_cast<CCopy_action_Base*>(this)->ResetFields();
    }
    return (*m_Fields);
}

inline
CCopy_action_Base::TFields& CCopy_action_Base::SetFields(void)
{
    if ( !m_Fields ) {
        ResetFields();
    }
    return (*m_Fields);
}

inline
bool CCopy_action_Base::IsSetExisting_text(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCopy_action_Base::CanGetExisting_text(void) const
{
    return IsSetExisting_text();
}

inline
void CCopy_action_Base::ResetExisting_text(void)
{
    m_Existing_text = (ncbi::objects::EExistingTextOption)(0);
    m_set_State[0] &= ~0xc;
}

inline
CCopy_action_Base::TExisting_text CCopy_action_Base::GetExisting_text(void) const
{
    if (!CanGetExisting_text()) {
        ThrowUnassigned(1);
    }
    return m_Existing_text;
}

inline
void CCopy_action_Base::SetExisting_text(CCopy_action_Base::TExisting_text value)
{
    m_Existing_text = value;
    m_set_State[0] |= 0xc;
}

inline
CCopy_action_Base::TExisting_text& CCopy_action_Base::SetExisting_text(void)
{
#ifdef _DEBUG
    if (!IsSetExisting_text()) {
        memset(&m_Existing_text,UnassignedByte(),sizeof(m_Existing_text));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Existing_text;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_COPY_ACTION_BASE_HPP
