/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Parse_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_PARSE_ACTION_BASE_HPP
#define OBJECTS_MACRO_PARSE_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Cap_change.hpp>
#include <objects/macro/ExistingTextOption.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CParse_dest;
class CParse_src;
class CText_portion;
class CText_transform_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CParse_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CParse_action_Base(void);
    // destructor
    virtual ~CParse_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CText_portion TPortion;
    typedef CParse_src TSrc;
    typedef CParse_dest TDest;
    typedef ECap_change TCapitalization;
    typedef bool TRemove_from_parsed;
    typedef CText_transform_set TTransform;
    typedef EExistingTextOption TExisting_text;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_portion,
        e_src,
        e_dest,
        e_capitalization,
        e_remove_from_parsed,
        e_transform,
        e_existing_text
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CText_portion TPortion
    ///  Check whether the Portion data member has been assigned a value.
    bool IsSetPortion(void) const;
    /// Check whether it is safe or not to call GetPortion method.
    bool CanGetPortion(void) const;
    void ResetPortion(void);
    const TPortion& GetPortion(void) const;
    void SetPortion(TPortion& value);
    TPortion& SetPortion(void);

    /// mandatory
    /// typedef CParse_src TSrc
    ///  Check whether the Src data member has been assigned a value.
    bool IsSetSrc(void) const;
    /// Check whether it is safe or not to call GetSrc method.
    bool CanGetSrc(void) const;
    void ResetSrc(void);
    const TSrc& GetSrc(void) const;
    void SetSrc(TSrc& value);
    TSrc& SetSrc(void);

    /// mandatory
    /// typedef CParse_dest TDest
    ///  Check whether the Dest data member has been assigned a value.
    bool IsSetDest(void) const;
    /// Check whether it is safe or not to call GetDest method.
    bool CanGetDest(void) const;
    void ResetDest(void);
    const TDest& GetDest(void) const;
    void SetDest(TDest& value);
    TDest& SetDest(void);

    /// optional with default eCap_change_none
    /// typedef ECap_change TCapitalization
    ///  Check whether the Capitalization data member has been assigned a value.
    bool IsSetCapitalization(void) const;
    /// Check whether it is safe or not to call GetCapitalization method.
    bool CanGetCapitalization(void) const;
    void ResetCapitalization(void);
    void SetDefaultCapitalization(void);
    TCapitalization GetCapitalization(void) const;
    void SetCapitalization(TCapitalization value);
    TCapitalization& SetCapitalization(void);

    /// optional with default false
    /// typedef bool TRemove_from_parsed
    ///  Check whether the Remove_from_parsed data member has been assigned a value.
    bool IsSetRemove_from_parsed(void) const;
    /// Check whether it is safe or not to call GetRemove_from_parsed method.
    bool CanGetRemove_from_parsed(void) const;
    void ResetRemove_from_parsed(void);
    void SetDefaultRemove_from_parsed(void);
    TRemove_from_parsed GetRemove_from_parsed(void) const;
    void SetRemove_from_parsed(TRemove_from_parsed value);
    TRemove_from_parsed& SetRemove_from_parsed(void);

    /// optional
    /// typedef CText_transform_set TTransform
    ///  Check whether the Transform data member has been assigned a value.
    bool IsSetTransform(void) const;
    /// Check whether it is safe or not to call GetTransform method.
    bool CanGetTransform(void) const;
    void ResetTransform(void);
    const TTransform& GetTransform(void) const;
    void SetTransform(TTransform& value);
    TTransform& SetTransform(void);

    /// mandatory
    /// typedef EExistingTextOption TExisting_text
    ///  Check whether the Existing_text data member has been assigned a value.
    bool IsSetExisting_text(void) const;
    /// Check whether it is safe or not to call GetExisting_text method.
    bool CanGetExisting_text(void) const;
    void ResetExisting_text(void);
    TExisting_text GetExisting_text(void) const;
    void SetExisting_text(TExisting_text value);
    TExisting_text& SetExisting_text(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CParse_action_Base(const CParse_action_Base&);
    CParse_action_Base& operator=(const CParse_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TPortion > m_Portion;
    CRef< TSrc > m_Src;
    CRef< TDest > m_Dest;
    ECap_change m_Capitalization;
    bool m_Remove_from_parsed;
    CRef< TTransform > m_Transform;
    EExistingTextOption m_Existing_text;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CParse_action_Base::IsSetPortion(void) const
{
    return m_Portion.NotEmpty();
}

inline
bool CParse_action_Base::CanGetPortion(void) const
{
    return true;
}

inline
const CParse_action_Base::TPortion& CParse_action_Base::GetPortion(void) const
{
    if ( !m_Portion ) {
        const_cast<CParse_action_Base*>(this)->ResetPortion();
    }
    return (*m_Portion);
}

inline
CParse_action_Base::TPortion& CParse_action_Base::SetPortion(void)
{
    if ( !m_Portion ) {
        ResetPortion();
    }
    return (*m_Portion);
}

inline
bool CParse_action_Base::IsSetSrc(void) const
{
    return m_Src.NotEmpty();
}

inline
bool CParse_action_Base::CanGetSrc(void) const
{
    return true;
}

inline
const CParse_action_Base::TSrc& CParse_action_Base::GetSrc(void) const
{
    if ( !m_Src ) {
        const_cast<CParse_action_Base*>(this)->ResetSrc();
    }
    return (*m_Src);
}

inline
CParse_action_Base::TSrc& CParse_action_Base::SetSrc(void)
{
    if ( !m_Src ) {
        ResetSrc();
    }
    return (*m_Src);
}

inline
bool CParse_action_Base::IsSetDest(void) const
{
    return m_Dest.NotEmpty();
}

inline
bool CParse_action_Base::CanGetDest(void) const
{
    return true;
}

inline
const CParse_action_Base::TDest& CParse_action_Base::GetDest(void) const
{
    if ( !m_Dest ) {
        const_cast<CParse_action_Base*>(this)->ResetDest();
    }
    return (*m_Dest);
}

inline
CParse_action_Base::TDest& CParse_action_Base::SetDest(void)
{
    if ( !m_Dest ) {
        ResetDest();
    }
    return (*m_Dest);
}

inline
bool CParse_action_Base::IsSetCapitalization(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CParse_action_Base::CanGetCapitalization(void) const
{
    return true;
}

inline
void CParse_action_Base::ResetCapitalization(void)
{
    m_Capitalization = eCap_change_none;
    m_set_State[0] &= ~0xc0;
}

inline
void CParse_action_Base::SetDefaultCapitalization(void)
{
    ResetCapitalization();
}

inline
CParse_action_Base::TCapitalization CParse_action_Base::GetCapitalization(void) const
{
    return m_Capitalization;
}

inline
void CParse_action_Base::SetCapitalization(CParse_action_Base::TCapitalization value)
{
    m_Capitalization = value;
    m_set_State[0] |= 0xc0;
}

inline
CParse_action_Base::TCapitalization& CParse_action_Base::SetCapitalization(void)
{
#ifdef _DEBUG
    if (!IsSetCapitalization()) {
        memset(&m_Capitalization,UnassignedByte(),sizeof(m_Capitalization));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Capitalization;
}

inline
bool CParse_action_Base::IsSetRemove_from_parsed(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CParse_action_Base::CanGetRemove_from_parsed(void) const
{
    return true;
}

inline
void CParse_action_Base::ResetRemove_from_parsed(void)
{
    m_Remove_from_parsed = false;
    m_set_State[0] &= ~0x300;
}

inline
void CParse_action_Base::SetDefaultRemove_from_parsed(void)
{
    ResetRemove_from_parsed();
}

inline
CParse_action_Base::TRemove_from_parsed CParse_action_Base::GetRemove_from_parsed(void) const
{
    return m_Remove_from_parsed;
}

inline
void CParse_action_Base::SetRemove_from_parsed(CParse_action_Base::TRemove_from_parsed value)
{
    m_Remove_from_parsed = value;
    m_set_State[0] |= 0x300;
}

inline
CParse_action_Base::TRemove_from_parsed& CParse_action_Base::SetRemove_from_parsed(void)
{
#ifdef _DEBUG
    if (!IsSetRemove_from_parsed()) {
        memset(&m_Remove_from_parsed,UnassignedByte(),sizeof(m_Remove_from_parsed));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Remove_from_parsed;
}

inline
bool CParse_action_Base::IsSetTransform(void) const
{
    return m_Transform.NotEmpty();
}

inline
bool CParse_action_Base::CanGetTransform(void) const
{
    return IsSetTransform();
}

inline
const CParse_action_Base::TTransform& CParse_action_Base::GetTransform(void) const
{
    if (!CanGetTransform()) {
        ThrowUnassigned(5);
    }
    return (*m_Transform);
}

inline
bool CParse_action_Base::IsSetExisting_text(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CParse_action_Base::CanGetExisting_text(void) const
{
    return IsSetExisting_text();
}

inline
void CParse_action_Base::ResetExisting_text(void)
{
    m_Existing_text = (ncbi::objects::EExistingTextOption)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CParse_action_Base::TExisting_text CParse_action_Base::GetExisting_text(void) const
{
    if (!CanGetExisting_text()) {
        ThrowUnassigned(6);
    }
    return m_Existing_text;
}

inline
void CParse_action_Base::SetExisting_text(CParse_action_Base::TExisting_text value)
{
    m_Existing_text = value;
    m_set_State[0] |= 0x3000;
}

inline
CParse_action_Base::TExisting_text& CParse_action_Base::SetExisting_text(void)
{
#ifdef _DEBUG
    if (!IsSetExisting_text()) {
        memset(&m_Existing_text,UnassignedByte(),sizeof(m_Existing_text));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Existing_text;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_PARSE_ACTION_BASE_HPP
