/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Region_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_REGION_TYPE_BASE_HPP
#define OBJECTS_MACRO_REGION_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// other choice is to create protein sequences, skipping bad 
class CRegion_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRegion_type_Base(void);
    // destructor
    virtual ~CRegion_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TCreate_nucleotide;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_create_nucleotide
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef bool TCreate_nucleotide
    ///  Check whether the Create_nucleotide data member has been assigned a value.
    bool IsSetCreate_nucleotide(void) const;
    /// Check whether it is safe or not to call GetCreate_nucleotide method.
    bool CanGetCreate_nucleotide(void) const;
    void ResetCreate_nucleotide(void);
    TCreate_nucleotide GetCreate_nucleotide(void) const;
    void SetCreate_nucleotide(TCreate_nucleotide value);
    TCreate_nucleotide& SetCreate_nucleotide(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRegion_type_Base(const CRegion_type_Base&);
    CRegion_type_Base& operator=(const CRegion_type_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Create_nucleotide;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRegion_type_Base::IsSetCreate_nucleotide(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRegion_type_Base::CanGetCreate_nucleotide(void) const
{
    return IsSetCreate_nucleotide();
}

inline
void CRegion_type_Base::ResetCreate_nucleotide(void)
{
    m_Create_nucleotide = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRegion_type_Base::TCreate_nucleotide CRegion_type_Base::GetCreate_nucleotide(void) const
{
    if (!CanGetCreate_nucleotide()) {
        ThrowUnassigned(0);
    }
    return m_Create_nucleotide;
}

inline
void CRegion_type_Base::SetCreate_nucleotide(CRegion_type_Base::TCreate_nucleotide value)
{
    m_Create_nucleotide = value;
    m_set_State[0] |= 0x3;
}

inline
CRegion_type_Base::TCreate_nucleotide& CRegion_type_Base::SetCreate_nucleotide(void)
{
#ifdef _DEBUG
    if (!IsSetCreate_nucleotide()) {
        memset(&m_Create_nucleotide,UnassignedByte(),sizeof(m_Create_nucleotide));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Create_nucleotide;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_REGION_TYPE_BASE_HPP
