/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_entry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_ENTRY_BASE_HPP
#define OBJECTS_MIM_MIM_ENTRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMim_allelic_variant;
class CMim_cit;
class CMim_edit_item;
class CMim_index_term;
class CMim_link;
class CMim_reference;
class CMim_text;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_entry_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_entry_Base(void);
    // destructor
    virtual ~CMim_entry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EMimType {
        eMimType_none  = 0,
        eMimType_star  = 1,
        eMimType_caret = 2,
        eMimType_pound = 3,
        eMimType_plus  = 4,
        eMimType_perc  = 5
    };
    
    /// Access to EMimType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMimType)(void);
    
    // types
    typedef string TMimNumber;
    typedef int TMimType;
    typedef string TTitle;
    typedef string TCopyright;
    typedef string TSymbol;
    typedef string TLocus;
    typedef list< string > TSynonyms;
    typedef list< string > TAliases;
    typedef list< string > TIncluded;
    typedef list< CRef< CMim_cit > > TSeeAlso;
    typedef list< CRef< CMim_text > > TText;
    typedef list< CRef< CMim_text > > TTextfields;
    typedef bool THasSummary;
    typedef list< CRef< CMim_text > > TSummary;
    typedef list< CRef< CMim_edit_item > > TSummaryAttribution;
    typedef list< CRef< CMim_edit_item > > TSummaryEditHistory;
    typedef CMim_edit_item TSummaryCreationDate;
    typedef list< CRef< CMim_allelic_variant > > TAllelicVariants;
    typedef bool THasSynopsis;
    typedef list< CRef< CMim_index_term > > TClinicalSynopsis;
    typedef list< CRef< CMim_edit_item > > TSynopsisAttribution;
    typedef list< CRef< CMim_edit_item > > TSynopsisEditHistory;
    typedef CMim_edit_item TSynopsisCreationDate;
    typedef list< CRef< CMim_edit_item > > TEditHistory;
    typedef CMim_edit_item TCreationDate;
    typedef list< CRef< CMim_reference > > TReferences;
    typedef list< CRef< CMim_edit_item > > TAttribution;
    typedef int TNumGeneMaps;
    typedef CMim_link TMedlineLinks;
    typedef CMim_link TProteinLinks;
    typedef CMim_link TNucleotideLinks;
    typedef CMim_link TStructureLinks;
    typedef CMim_link TGenomeLinks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_mimNumber,
        e_mimType,
        e_title,
        e_copyright,
        e_symbol,
        e_locus,
        e_synonyms,
        e_aliases,
        e_included,
        e_seeAlso,
        e_text,
        e_textfields,
        e_hasSummary,
        e_summary,
        e_summaryAttribution,
        e_summaryEditHistory,
        e_summaryCreationDate,
        e_allelicVariants,
        e_hasSynopsis,
        e_clinicalSynopsis,
        e_synopsisAttribution,
        e_synopsisEditHistory,
        e_synopsisCreationDate,
        e_editHistory,
        e_creationDate,
        e_references,
        e_attribution,
        e_numGeneMaps,
        e_medlineLinks,
        e_proteinLinks,
        e_nucleotideLinks,
        e_structureLinks,
        e_genomeLinks
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 34> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TMimNumber
    ///  Check whether the MimNumber data member has been assigned a value.
    bool IsSetMimNumber(void) const;
    /// Check whether it is safe or not to call GetMimNumber method.
    bool CanGetMimNumber(void) const;
    void ResetMimNumber(void);
    const TMimNumber& GetMimNumber(void) const;
    void SetMimNumber(const TMimNumber& value);
    void SetMimNumber(TMimNumber&& value);
    TMimNumber& SetMimNumber(void);

    /// mandatory
    /// typedef int TMimType
    ///  Check whether the MimType data member has been assigned a value.
    bool IsSetMimType(void) const;
    /// Check whether it is safe or not to call GetMimType method.
    bool CanGetMimType(void) const;
    void ResetMimType(void);
    TMimType GetMimType(void) const;
    void SetMimType(TMimType value);
    TMimType& SetMimType(void);

    /// mandatory
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef string TCopyright
    ///  Check whether the Copyright data member has been assigned a value.
    bool IsSetCopyright(void) const;
    /// Check whether it is safe or not to call GetCopyright method.
    bool CanGetCopyright(void) const;
    void ResetCopyright(void);
    const TCopyright& GetCopyright(void) const;
    void SetCopyright(const TCopyright& value);
    void SetCopyright(TCopyright&& value);
    TCopyright& SetCopyright(void);

    /// optional
    /// typedef string TSymbol
    ///  Check whether the Symbol data member has been assigned a value.
    bool IsSetSymbol(void) const;
    /// Check whether it is safe or not to call GetSymbol method.
    bool CanGetSymbol(void) const;
    void ResetSymbol(void);
    const TSymbol& GetSymbol(void) const;
    void SetSymbol(const TSymbol& value);
    void SetSymbol(TSymbol&& value);
    TSymbol& SetSymbol(void);

    /// optional
    /// typedef string TLocus
    ///  Check whether the Locus data member has been assigned a value.
    bool IsSetLocus(void) const;
    /// Check whether it is safe or not to call GetLocus method.
    bool CanGetLocus(void) const;
    void ResetLocus(void);
    const TLocus& GetLocus(void) const;
    void SetLocus(const TLocus& value);
    void SetLocus(TLocus&& value);
    TLocus& SetLocus(void);

    /// optional
    /// typedef list< string > TSynonyms
    ///  Check whether the Synonyms data member has been assigned a value.
    bool IsSetSynonyms(void) const;
    /// Check whether it is safe or not to call GetSynonyms method.
    bool CanGetSynonyms(void) const;
    void ResetSynonyms(void);
    const TSynonyms& GetSynonyms(void) const;
    TSynonyms& SetSynonyms(void);

    /// optional
    /// typedef list< string > TAliases
    ///  Check whether the Aliases data member has been assigned a value.
    bool IsSetAliases(void) const;
    /// Check whether it is safe or not to call GetAliases method.
    bool CanGetAliases(void) const;
    void ResetAliases(void);
    const TAliases& GetAliases(void) const;
    TAliases& SetAliases(void);

    /// optional
    /// typedef list< string > TIncluded
    ///  Check whether the Included data member has been assigned a value.
    bool IsSetIncluded(void) const;
    /// Check whether it is safe or not to call GetIncluded method.
    bool CanGetIncluded(void) const;
    void ResetIncluded(void);
    const TIncluded& GetIncluded(void) const;
    TIncluded& SetIncluded(void);

    /// optional
    /// typedef list< CRef< CMim_cit > > TSeeAlso
    ///  Check whether the SeeAlso data member has been assigned a value.
    bool IsSetSeeAlso(void) const;
    /// Check whether it is safe or not to call GetSeeAlso method.
    bool CanGetSeeAlso(void) const;
    void ResetSeeAlso(void);
    const TSeeAlso& GetSeeAlso(void) const;
    TSeeAlso& SetSeeAlso(void);

    /// optional
    /// typedef list< CRef< CMim_text > > TText
    ///  Check whether the Text data member has been assigned a value.
    bool IsSetText(void) const;
    /// Check whether it is safe or not to call GetText method.
    bool CanGetText(void) const;
    void ResetText(void);
    const TText& GetText(void) const;
    TText& SetText(void);

    /// optional
    /// typedef list< CRef< CMim_text > > TTextfields
    ///  Check whether the Textfields data member has been assigned a value.
    bool IsSetTextfields(void) const;
    /// Check whether it is safe or not to call GetTextfields method.
    bool CanGetTextfields(void) const;
    void ResetTextfields(void);
    const TTextfields& GetTextfields(void) const;
    TTextfields& SetTextfields(void);

    /// optional
    /// typedef bool THasSummary
    ///  Check whether the HasSummary data member has been assigned a value.
    bool IsSetHasSummary(void) const;
    /// Check whether it is safe or not to call GetHasSummary method.
    bool CanGetHasSummary(void) const;
    void ResetHasSummary(void);
    THasSummary GetHasSummary(void) const;
    void SetHasSummary(THasSummary value);
    THasSummary& SetHasSummary(void);

    /// optional
    /// typedef list< CRef< CMim_text > > TSummary
    ///  Check whether the Summary data member has been assigned a value.
    bool IsSetSummary(void) const;
    /// Check whether it is safe or not to call GetSummary method.
    bool CanGetSummary(void) const;
    void ResetSummary(void);
    const TSummary& GetSummary(void) const;
    TSummary& SetSummary(void);

    /// optional
    /// typedef list< CRef< CMim_edit_item > > TSummaryAttribution
    ///  Check whether the SummaryAttribution data member has been assigned a value.
    bool IsSetSummaryAttribution(void) const;
    /// Check whether it is safe or not to call GetSummaryAttribution method.
    bool CanGetSummaryAttribution(void) const;
    void ResetSummaryAttribution(void);
    const TSummaryAttribution& GetSummaryAttribution(void) const;
    TSummaryAttribution& SetSummaryAttribution(void);

    /// optional
    /// typedef list< CRef< CMim_edit_item > > TSummaryEditHistory
    ///  Check whether the SummaryEditHistory data member has been assigned a value.
    bool IsSetSummaryEditHistory(void) const;
    /// Check whether it is safe or not to call GetSummaryEditHistory method.
    bool CanGetSummaryEditHistory(void) const;
    void ResetSummaryEditHistory(void);
    const TSummaryEditHistory& GetSummaryEditHistory(void) const;
    TSummaryEditHistory& SetSummaryEditHistory(void);

    /// optional
    /// typedef CMim_edit_item TSummaryCreationDate
    ///  Check whether the SummaryCreationDate data member has been assigned a value.
    bool IsSetSummaryCreationDate(void) const;
    /// Check whether it is safe or not to call GetSummaryCreationDate method.
    bool CanGetSummaryCreationDate(void) const;
    void ResetSummaryCreationDate(void);
    const TSummaryCreationDate& GetSummaryCreationDate(void) const;
    void SetSummaryCreationDate(TSummaryCreationDate& value);
    TSummaryCreationDate& SetSummaryCreationDate(void);

    /// optional
    /// typedef list< CRef< CMim_allelic_variant > > TAllelicVariants
    ///  Check whether the AllelicVariants data member has been assigned a value.
    bool IsSetAllelicVariants(void) const;
    /// Check whether it is safe or not to call GetAllelicVariants method.
    bool CanGetAllelicVariants(void) const;
    void ResetAllelicVariants(void);
    const TAllelicVariants& GetAllelicVariants(void) const;
    TAllelicVariants& SetAllelicVariants(void);

    /// optional
    /// typedef bool THasSynopsis
    ///  Check whether the HasSynopsis data member has been assigned a value.
    bool IsSetHasSynopsis(void) const;
    /// Check whether it is safe or not to call GetHasSynopsis method.
    bool CanGetHasSynopsis(void) const;
    void ResetHasSynopsis(void);
    THasSynopsis GetHasSynopsis(void) const;
    void SetHasSynopsis(THasSynopsis value);
    THasSynopsis& SetHasSynopsis(void);

    /// optional
    /// typedef list< CRef< CMim_index_term > > TClinicalSynopsis
    ///  Check whether the ClinicalSynopsis data member has been assigned a value.
    bool IsSetClinicalSynopsis(void) const;
    /// Check whether it is safe or not to call GetClinicalSynopsis method.
    bool CanGetClinicalSynopsis(void) const;
    void ResetClinicalSynopsis(void);
    const TClinicalSynopsis& GetClinicalSynopsis(void) const;
    TClinicalSynopsis& SetClinicalSynopsis(void);

    /// optional
    /// typedef list< CRef< CMim_edit_item > > TSynopsisAttribution
    ///  Check whether the SynopsisAttribution data member has been assigned a value.
    bool IsSetSynopsisAttribution(void) const;
    /// Check whether it is safe or not to call GetSynopsisAttribution method.
    bool CanGetSynopsisAttribution(void) const;
    void ResetSynopsisAttribution(void);
    const TSynopsisAttribution& GetSynopsisAttribution(void) const;
    TSynopsisAttribution& SetSynopsisAttribution(void);

    /// optional
    /// typedef list< CRef< CMim_edit_item > > TSynopsisEditHistory
    ///  Check whether the SynopsisEditHistory data member has been assigned a value.
    bool IsSetSynopsisEditHistory(void) const;
    /// Check whether it is safe or not to call GetSynopsisEditHistory method.
    bool CanGetSynopsisEditHistory(void) const;
    void ResetSynopsisEditHistory(void);
    const TSynopsisEditHistory& GetSynopsisEditHistory(void) const;
    TSynopsisEditHistory& SetSynopsisEditHistory(void);

    /// optional
    /// typedef CMim_edit_item TSynopsisCreationDate
    ///  Check whether the SynopsisCreationDate data member has been assigned a value.
    bool IsSetSynopsisCreationDate(void) const;
    /// Check whether it is safe or not to call GetSynopsisCreationDate method.
    bool CanGetSynopsisCreationDate(void) const;
    void ResetSynopsisCreationDate(void);
    const TSynopsisCreationDate& GetSynopsisCreationDate(void) const;
    void SetSynopsisCreationDate(TSynopsisCreationDate& value);
    TSynopsisCreationDate& SetSynopsisCreationDate(void);

    /// optional
    /// typedef list< CRef< CMim_edit_item > > TEditHistory
    ///  Check whether the EditHistory data member has been assigned a value.
    bool IsSetEditHistory(void) const;
    /// Check whether it is safe or not to call GetEditHistory method.
    bool CanGetEditHistory(void) const;
    void ResetEditHistory(void);
    const TEditHistory& GetEditHistory(void) const;
    TEditHistory& SetEditHistory(void);

    /// optional
    /// typedef CMim_edit_item TCreationDate
    ///  Check whether the CreationDate data member has been assigned a value.
    bool IsSetCreationDate(void) const;
    /// Check whether it is safe or not to call GetCreationDate method.
    bool CanGetCreationDate(void) const;
    void ResetCreationDate(void);
    const TCreationDate& GetCreationDate(void) const;
    void SetCreationDate(TCreationDate& value);
    TCreationDate& SetCreationDate(void);

    /// optional
    /// typedef list< CRef< CMim_reference > > TReferences
    ///  Check whether the References data member has been assigned a value.
    bool IsSetReferences(void) const;
    /// Check whether it is safe or not to call GetReferences method.
    bool CanGetReferences(void) const;
    void ResetReferences(void);
    const TReferences& GetReferences(void) const;
    TReferences& SetReferences(void);

    /// optional
    /// typedef list< CRef< CMim_edit_item > > TAttribution
    ///  Check whether the Attribution data member has been assigned a value.
    bool IsSetAttribution(void) const;
    /// Check whether it is safe or not to call GetAttribution method.
    bool CanGetAttribution(void) const;
    void ResetAttribution(void);
    const TAttribution& GetAttribution(void) const;
    TAttribution& SetAttribution(void);

    /// mandatory
    /// typedef int TNumGeneMaps
    ///  Check whether the NumGeneMaps data member has been assigned a value.
    bool IsSetNumGeneMaps(void) const;
    /// Check whether it is safe or not to call GetNumGeneMaps method.
    bool CanGetNumGeneMaps(void) const;
    void ResetNumGeneMaps(void);
    TNumGeneMaps GetNumGeneMaps(void) const;
    void SetNumGeneMaps(TNumGeneMaps value);
    TNumGeneMaps& SetNumGeneMaps(void);

    /// optional
    /// typedef CMim_link TMedlineLinks
    ///  Check whether the MedlineLinks data member has been assigned a value.
    bool IsSetMedlineLinks(void) const;
    /// Check whether it is safe or not to call GetMedlineLinks method.
    bool CanGetMedlineLinks(void) const;
    void ResetMedlineLinks(void);
    const TMedlineLinks& GetMedlineLinks(void) const;
    void SetMedlineLinks(TMedlineLinks& value);
    TMedlineLinks& SetMedlineLinks(void);

    /// optional
    /// typedef CMim_link TProteinLinks
    ///  Check whether the ProteinLinks data member has been assigned a value.
    bool IsSetProteinLinks(void) const;
    /// Check whether it is safe or not to call GetProteinLinks method.
    bool CanGetProteinLinks(void) const;
    void ResetProteinLinks(void);
    const TProteinLinks& GetProteinLinks(void) const;
    void SetProteinLinks(TProteinLinks& value);
    TProteinLinks& SetProteinLinks(void);

    /// optional
    /// typedef CMim_link TNucleotideLinks
    ///  Check whether the NucleotideLinks data member has been assigned a value.
    bool IsSetNucleotideLinks(void) const;
    /// Check whether it is safe or not to call GetNucleotideLinks method.
    bool CanGetNucleotideLinks(void) const;
    void ResetNucleotideLinks(void);
    const TNucleotideLinks& GetNucleotideLinks(void) const;
    void SetNucleotideLinks(TNucleotideLinks& value);
    TNucleotideLinks& SetNucleotideLinks(void);

    /// optional
    /// typedef CMim_link TStructureLinks
    ///  Check whether the StructureLinks data member has been assigned a value.
    bool IsSetStructureLinks(void) const;
    /// Check whether it is safe or not to call GetStructureLinks method.
    bool CanGetStructureLinks(void) const;
    void ResetStructureLinks(void);
    const TStructureLinks& GetStructureLinks(void) const;
    void SetStructureLinks(TStructureLinks& value);
    TStructureLinks& SetStructureLinks(void);

    /// optional
    /// typedef CMim_link TGenomeLinks
    ///  Check whether the GenomeLinks data member has been assigned a value.
    bool IsSetGenomeLinks(void) const;
    /// Check whether it is safe or not to call GetGenomeLinks method.
    bool CanGetGenomeLinks(void) const;
    void ResetGenomeLinks(void);
    const TGenomeLinks& GetGenomeLinks(void) const;
    void SetGenomeLinks(TGenomeLinks& value);
    TGenomeLinks& SetGenomeLinks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_entry_Base(const CMim_entry_Base&);
    CMim_entry_Base& operator=(const CMim_entry_Base&);

    // data
    Uint4 m_set_State[3];
    string m_MimNumber;
    int m_MimType;
    string m_Title;
    string m_Copyright;
    string m_Symbol;
    string m_Locus;
    list< string > m_Synonyms;
    list< string > m_Aliases;
    list< string > m_Included;
    list< CRef< CMim_cit > > m_SeeAlso;
    list< CRef< CMim_text > > m_Text;
    list< CRef< CMim_text > > m_Textfields;
    bool m_HasSummary;
    list< CRef< CMim_text > > m_Summary;
    list< CRef< CMim_edit_item > > m_SummaryAttribution;
    list< CRef< CMim_edit_item > > m_SummaryEditHistory;
    CRef< TSummaryCreationDate > m_SummaryCreationDate;
    list< CRef< CMim_allelic_variant > > m_AllelicVariants;
    bool m_HasSynopsis;
    list< CRef< CMim_index_term > > m_ClinicalSynopsis;
    list< CRef< CMim_edit_item > > m_SynopsisAttribution;
    list< CRef< CMim_edit_item > > m_SynopsisEditHistory;
    CRef< TSynopsisCreationDate > m_SynopsisCreationDate;
    list< CRef< CMim_edit_item > > m_EditHistory;
    CRef< TCreationDate > m_CreationDate;
    list< CRef< CMim_reference > > m_References;
    list< CRef< CMim_edit_item > > m_Attribution;
    int m_NumGeneMaps;
    CRef< TMedlineLinks > m_MedlineLinks;
    CRef< TProteinLinks > m_ProteinLinks;
    CRef< TNucleotideLinks > m_NucleotideLinks;
    CRef< TStructureLinks > m_StructureLinks;
    CRef< TGenomeLinks > m_GenomeLinks;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_entry_Base::IsSetMimNumber(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMim_entry_Base::CanGetMimNumber(void) const
{
    return IsSetMimNumber();
}

inline
const CMim_entry_Base::TMimNumber& CMim_entry_Base::GetMimNumber(void) const
{
    if (!CanGetMimNumber()) {
        ThrowUnassigned(0);
    }
    return m_MimNumber;
}

inline
void CMim_entry_Base::SetMimNumber(const CMim_entry_Base::TMimNumber& value)
{
    m_MimNumber = value;
    m_set_State[0] |= 0x3;
}

inline
void CMim_entry_Base::SetMimNumber(CMim_entry_Base::TMimNumber&& value)
{
    m_MimNumber = std::forward<CMim_entry_Base::TMimNumber>(value);
    m_set_State[0] |= 0x3;
}

inline
CMim_entry_Base::TMimNumber& CMim_entry_Base::SetMimNumber(void)
{
#ifdef _DEBUG
    if (!IsSetMimNumber()) {
        m_MimNumber = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_MimNumber;
}

inline
bool CMim_entry_Base::IsSetMimType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMim_entry_Base::CanGetMimType(void) const
{
    return IsSetMimType();
}

inline
void CMim_entry_Base::ResetMimType(void)
{
    m_MimType = (EMimType)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMim_entry_Base::TMimType CMim_entry_Base::GetMimType(void) const
{
    if (!CanGetMimType()) {
        ThrowUnassigned(1);
    }
    return m_MimType;
}

inline
void CMim_entry_Base::SetMimType(CMim_entry_Base::TMimType value)
{
    m_MimType = value;
    m_set_State[0] |= 0xc;
}

inline
CMim_entry_Base::TMimType& CMim_entry_Base::SetMimType(void)
{
#ifdef _DEBUG
    if (!IsSetMimType()) {
        memset(&m_MimType,UnassignedByte(),sizeof(m_MimType));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_MimType;
}

inline
bool CMim_entry_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMim_entry_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CMim_entry_Base::TTitle& CMim_entry_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(2);
    }
    return m_Title;
}

inline
void CMim_entry_Base::SetTitle(const CMim_entry_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x30;
}

inline
void CMim_entry_Base::SetTitle(CMim_entry_Base::TTitle&& value)
{
    m_Title = std::forward<CMim_entry_Base::TTitle>(value);
    m_set_State[0] |= 0x30;
}

inline
CMim_entry_Base::TTitle& CMim_entry_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Title;
}

inline
bool CMim_entry_Base::IsSetCopyright(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMim_entry_Base::CanGetCopyright(void) const
{
    return IsSetCopyright();
}

inline
const CMim_entry_Base::TCopyright& CMim_entry_Base::GetCopyright(void) const
{
    if (!CanGetCopyright()) {
        ThrowUnassigned(3);
    }
    return m_Copyright;
}

inline
void CMim_entry_Base::SetCopyright(const CMim_entry_Base::TCopyright& value)
{
    m_Copyright = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMim_entry_Base::SetCopyright(CMim_entry_Base::TCopyright&& value)
{
    m_Copyright = std::forward<CMim_entry_Base::TCopyright>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMim_entry_Base::TCopyright& CMim_entry_Base::SetCopyright(void)
{
#ifdef _DEBUG
    if (!IsSetCopyright()) {
        m_Copyright = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Copyright;
}

inline
bool CMim_entry_Base::IsSetSymbol(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMim_entry_Base::CanGetSymbol(void) const
{
    return IsSetSymbol();
}

inline
const CMim_entry_Base::TSymbol& CMim_entry_Base::GetSymbol(void) const
{
    if (!CanGetSymbol()) {
        ThrowUnassigned(4);
    }
    return m_Symbol;
}

inline
void CMim_entry_Base::SetSymbol(const CMim_entry_Base::TSymbol& value)
{
    m_Symbol = value;
    m_set_State[0] |= 0x300;
}

inline
void CMim_entry_Base::SetSymbol(CMim_entry_Base::TSymbol&& value)
{
    m_Symbol = std::forward<CMim_entry_Base::TSymbol>(value);
    m_set_State[0] |= 0x300;
}

inline
CMim_entry_Base::TSymbol& CMim_entry_Base::SetSymbol(void)
{
#ifdef _DEBUG
    if (!IsSetSymbol()) {
        m_Symbol = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Symbol;
}

inline
bool CMim_entry_Base::IsSetLocus(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMim_entry_Base::CanGetLocus(void) const
{
    return IsSetLocus();
}

inline
const CMim_entry_Base::TLocus& CMim_entry_Base::GetLocus(void) const
{
    if (!CanGetLocus()) {
        ThrowUnassigned(5);
    }
    return m_Locus;
}

inline
void CMim_entry_Base::SetLocus(const CMim_entry_Base::TLocus& value)
{
    m_Locus = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMim_entry_Base::SetLocus(CMim_entry_Base::TLocus&& value)
{
    m_Locus = std::forward<CMim_entry_Base::TLocus>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMim_entry_Base::TLocus& CMim_entry_Base::SetLocus(void)
{
#ifdef _DEBUG
    if (!IsSetLocus()) {
        m_Locus = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Locus;
}

inline
bool CMim_entry_Base::IsSetSynonyms(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMim_entry_Base::CanGetSynonyms(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSynonyms& CMim_entry_Base::GetSynonyms(void) const
{
    return m_Synonyms;
}

inline
CMim_entry_Base::TSynonyms& CMim_entry_Base::SetSynonyms(void)
{
    m_set_State[0] |= 0x1000;
    return m_Synonyms;
}

inline
bool CMim_entry_Base::IsSetAliases(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMim_entry_Base::CanGetAliases(void) const
{
    return true;
}

inline
const CMim_entry_Base::TAliases& CMim_entry_Base::GetAliases(void) const
{
    return m_Aliases;
}

inline
CMim_entry_Base::TAliases& CMim_entry_Base::SetAliases(void)
{
    m_set_State[0] |= 0x4000;
    return m_Aliases;
}

inline
bool CMim_entry_Base::IsSetIncluded(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMim_entry_Base::CanGetIncluded(void) const
{
    return true;
}

inline
const CMim_entry_Base::TIncluded& CMim_entry_Base::GetIncluded(void) const
{
    return m_Included;
}

inline
CMim_entry_Base::TIncluded& CMim_entry_Base::SetIncluded(void)
{
    m_set_State[0] |= 0x10000;
    return m_Included;
}

inline
bool CMim_entry_Base::IsSetSeeAlso(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMim_entry_Base::CanGetSeeAlso(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSeeAlso& CMim_entry_Base::GetSeeAlso(void) const
{
    return m_SeeAlso;
}

inline
CMim_entry_Base::TSeeAlso& CMim_entry_Base::SetSeeAlso(void)
{
    m_set_State[0] |= 0x40000;
    return m_SeeAlso;
}

inline
bool CMim_entry_Base::IsSetText(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMim_entry_Base::CanGetText(void) const
{
    return true;
}

inline
const CMim_entry_Base::TText& CMim_entry_Base::GetText(void) const
{
    return m_Text;
}

inline
CMim_entry_Base::TText& CMim_entry_Base::SetText(void)
{
    m_set_State[0] |= 0x100000;
    return m_Text;
}

inline
bool CMim_entry_Base::IsSetTextfields(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMim_entry_Base::CanGetTextfields(void) const
{
    return true;
}

inline
const CMim_entry_Base::TTextfields& CMim_entry_Base::GetTextfields(void) const
{
    return m_Textfields;
}

inline
CMim_entry_Base::TTextfields& CMim_entry_Base::SetTextfields(void)
{
    m_set_State[0] |= 0x400000;
    return m_Textfields;
}

inline
bool CMim_entry_Base::IsSetHasSummary(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMim_entry_Base::CanGetHasSummary(void) const
{
    return IsSetHasSummary();
}

inline
void CMim_entry_Base::ResetHasSummary(void)
{
    m_HasSummary = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CMim_entry_Base::THasSummary CMim_entry_Base::GetHasSummary(void) const
{
    if (!CanGetHasSummary()) {
        ThrowUnassigned(12);
    }
    return m_HasSummary;
}

inline
void CMim_entry_Base::SetHasSummary(CMim_entry_Base::THasSummary value)
{
    m_HasSummary = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMim_entry_Base::THasSummary& CMim_entry_Base::SetHasSummary(void)
{
#ifdef _DEBUG
    if (!IsSetHasSummary()) {
        memset(&m_HasSummary,UnassignedByte(),sizeof(m_HasSummary));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_HasSummary;
}

inline
bool CMim_entry_Base::IsSetSummary(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMim_entry_Base::CanGetSummary(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSummary& CMim_entry_Base::GetSummary(void) const
{
    return m_Summary;
}

inline
CMim_entry_Base::TSummary& CMim_entry_Base::SetSummary(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Summary;
}

inline
bool CMim_entry_Base::IsSetSummaryAttribution(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMim_entry_Base::CanGetSummaryAttribution(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSummaryAttribution& CMim_entry_Base::GetSummaryAttribution(void) const
{
    return m_SummaryAttribution;
}

inline
CMim_entry_Base::TSummaryAttribution& CMim_entry_Base::SetSummaryAttribution(void)
{
    m_set_State[0] |= 0x10000000;
    return m_SummaryAttribution;
}

inline
bool CMim_entry_Base::IsSetSummaryEditHistory(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMim_entry_Base::CanGetSummaryEditHistory(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSummaryEditHistory& CMim_entry_Base::GetSummaryEditHistory(void) const
{
    return m_SummaryEditHistory;
}

inline
CMim_entry_Base::TSummaryEditHistory& CMim_entry_Base::SetSummaryEditHistory(void)
{
    m_set_State[0] |= 0x40000000;
    return m_SummaryEditHistory;
}

inline
bool CMim_entry_Base::IsSetSummaryCreationDate(void) const
{
    return m_SummaryCreationDate.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetSummaryCreationDate(void) const
{
    return IsSetSummaryCreationDate();
}

inline
const CMim_entry_Base::TSummaryCreationDate& CMim_entry_Base::GetSummaryCreationDate(void) const
{
    if (!CanGetSummaryCreationDate()) {
        ThrowUnassigned(16);
    }
    return (*m_SummaryCreationDate);
}

inline
bool CMim_entry_Base::IsSetAllelicVariants(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMim_entry_Base::CanGetAllelicVariants(void) const
{
    return true;
}

inline
const CMim_entry_Base::TAllelicVariants& CMim_entry_Base::GetAllelicVariants(void) const
{
    return m_AllelicVariants;
}

inline
CMim_entry_Base::TAllelicVariants& CMim_entry_Base::SetAllelicVariants(void)
{
    m_set_State[1] |= 0x4;
    return m_AllelicVariants;
}

inline
bool CMim_entry_Base::IsSetHasSynopsis(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMim_entry_Base::CanGetHasSynopsis(void) const
{
    return IsSetHasSynopsis();
}

inline
void CMim_entry_Base::ResetHasSynopsis(void)
{
    m_HasSynopsis = 0;
    m_set_State[1] &= ~0x30;
}

inline
CMim_entry_Base::THasSynopsis CMim_entry_Base::GetHasSynopsis(void) const
{
    if (!CanGetHasSynopsis()) {
        ThrowUnassigned(18);
    }
    return m_HasSynopsis;
}

inline
void CMim_entry_Base::SetHasSynopsis(CMim_entry_Base::THasSynopsis value)
{
    m_HasSynopsis = value;
    m_set_State[1] |= 0x30;
}

inline
CMim_entry_Base::THasSynopsis& CMim_entry_Base::SetHasSynopsis(void)
{
#ifdef _DEBUG
    if (!IsSetHasSynopsis()) {
        memset(&m_HasSynopsis,UnassignedByte(),sizeof(m_HasSynopsis));
    }
#endif
    m_set_State[1] |= 0x10;
    return m_HasSynopsis;
}

inline
bool CMim_entry_Base::IsSetClinicalSynopsis(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMim_entry_Base::CanGetClinicalSynopsis(void) const
{
    return true;
}

inline
const CMim_entry_Base::TClinicalSynopsis& CMim_entry_Base::GetClinicalSynopsis(void) const
{
    return m_ClinicalSynopsis;
}

inline
CMim_entry_Base::TClinicalSynopsis& CMim_entry_Base::SetClinicalSynopsis(void)
{
    m_set_State[1] |= 0x40;
    return m_ClinicalSynopsis;
}

inline
bool CMim_entry_Base::IsSetSynopsisAttribution(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMim_entry_Base::CanGetSynopsisAttribution(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSynopsisAttribution& CMim_entry_Base::GetSynopsisAttribution(void) const
{
    return m_SynopsisAttribution;
}

inline
CMim_entry_Base::TSynopsisAttribution& CMim_entry_Base::SetSynopsisAttribution(void)
{
    m_set_State[1] |= 0x100;
    return m_SynopsisAttribution;
}

inline
bool CMim_entry_Base::IsSetSynopsisEditHistory(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMim_entry_Base::CanGetSynopsisEditHistory(void) const
{
    return true;
}

inline
const CMim_entry_Base::TSynopsisEditHistory& CMim_entry_Base::GetSynopsisEditHistory(void) const
{
    return m_SynopsisEditHistory;
}

inline
CMim_entry_Base::TSynopsisEditHistory& CMim_entry_Base::SetSynopsisEditHistory(void)
{
    m_set_State[1] |= 0x400;
    return m_SynopsisEditHistory;
}

inline
bool CMim_entry_Base::IsSetSynopsisCreationDate(void) const
{
    return m_SynopsisCreationDate.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetSynopsisCreationDate(void) const
{
    return IsSetSynopsisCreationDate();
}

inline
const CMim_entry_Base::TSynopsisCreationDate& CMim_entry_Base::GetSynopsisCreationDate(void) const
{
    if (!CanGetSynopsisCreationDate()) {
        ThrowUnassigned(22);
    }
    return (*m_SynopsisCreationDate);
}

inline
bool CMim_entry_Base::IsSetEditHistory(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CMim_entry_Base::CanGetEditHistory(void) const
{
    return true;
}

inline
const CMim_entry_Base::TEditHistory& CMim_entry_Base::GetEditHistory(void) const
{
    return m_EditHistory;
}

inline
CMim_entry_Base::TEditHistory& CMim_entry_Base::SetEditHistory(void)
{
    m_set_State[1] |= 0x4000;
    return m_EditHistory;
}

inline
bool CMim_entry_Base::IsSetCreationDate(void) const
{
    return m_CreationDate.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetCreationDate(void) const
{
    return IsSetCreationDate();
}

inline
const CMim_entry_Base::TCreationDate& CMim_entry_Base::GetCreationDate(void) const
{
    if (!CanGetCreationDate()) {
        ThrowUnassigned(24);
    }
    return (*m_CreationDate);
}

inline
bool CMim_entry_Base::IsSetReferences(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CMim_entry_Base::CanGetReferences(void) const
{
    return true;
}

inline
const CMim_entry_Base::TReferences& CMim_entry_Base::GetReferences(void) const
{
    return m_References;
}

inline
CMim_entry_Base::TReferences& CMim_entry_Base::SetReferences(void)
{
    m_set_State[1] |= 0x40000;
    return m_References;
}

inline
bool CMim_entry_Base::IsSetAttribution(void) const
{
    return ((m_set_State[1] & 0x300000) != 0);
}

inline
bool CMim_entry_Base::CanGetAttribution(void) const
{
    return true;
}

inline
const CMim_entry_Base::TAttribution& CMim_entry_Base::GetAttribution(void) const
{
    return m_Attribution;
}

inline
CMim_entry_Base::TAttribution& CMim_entry_Base::SetAttribution(void)
{
    m_set_State[1] |= 0x100000;
    return m_Attribution;
}

inline
bool CMim_entry_Base::IsSetNumGeneMaps(void) const
{
    return ((m_set_State[1] & 0xc00000) != 0);
}

inline
bool CMim_entry_Base::CanGetNumGeneMaps(void) const
{
    return IsSetNumGeneMaps();
}

inline
void CMim_entry_Base::ResetNumGeneMaps(void)
{
    m_NumGeneMaps = 0;
    m_set_State[1] &= ~0xc00000;
}

inline
CMim_entry_Base::TNumGeneMaps CMim_entry_Base::GetNumGeneMaps(void) const
{
    if (!CanGetNumGeneMaps()) {
        ThrowUnassigned(27);
    }
    return m_NumGeneMaps;
}

inline
void CMim_entry_Base::SetNumGeneMaps(CMim_entry_Base::TNumGeneMaps value)
{
    m_NumGeneMaps = value;
    m_set_State[1] |= 0xc00000;
}

inline
CMim_entry_Base::TNumGeneMaps& CMim_entry_Base::SetNumGeneMaps(void)
{
#ifdef _DEBUG
    if (!IsSetNumGeneMaps()) {
        memset(&m_NumGeneMaps,UnassignedByte(),sizeof(m_NumGeneMaps));
    }
#endif
    m_set_State[1] |= 0x400000;
    return m_NumGeneMaps;
}

inline
bool CMim_entry_Base::IsSetMedlineLinks(void) const
{
    return m_MedlineLinks.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetMedlineLinks(void) const
{
    return IsSetMedlineLinks();
}

inline
const CMim_entry_Base::TMedlineLinks& CMim_entry_Base::GetMedlineLinks(void) const
{
    if (!CanGetMedlineLinks()) {
        ThrowUnassigned(28);
    }
    return (*m_MedlineLinks);
}

inline
bool CMim_entry_Base::IsSetProteinLinks(void) const
{
    return m_ProteinLinks.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetProteinLinks(void) const
{
    return IsSetProteinLinks();
}

inline
const CMim_entry_Base::TProteinLinks& CMim_entry_Base::GetProteinLinks(void) const
{
    if (!CanGetProteinLinks()) {
        ThrowUnassigned(29);
    }
    return (*m_ProteinLinks);
}

inline
bool CMim_entry_Base::IsSetNucleotideLinks(void) const
{
    return m_NucleotideLinks.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetNucleotideLinks(void) const
{
    return IsSetNucleotideLinks();
}

inline
const CMim_entry_Base::TNucleotideLinks& CMim_entry_Base::GetNucleotideLinks(void) const
{
    if (!CanGetNucleotideLinks()) {
        ThrowUnassigned(30);
    }
    return (*m_NucleotideLinks);
}

inline
bool CMim_entry_Base::IsSetStructureLinks(void) const
{
    return m_StructureLinks.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetStructureLinks(void) const
{
    return IsSetStructureLinks();
}

inline
const CMim_entry_Base::TStructureLinks& CMim_entry_Base::GetStructureLinks(void) const
{
    if (!CanGetStructureLinks()) {
        ThrowUnassigned(31);
    }
    return (*m_StructureLinks);
}

inline
bool CMim_entry_Base::IsSetGenomeLinks(void) const
{
    return m_GenomeLinks.NotEmpty();
}

inline
bool CMim_entry_Base::CanGetGenomeLinks(void) const
{
    return IsSetGenomeLinks();
}

inline
const CMim_entry_Base::TGenomeLinks& CMim_entry_Base::GetGenomeLinks(void) const
{
    if (!CanGetGenomeLinks()) {
        ThrowUnassigned(32);
    }
    return (*m_GenomeLinks);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_ENTRY_BASE_HPP
