/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PrintFormBlock_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'objprt.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OBJPRT_PRINTFORMBLOCK_BASE_HPP
#define OBJECTS_OBJPRT_PRINTFORMBLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPrintFormat;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// for SEQUENCE, SET
class NCBI_OBJPRT_EXPORT CPrintFormBlock_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPrintFormBlock_Base(void);
    // destructor
    virtual ~CPrintFormBlock_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TSeparator;
    typedef list< CRef< CPrintFormat > > TComponents;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_separator,
        e_components
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TSeparator
    ///  Check whether the Separator data member has been assigned a value.
    bool IsSetSeparator(void) const;
    /// Check whether it is safe or not to call GetSeparator method.
    bool CanGetSeparator(void) const;
    void ResetSeparator(void);
    const TSeparator& GetSeparator(void) const;
    void SetSeparator(const TSeparator& value);
    void SetSeparator(TSeparator&& value);
    TSeparator& SetSeparator(void);

    /// mandatory
    /// typedef list< CRef< CPrintFormat > > TComponents
    ///  Check whether the Components data member has been assigned a value.
    bool IsSetComponents(void) const;
    /// Check whether it is safe or not to call GetComponents method.
    bool CanGetComponents(void) const;
    void ResetComponents(void);
    const TComponents& GetComponents(void) const;
    TComponents& SetComponents(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPrintFormBlock_Base(const CPrintFormBlock_Base&);
    CPrintFormBlock_Base& operator=(const CPrintFormBlock_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Separator;
    list< CRef< CPrintFormat > > m_Components;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPrintFormBlock_Base::IsSetSeparator(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPrintFormBlock_Base::CanGetSeparator(void) const
{
    return IsSetSeparator();
}

inline
const CPrintFormBlock_Base::TSeparator& CPrintFormBlock_Base::GetSeparator(void) const
{
    if (!CanGetSeparator()) {
        ThrowUnassigned(0);
    }
    return m_Separator;
}

inline
void CPrintFormBlock_Base::SetSeparator(const CPrintFormBlock_Base::TSeparator& value)
{
    m_Separator = value;
    m_set_State[0] |= 0x3;
}

inline
void CPrintFormBlock_Base::SetSeparator(CPrintFormBlock_Base::TSeparator&& value)
{
    m_Separator = std::forward<CPrintFormBlock_Base::TSeparator>(value);
    m_set_State[0] |= 0x3;
}

inline
CPrintFormBlock_Base::TSeparator& CPrintFormBlock_Base::SetSeparator(void)
{
#ifdef _DEBUG
    if (!IsSetSeparator()) {
        m_Separator = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Separator;
}

inline
bool CPrintFormBlock_Base::IsSetComponents(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPrintFormBlock_Base::CanGetComponents(void) const
{
    return true;
}

inline
const CPrintFormBlock_Base::TComponents& CPrintFormBlock_Base::GetComponents(void) const
{
    return m_Components;
}

inline
CPrintFormBlock_Base::TComponents& CPrintFormBlock_Base::SetComponents(void)
{
    m_set_State[0] |= 0x4;
    return m_Components;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OBJPRT_PRINTFORMBLOCK_BASE_HPP
