/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PrintTemplate_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'objprt.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OBJPRT_PRINTTEMPLATE_BASE_HPP
#define OBJECTS_OBJPRT_PRINTTEMPLATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/objprt/TemplateName.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPrintFormat;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_OBJPRT_EXPORT CPrintTemplate_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPrintTemplate_Base(void);
    // destructor
    virtual ~CPrintTemplate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTemplateName TName;
    typedef string TLabelfrom;
    typedef CPrintFormat TFormat;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_labelfrom,
        e_format
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// name for this template
    /// mandatory
    /// typedef CTemplateName TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    TName& SetName(void);

    /// ASN.1 path to get label from
    /// optional
    /// typedef string TLabelfrom
    ///  Check whether the Labelfrom data member has been assigned a value.
    bool IsSetLabelfrom(void) const;
    /// Check whether it is safe or not to call GetLabelfrom method.
    bool CanGetLabelfrom(void) const;
    void ResetLabelfrom(void);
    const TLabelfrom& GetLabelfrom(void) const;
    void SetLabelfrom(const TLabelfrom& value);
    void SetLabelfrom(TLabelfrom&& value);
    TLabelfrom& SetLabelfrom(void);

    /// mandatory
    /// typedef CPrintFormat TFormat
    ///  Check whether the Format data member has been assigned a value.
    bool IsSetFormat(void) const;
    /// Check whether it is safe or not to call GetFormat method.
    bool CanGetFormat(void) const;
    void ResetFormat(void);
    const TFormat& GetFormat(void) const;
    void SetFormat(TFormat& value);
    TFormat& SetFormat(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPrintTemplate_Base(const CPrintTemplate_Base&);
    CPrintTemplate_Base& operator=(const CPrintTemplate_Base&);

    // data
    Uint4 m_set_State[1];
    CTemplateName m_Name;
    string m_Labelfrom;
    CRef< TFormat > m_Format;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPrintTemplate_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPrintTemplate_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPrintTemplate_Base::TName& CPrintTemplate_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CPrintTemplate_Base::SetName(const CPrintTemplate_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
CPrintTemplate_Base::TName& CPrintTemplate_Base::SetName(void)
{
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CPrintTemplate_Base::IsSetLabelfrom(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPrintTemplate_Base::CanGetLabelfrom(void) const
{
    return IsSetLabelfrom();
}

inline
const CPrintTemplate_Base::TLabelfrom& CPrintTemplate_Base::GetLabelfrom(void) const
{
    if (!CanGetLabelfrom()) {
        ThrowUnassigned(1);
    }
    return m_Labelfrom;
}

inline
void CPrintTemplate_Base::SetLabelfrom(const CPrintTemplate_Base::TLabelfrom& value)
{
    m_Labelfrom = value;
    m_set_State[0] |= 0xc;
}

inline
void CPrintTemplate_Base::SetLabelfrom(CPrintTemplate_Base::TLabelfrom&& value)
{
    m_Labelfrom = std::forward<CPrintTemplate_Base::TLabelfrom>(value);
    m_set_State[0] |= 0xc;
}

inline
CPrintTemplate_Base::TLabelfrom& CPrintTemplate_Base::SetLabelfrom(void)
{
#ifdef _DEBUG
    if (!IsSetLabelfrom()) {
        m_Labelfrom = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Labelfrom;
}

inline
bool CPrintTemplate_Base::IsSetFormat(void) const
{
    return m_Format.NotEmpty();
}

inline
bool CPrintTemplate_Base::CanGetFormat(void) const
{
    return true;
}

inline
const CPrintTemplate_Base::TFormat& CPrintTemplate_Base::GetFormat(void) const
{
    if ( !m_Format ) {
        const_cast<CPrintTemplate_Base*>(this)->ResetFormat();
    }
    return (*m_Format);
}

inline
CPrintTemplate_Base::TFormat& CPrintTemplate_Base::SetFormat(void)
{
    if ( !m_Format ) {
        ResetFormat();
    }
    return (*m_Format);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OBJPRT_PRINTTEMPLATE_BASE_HPP
