/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_CompoundType_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_COMPOUNDTYPE_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_COMPOUNDTYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Qualification used to describe the type of Compound deposited, standardized, or derived.
///    Please note that mixtures/cocktails may be specified using previously deposited substances.
class NCBI_PCSUBSTANCE_EXPORT CPC_CompoundType_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_CompoundType_Base(void);
    // destructor
    virtual ~CPC_CompoundType_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    ///  Compound Qualifier or Type
    /// For Compound Depositions
    enum EType {
        eType_deposited    =   0,  ///< Original Deposited Compound  For Standardized Compounds
        eType_standardized =   1,  ///< Standardized Form of a Deposited Compound
        eType_component    =   2,  ///< Component of a Standardized Compound
        eType_neutralized  =   3,  ///< Neutralized Form of a Standardized Compound  For Mixture/Cocktail Depositions
        eType_mixture      =   4,  ///< Substance that is a component of a mixture  For Theoretical Compounds
        eType_tautomer     =   5,  ///< Predicted Tautomer Form
        eType_pka_state    =   6,  ///< Predicted Ionized pKa Form
        eType_unknown      = 255  ///< Unknown Compound Type
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    /////////////////////////////////////////////////////////////////////////////
    ///  Compound Namespace and ID  (absent for "deposited" type compounds)
    class NCBI_PCSUBSTANCE_EXPORT C_Id : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Id(void);
        // destructor
        ~C_Id(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Cid,          ///<  Standardized Compound
            e_Sid,          ///<  PubChem Substance (for "mixture" type compounds)
            e_Xid           ///<  PubChem Theoretical Compound
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Xid+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef int TCid;
        typedef int TSid;
        typedef int TXid;
    
        // getters
        // setters
    
        // typedef int TCid
        bool IsCid(void) const;
        TCid GetCid(void) const;
        TCid& SetCid(void);
        void SetCid(TCid value);
    
        // typedef int TSid
        bool IsSid(void) const;
        TSid GetSid(void) const;
        TSid& SetSid(void);
        void SetSid(TSid value);
    
        // typedef int TXid
        bool IsXid(void) const;
        TXid GetXid(void) const;
        TXid& SetXid(void);
        void SetXid(TXid value);
    
    
    private:
        // copy constructor and assignment operator
        C_Id(const C_Id& );
        C_Id& operator=(const C_Id& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TCid m_Cid;
            TSid m_Sid;
            TXid m_Xid;
        };
    };
    // types
    typedef int TType;
    typedef C_Id TId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef C_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_CompoundType_Base(const CPC_CompoundType_Base&);
    CPC_CompoundType_Base& operator=(const CPC_CompoundType_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    CRef< TId > m_Id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_CompoundType_Base::C_Id::E_Choice CPC_CompoundType_Base::C_Id::Which(void) const
{
    return m_choice;
}

inline
void CPC_CompoundType_Base::C_Id::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_CompoundType_Base::C_Id::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_CompoundType_Base::C_Id::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_CompoundType_Base::C_Id::IsCid(void) const
{
    return m_choice == e_Cid;
}

inline
CPC_CompoundType_Base::C_Id::TCid CPC_CompoundType_Base::C_Id::GetCid(void) const
{
    CheckSelected(e_Cid);
    return m_Cid;
}

inline
CPC_CompoundType_Base::C_Id::TCid& CPC_CompoundType_Base::C_Id::SetCid(void)
{
    Select(e_Cid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Cid;
}

inline
void CPC_CompoundType_Base::C_Id::SetCid(CPC_CompoundType_Base::C_Id::TCid value)
{
    Select(e_Cid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Cid = value;
}

inline
bool CPC_CompoundType_Base::C_Id::IsSid(void) const
{
    return m_choice == e_Sid;
}

inline
CPC_CompoundType_Base::C_Id::TSid CPC_CompoundType_Base::C_Id::GetSid(void) const
{
    CheckSelected(e_Sid);
    return m_Sid;
}

inline
CPC_CompoundType_Base::C_Id::TSid& CPC_CompoundType_Base::C_Id::SetSid(void)
{
    Select(e_Sid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Sid;
}

inline
void CPC_CompoundType_Base::C_Id::SetSid(CPC_CompoundType_Base::C_Id::TSid value)
{
    Select(e_Sid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Sid = value;
}

inline
bool CPC_CompoundType_Base::C_Id::IsXid(void) const
{
    return m_choice == e_Xid;
}

inline
CPC_CompoundType_Base::C_Id::TXid CPC_CompoundType_Base::C_Id::GetXid(void) const
{
    CheckSelected(e_Xid);
    return m_Xid;
}

inline
CPC_CompoundType_Base::C_Id::TXid& CPC_CompoundType_Base::C_Id::SetXid(void)
{
    Select(e_Xid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Xid;
}

inline
void CPC_CompoundType_Base::C_Id::SetXid(CPC_CompoundType_Base::C_Id::TXid value)
{
    Select(e_Xid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Xid = value;
}

inline
bool CPC_CompoundType_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_CompoundType_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_CompoundType_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CPC_CompoundType_Base::TType CPC_CompoundType_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CPC_CompoundType_Base::SetType(CPC_CompoundType_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_CompoundType_Base::TType& CPC_CompoundType_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CPC_CompoundType_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CPC_CompoundType_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CPC_CompoundType_Base::TId& CPC_CompoundType_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(1);
    }
    return (*m_Id);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_COMPOUNDTYPE_BASE_HPP
