/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Substance_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_SUBSTANCE_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_SUBSTANCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_Compounds;
class CPC_ID;
class CPC_Source;
class CPC_XRefData;
class CPub;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Root Record for Chemical Substance Definition
class NCBI_PCSUBSTANCE_EXPORT CPC_Substance_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Substance_Base(void);
    // destructor
    virtual ~CPC_Substance_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPC_ID TSid;
    typedef CPC_Source TSource;
    typedef list< CRef< CPub > > TPub;
    typedef list< string > TSynonyms;
    typedef list< string > TComment;
    typedef list< CRef< CPC_XRefData > > TXref;
    typedef CPC_Compounds TCompound;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sid,
        e_source,
        e_pub,
        e_synonyms,
        e_comment,
        e_xref,
        e_compound
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// Internal Tracking Information
    /// Substance ID/Version  [Either valid ID or a "0" dummy
    ///   value, if "source" is to be used]
    ///   Note: Version is for internal use (only?)
    ///   Note: A valid ID is greater than "0"
    /// mandatory
    /// typedef CPC_ID TSid
    ///  Check whether the Sid data member has been assigned a value.
    bool IsSetSid(void) const;
    /// Check whether it is safe or not to call GetSid method.
    bool CanGetSid(void) const;
    void ResetSid(void);
    const TSid& GetSid(void) const;
    void SetSid(TSid& value);
    TSid& SetSid(void);

    /// Data Source for this Submission
    /// mandatory
    /// typedef CPC_Source TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    void SetSource(TSource& value);
    TSource& SetSource(void);

    /// Substance Description Information
    /// Articles Describing this Substance
    /// optional
    /// typedef list< CRef< CPub > > TPub
    ///  Check whether the Pub data member has been assigned a value.
    bool IsSetPub(void) const;
    /// Check whether it is safe or not to call GetPub method.
    bool CanGetPub(void) const;
    void ResetPub(void);
    const TPub& GetPub(void) const;
    TPub& SetPub(void);

    /// Substance Names provided by Depositor
    /// optional
    /// typedef list< string > TSynonyms
    ///  Check whether the Synonyms data member has been assigned a value.
    bool IsSetSynonyms(void) const;
    /// Check whether it is safe or not to call GetSynonyms method.
    bool CanGetSynonyms(void) const;
    void ResetSynonyms(void);
    const TSynonyms& GetSynonyms(void) const;
    TSynonyms& SetSynonyms(void);

    /// Comments and Description provided by Depositor
    /// optional
    /// typedef list< string > TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    TComment& SetComment(void);

    /// X-Ref/LinkOut Data provided by Depositor
    /// optional
    /// typedef list< CRef< CPC_XRefData > > TXref
    ///  Check whether the Xref data member has been assigned a value.
    bool IsSetXref(void) const;
    /// Check whether it is safe or not to call GetXref method.
    bool CanGetXref(void) const;
    void ResetXref(void);
    const TXref& GetXref(void) const;
    TXref& SetXref(void);

    /// Structure Description
    /// Original Deposited Structure Information
    /// optional
    /// typedef CPC_Compounds TCompound
    ///  Check whether the Compound data member has been assigned a value.
    bool IsSetCompound(void) const;
    /// Check whether it is safe or not to call GetCompound method.
    bool CanGetCompound(void) const;
    void ResetCompound(void);
    const TCompound& GetCompound(void) const;
    void SetCompound(TCompound& value);
    TCompound& SetCompound(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Substance_Base(const CPC_Substance_Base&);
    CPC_Substance_Base& operator=(const CPC_Substance_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSid > m_Sid;
    CRef< TSource > m_Source;
    list< CRef< CPub > > m_Pub;
    list< string > m_Synonyms;
    list< string > m_Comment;
    list< CRef< CPC_XRefData > > m_Xref;
    CRef< TCompound > m_Compound;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Substance_Base::IsSetSid(void) const
{
    return m_Sid.NotEmpty();
}

inline
bool CPC_Substance_Base::CanGetSid(void) const
{
    return true;
}

inline
const CPC_Substance_Base::TSid& CPC_Substance_Base::GetSid(void) const
{
    if ( !m_Sid ) {
        const_cast<CPC_Substance_Base*>(this)->ResetSid();
    }
    return (*m_Sid);
}

inline
CPC_Substance_Base::TSid& CPC_Substance_Base::SetSid(void)
{
    if ( !m_Sid ) {
        ResetSid();
    }
    return (*m_Sid);
}

inline
bool CPC_Substance_Base::IsSetSource(void) const
{
    return m_Source.NotEmpty();
}

inline
bool CPC_Substance_Base::CanGetSource(void) const
{
    return true;
}

inline
const CPC_Substance_Base::TSource& CPC_Substance_Base::GetSource(void) const
{
    if ( !m_Source ) {
        const_cast<CPC_Substance_Base*>(this)->ResetSource();
    }
    return (*m_Source);
}

inline
CPC_Substance_Base::TSource& CPC_Substance_Base::SetSource(void)
{
    if ( !m_Source ) {
        ResetSource();
    }
    return (*m_Source);
}

inline
bool CPC_Substance_Base::IsSetPub(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Substance_Base::CanGetPub(void) const
{
    return true;
}

inline
const CPC_Substance_Base::TPub& CPC_Substance_Base::GetPub(void) const
{
    return m_Pub;
}

inline
CPC_Substance_Base::TPub& CPC_Substance_Base::SetPub(void)
{
    m_set_State[0] |= 0x10;
    return m_Pub;
}

inline
bool CPC_Substance_Base::IsSetSynonyms(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Substance_Base::CanGetSynonyms(void) const
{
    return true;
}

inline
const CPC_Substance_Base::TSynonyms& CPC_Substance_Base::GetSynonyms(void) const
{
    return m_Synonyms;
}

inline
CPC_Substance_Base::TSynonyms& CPC_Substance_Base::SetSynonyms(void)
{
    m_set_State[0] |= 0x40;
    return m_Synonyms;
}

inline
bool CPC_Substance_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Substance_Base::CanGetComment(void) const
{
    return true;
}

inline
const CPC_Substance_Base::TComment& CPC_Substance_Base::GetComment(void) const
{
    return m_Comment;
}

inline
CPC_Substance_Base::TComment& CPC_Substance_Base::SetComment(void)
{
    m_set_State[0] |= 0x100;
    return m_Comment;
}

inline
bool CPC_Substance_Base::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_Substance_Base::CanGetXref(void) const
{
    return true;
}

inline
const CPC_Substance_Base::TXref& CPC_Substance_Base::GetXref(void) const
{
    return m_Xref;
}

inline
CPC_Substance_Base::TXref& CPC_Substance_Base::SetXref(void)
{
    m_set_State[0] |= 0x400;
    return m_Xref;
}

inline
bool CPC_Substance_Base::IsSetCompound(void) const
{
    return m_Compound.NotEmpty();
}

inline
bool CPC_Substance_Base::CanGetCompound(void) const
{
    return IsSetCompound();
}

inline
const CPC_Substance_Base::TCompound& CPC_Substance_Base::GetCompound(void) const
{
    if (!CanGetCompound()) {
        ThrowUnassigned(6);
    }
    return (*m_Compound);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_SUBSTANCE_BASE_HPP
