/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Project_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'proj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PROJ_PROJECT_BASE_HPP
#define OBJECTS_PROJ_PROJECT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CProject_descr;
class CProject_item;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_PROJ_EXPORT CProject_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProject_Base(void);
    // destructor
    virtual ~CProject_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CProject_descr TDescr;
    typedef CProject_item TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_descr,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CProject_descr TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(TDescr& value);
    TDescr& SetDescr(void);

    /// mandatory
    /// typedef CProject_item TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProject_Base(const CProject_Base&);
    CProject_Base& operator=(const CProject_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDescr > m_Descr;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProject_Base::IsSetDescr(void) const
{
    return m_Descr.NotEmpty();
}

inline
bool CProject_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CProject_Base::TDescr& CProject_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(0);
    }
    return (*m_Descr);
}

inline
bool CProject_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CProject_Base::CanGetData(void) const
{
    return true;
}

inline
const CProject_Base::TData& CProject_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CProject_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CProject_Base::TData& CProject_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PROJ_PROJECT_BASE_HPP
