/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file RMRequest_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'remap.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_REMAP_RMREQUEST_BASE_HPP
#define OBJECTS_REMAP_RMREQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CRemap_query;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// request types
class NCBI_REMAP_EXPORT CRMRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRMRequest_Base(void);
    // destructor
    virtual ~CRMRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,       ///< No variant selected
        e_Remap,             ///< do the actual remapping
        e_Maps_to_builds,    ///< what builds can this be mapped to?
        e_Maps_from_builds,  ///< what builds can be mapped to this?
        e_All_builds         ///< all the builds the server knows of
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 5 ///< == e_All_builds+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CRemap_query TRemap;
    typedef string TMaps_to_builds;
    typedef string TMaps_from_builds;

    // getters
    // setters

    // typedef CRemap_query TRemap
    bool IsRemap(void) const;
    const TRemap& GetRemap(void) const;
    TRemap& SetRemap(void);
    void SetRemap(TRemap& value);

    // typedef string TMaps_to_builds
    bool IsMaps_to_builds(void) const;
    const TMaps_to_builds& GetMaps_to_builds(void) const;
    TMaps_to_builds& SetMaps_to_builds(void);
    void SetMaps_to_builds(const TMaps_to_builds& value);

    // typedef string TMaps_from_builds
    bool IsMaps_from_builds(void) const;
    const TMaps_from_builds& GetMaps_from_builds(void) const;
    TMaps_from_builds& SetMaps_from_builds(void);
    void SetMaps_from_builds(const TMaps_from_builds& value);


    bool IsAll_builds(void) const;
    void SetAll_builds(void);


private:
    // copy constructor and assignment operator
    CRMRequest_Base(const CRMRequest_Base& );
    CRMRequest_Base& operator=(const CRMRequest_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CRMRequest_Base::E_Choice CRMRequest_Base::Which(void) const
{
    return m_choice;
}

inline
void CRMRequest_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CRMRequest_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CRMRequest_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CRMRequest_Base::IsRemap(void) const
{
    return m_choice == e_Remap;
}

inline
bool CRMRequest_Base::IsMaps_to_builds(void) const
{
    return m_choice == e_Maps_to_builds;
}

inline
const CRMRequest_Base::TMaps_to_builds& CRMRequest_Base::GetMaps_to_builds(void) const
{
    CheckSelected(e_Maps_to_builds);
    return *m_string;
}

inline
CRMRequest_Base::TMaps_to_builds& CRMRequest_Base::SetMaps_to_builds(void)
{
    Select(e_Maps_to_builds, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CRMRequest_Base::IsMaps_from_builds(void) const
{
    return m_choice == e_Maps_from_builds;
}

inline
const CRMRequest_Base::TMaps_from_builds& CRMRequest_Base::GetMaps_from_builds(void) const
{
    CheckSelected(e_Maps_from_builds);
    return *m_string;
}

inline
CRMRequest_Base::TMaps_from_builds& CRMRequest_Base::SetMaps_from_builds(void)
{
    Select(e_Maps_from_builds, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CRMRequest_Base::IsAll_builds(void) const
{
    return m_choice == e_All_builds;
}

inline
void CRMRequest_Base::SetAll_builds(void)
{
    Select(e_All_builds, NCBI_NS_NCBI::eDoNotResetVariant);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_REMAP_RMREQUEST_BASE_HPP
