/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqEdit_Cmd_ChangeSetAttr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqedit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQEDIT_SEQEDIT_CMD_CHANGESETATTR_BASE_HPP
#define OBJECTS_SEQEDIT_SEQEDIT_CMD_CHANGESETATTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CDbtag;
class CObject_id;
class CSeqEdit_Id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Change bioseq-set's attribute
class NCBI_SEQEDIT_EXPORT CSeqEdit_Cmd_ChangeSetAttr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqEdit_Cmd_ChangeSetAttr_Base(void);
    // destructor
    virtual ~CSeqEdit_Cmd_ChangeSetAttr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQEDIT_EXPORT C_Data : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Id,           ///< object id
            e_Coll,         ///< db tag
            e_Level,        ///< level
            e_Class,        ///< class
            e_Release,      ///< release
            e_Date          ///< date      
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 7 ///< == e_Date+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CObject_id TId;
        typedef CDbtag TColl;
        typedef int TLevel;
        typedef int TClass;
        typedef string TRelease;
        typedef CDate TDate;
    
        // getters
        // setters
    
        // typedef CObject_id TId
        bool IsId(void) const;
        const TId& GetId(void) const;
        TId& SetId(void);
        void SetId(TId& value);
    
        // typedef CDbtag TColl
        bool IsColl(void) const;
        const TColl& GetColl(void) const;
        TColl& SetColl(void);
        void SetColl(TColl& value);
    
        // typedef int TLevel
        bool IsLevel(void) const;
        TLevel GetLevel(void) const;
        TLevel& SetLevel(void);
        void SetLevel(TLevel value);
    
        // typedef int TClass
        bool IsClass(void) const;
        TClass GetClass(void) const;
        TClass& SetClass(void);
        void SetClass(TClass value);
    
        // typedef string TRelease
        bool IsRelease(void) const;
        const TRelease& GetRelease(void) const;
        TRelease& SetRelease(void);
        void SetRelease(const TRelease& value);
    
        // typedef CDate TDate
        bool IsDate(void) const;
        const TDate& GetDate(void) const;
        TDate& SetDate(void);
        void SetDate(TDate& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TLevel m_Level;
            TClass m_Class;
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef CSeqEdit_Id TId;
    typedef C_Data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Bioseq_set id
    /// mandatory
    /// typedef CSeqEdit_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqEdit_Cmd_ChangeSetAttr_Base(const CSeqEdit_Cmd_ChangeSetAttr_Base&);
    CSeqEdit_Cmd_ChangeSetAttr_Base& operator=(const CSeqEdit_Cmd_ChangeSetAttr_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::E_Choice CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::IsId(void) const
{
    return m_choice == e_Id;
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::IsColl(void) const
{
    return m_choice == e_Coll;
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::IsLevel(void) const
{
    return m_choice == e_Level;
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TLevel CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::GetLevel(void) const
{
    CheckSelected(e_Level);
    return m_Level;
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TLevel& CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::SetLevel(void)
{
    Select(e_Level, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Level;
}

inline
void CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::SetLevel(CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TLevel value)
{
    Select(e_Level, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Level = value;
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::IsClass(void) const
{
    return m_choice == e_Class;
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TClass CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::GetClass(void) const
{
    CheckSelected(e_Class);
    return m_Class;
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TClass& CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::SetClass(void)
{
    Select(e_Class, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Class;
}

inline
void CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::SetClass(CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TClass value)
{
    Select(e_Class, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Class = value;
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::IsRelease(void) const
{
    return m_choice == e_Release;
}

inline
const CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TRelease& CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::GetRelease(void) const
{
    CheckSelected(e_Release);
    return *m_string;
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::TRelease& CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::SetRelease(void)
{
    Select(e_Release, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::C_Data::IsDate(void) const
{
    return m_choice == e_Date;
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_ChangeSetAttr_Base::TId& CSeqEdit_Cmd_ChangeSetAttr_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeqEdit_Cmd_ChangeSetAttr_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::TId& CSeqEdit_Cmd_ChangeSetAttr_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CSeqEdit_Cmd_ChangeSetAttr_Base::CanGetData(void) const
{
    return true;
}

inline
const CSeqEdit_Cmd_ChangeSetAttr_Base::TData& CSeqEdit_Cmd_ChangeSetAttr_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CSeqEdit_Cmd_ChangeSetAttr_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CSeqEdit_Cmd_ChangeSetAttr_Base::TData& CSeqEdit_Cmd_ChangeSetAttr_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQEDIT_SEQEDIT_CMD_CHANGESETATTR_BASE_HPP
