/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Clone_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_CLONE_REF_BASE_HPP
#define OBJECTS_SEQFEAT_CLONE_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CClone_seq_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Clone-ref ***********************************************
///*
///*  Specification of clone features
///*
class NCBI_SEQFEAT_EXPORT CClone_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CClone_ref_Base(void);
    // destructor
    virtual ~CClone_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EPlacement_method {
        ePlacement_method_end_seq                  =   0,  ///< Clone placed by end sequence
        ePlacement_method_insert_alignment         =   1,  ///< Clone placed by insert alignment
        ePlacement_method_sts                      =   2,  ///< Clone placed by STS
        ePlacement_method_fish                     =   3,
        ePlacement_method_fingerprint              =   4,
        ePlacement_method_end_seq_insert_alignment =   5,  ///< combined end-seq and insert align
        ePlacement_method_external                 = 253,  ///< Placement provided externally
        ePlacement_method_curated                  = 254,  ///< Human placed or approved
        ePlacement_method_other                    = 255
    };
    
    /// Access to EPlacement_method's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPlacement_method)(void);
    
    // types
    typedef string TName;
    typedef string TLibrary;
    typedef bool TConcordant;
    typedef bool TUnique;
    typedef int TPlacement_method;
    typedef CClone_seq_set TClone_seq;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_library,
        e_concordant,
        e_unique,
        e_placement_method,
        e_clone_seq
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// Official clone symbol
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Library name
    /// optional
    /// typedef string TLibrary
    ///  Check whether the Library data member has been assigned a value.
    bool IsSetLibrary(void) const;
    /// Check whether it is safe or not to call GetLibrary method.
    bool CanGetLibrary(void) const;
    void ResetLibrary(void);
    const TLibrary& GetLibrary(void) const;
    void SetLibrary(const TLibrary& value);
    void SetLibrary(TLibrary&& value);
    TLibrary& SetLibrary(void);

    /// OPTIONAL?
    /// optional with default false
    /// typedef bool TConcordant
    ///  Check whether the Concordant data member has been assigned a value.
    bool IsSetConcordant(void) const;
    /// Check whether it is safe or not to call GetConcordant method.
    bool CanGetConcordant(void) const;
    void ResetConcordant(void);
    void SetDefaultConcordant(void);
    TConcordant GetConcordant(void) const;
    void SetConcordant(TConcordant value);
    TConcordant& SetConcordant(void);

    /// OPTIONAL?
    /// optional with default false
    /// typedef bool TUnique
    ///  Check whether the Unique data member has been assigned a value.
    bool IsSetUnique(void) const;
    /// Check whether it is safe or not to call GetUnique method.
    bool CanGetUnique(void) const;
    void ResetUnique(void);
    void SetDefaultUnique(void);
    TUnique GetUnique(void) const;
    void SetUnique(TUnique value);
    TUnique& SetUnique(void);

    /// optional
    /// typedef int TPlacement_method
    ///  Check whether the Placement_method data member has been assigned a value.
    bool IsSetPlacement_method(void) const;
    /// Check whether it is safe or not to call GetPlacement_method method.
    bool CanGetPlacement_method(void) const;
    void ResetPlacement_method(void);
    TPlacement_method GetPlacement_method(void) const;
    void SetPlacement_method(TPlacement_method value);
    TPlacement_method& SetPlacement_method(void);

    /// optional
    /// typedef CClone_seq_set TClone_seq
    ///  Check whether the Clone_seq data member has been assigned a value.
    bool IsSetClone_seq(void) const;
    /// Check whether it is safe or not to call GetClone_seq method.
    bool CanGetClone_seq(void) const;
    void ResetClone_seq(void);
    const TClone_seq& GetClone_seq(void) const;
    void SetClone_seq(TClone_seq& value);
    TClone_seq& SetClone_seq(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CClone_ref_Base(const CClone_ref_Base&);
    CClone_ref_Base& operator=(const CClone_ref_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    string m_Library;
    bool m_Concordant;
    bool m_Unique;
    int m_Placement_method;
    CRef< TClone_seq > m_Clone_seq;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CClone_ref_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CClone_ref_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CClone_ref_Base::TName& CClone_ref_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CClone_ref_Base::SetName(const CClone_ref_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CClone_ref_Base::SetName(CClone_ref_Base::TName&& value)
{
    m_Name = std::forward<CClone_ref_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CClone_ref_Base::TName& CClone_ref_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CClone_ref_Base::IsSetLibrary(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CClone_ref_Base::CanGetLibrary(void) const
{
    return IsSetLibrary();
}

inline
const CClone_ref_Base::TLibrary& CClone_ref_Base::GetLibrary(void) const
{
    if (!CanGetLibrary()) {
        ThrowUnassigned(1);
    }
    return m_Library;
}

inline
void CClone_ref_Base::SetLibrary(const CClone_ref_Base::TLibrary& value)
{
    m_Library = value;
    m_set_State[0] |= 0xc;
}

inline
void CClone_ref_Base::SetLibrary(CClone_ref_Base::TLibrary&& value)
{
    m_Library = std::forward<CClone_ref_Base::TLibrary>(value);
    m_set_State[0] |= 0xc;
}

inline
CClone_ref_Base::TLibrary& CClone_ref_Base::SetLibrary(void)
{
#ifdef _DEBUG
    if (!IsSetLibrary()) {
        m_Library = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Library;
}

inline
bool CClone_ref_Base::IsSetConcordant(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CClone_ref_Base::CanGetConcordant(void) const
{
    return true;
}

inline
void CClone_ref_Base::ResetConcordant(void)
{
    m_Concordant = false;
    m_set_State[0] &= ~0x30;
}

inline
void CClone_ref_Base::SetDefaultConcordant(void)
{
    ResetConcordant();
}

inline
CClone_ref_Base::TConcordant CClone_ref_Base::GetConcordant(void) const
{
    return m_Concordant;
}

inline
void CClone_ref_Base::SetConcordant(CClone_ref_Base::TConcordant value)
{
    m_Concordant = value;
    m_set_State[0] |= 0x30;
}

inline
CClone_ref_Base::TConcordant& CClone_ref_Base::SetConcordant(void)
{
#ifdef _DEBUG
    if (!IsSetConcordant()) {
        memset(&m_Concordant,UnassignedByte(),sizeof(m_Concordant));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Concordant;
}

inline
bool CClone_ref_Base::IsSetUnique(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CClone_ref_Base::CanGetUnique(void) const
{
    return true;
}

inline
void CClone_ref_Base::ResetUnique(void)
{
    m_Unique = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CClone_ref_Base::SetDefaultUnique(void)
{
    ResetUnique();
}

inline
CClone_ref_Base::TUnique CClone_ref_Base::GetUnique(void) const
{
    return m_Unique;
}

inline
void CClone_ref_Base::SetUnique(CClone_ref_Base::TUnique value)
{
    m_Unique = value;
    m_set_State[0] |= 0xc0;
}

inline
CClone_ref_Base::TUnique& CClone_ref_Base::SetUnique(void)
{
#ifdef _DEBUG
    if (!IsSetUnique()) {
        memset(&m_Unique,UnassignedByte(),sizeof(m_Unique));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Unique;
}

inline
bool CClone_ref_Base::IsSetPlacement_method(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CClone_ref_Base::CanGetPlacement_method(void) const
{
    return IsSetPlacement_method();
}

inline
void CClone_ref_Base::ResetPlacement_method(void)
{
    m_Placement_method = (EPlacement_method)(0);
    m_set_State[0] &= ~0x300;
}

inline
CClone_ref_Base::TPlacement_method CClone_ref_Base::GetPlacement_method(void) const
{
    if (!CanGetPlacement_method()) {
        ThrowUnassigned(4);
    }
    return m_Placement_method;
}

inline
void CClone_ref_Base::SetPlacement_method(CClone_ref_Base::TPlacement_method value)
{
    m_Placement_method = value;
    m_set_State[0] |= 0x300;
}

inline
CClone_ref_Base::TPlacement_method& CClone_ref_Base::SetPlacement_method(void)
{
#ifdef _DEBUG
    if (!IsSetPlacement_method()) {
        memset(&m_Placement_method,UnassignedByte(),sizeof(m_Placement_method));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Placement_method;
}

inline
bool CClone_ref_Base::IsSetClone_seq(void) const
{
    return m_Clone_seq.NotEmpty();
}

inline
bool CClone_ref_Base::CanGetClone_seq(void) const
{
    return IsSetClone_seq();
}

inline
const CClone_ref_Base::TClone_seq& CClone_ref_Base::GetClone_seq(void) const
{
    if (!CanGetClone_seq()) {
        ThrowUnassigned(5);
    }
    return (*m_Clone_seq);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_CLONE_REF_BASE_HPP
