/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file OrgName_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_ORGNAME_BASE_HPP
#define OBJECTS_SEQFEAT_ORGNAME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBinomialOrgName;
class CMultiOrgName;
class COrgMod;
class CPartialOrgName;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT COrgName_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    COrgName_Base(void);
    // destructor
    virtual ~COrgName_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQFEAT_EXPORT C_Name : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Name(void);
        // destructor
        ~C_Name(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Binomial,     ///< genus/species type name
            e_Virus,        ///< virus names are different
            e_Hybrid,       ///< hybrid between organisms
            e_Namedhybrid,  ///< some hybrids have genus x species name
            e_Partial       ///< when genus not known
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 6 ///< == e_Partial+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CBinomialOrgName TBinomial;
        typedef string TVirus;
        typedef CMultiOrgName THybrid;
        typedef CBinomialOrgName TNamedhybrid;
        typedef CPartialOrgName TPartial;
    
        // getters
        // setters
    
        // typedef CBinomialOrgName TBinomial
        bool IsBinomial(void) const;
        const TBinomial& GetBinomial(void) const;
        TBinomial& SetBinomial(void);
        void SetBinomial(TBinomial& value);
    
        // typedef string TVirus
        bool IsVirus(void) const;
        const TVirus& GetVirus(void) const;
        TVirus& SetVirus(void);
        void SetVirus(const TVirus& value);
    
        // typedef CMultiOrgName THybrid
        bool IsHybrid(void) const;
        const THybrid& GetHybrid(void) const;
        THybrid& SetHybrid(void);
        void SetHybrid(THybrid& value);
    
        // typedef CBinomialOrgName TNamedhybrid
        bool IsNamedhybrid(void) const;
        const TNamedhybrid& GetNamedhybrid(void) const;
        TNamedhybrid& SetNamedhybrid(void);
        void SetNamedhybrid(TNamedhybrid& value);
    
        // typedef CPartialOrgName TPartial
        bool IsPartial(void) const;
        const TPartial& GetPartial(void) const;
        TPartial& SetPartial(void);
        void SetPartial(TPartial& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Name(const C_Name& );
        C_Name& operator=(const C_Name& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Name TName;
    typedef string TAttrib;
    typedef list< CRef< COrgMod > > TMod;
    typedef string TLineage;
    typedef int TGcode;
    typedef int TMgcode;
    typedef string TDiv;
    typedef int TPgcode;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_attrib,
        e_mod,
        e_lineage,
        e_gcode,
        e_mgcode,
        e_div,
        e_pgcode
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef C_Name TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(TName& value);
    TName& SetName(void);

    /// attribution of name
    /// optional
    /// typedef string TAttrib
    ///  Check whether the Attrib data member has been assigned a value.
    bool IsSetAttrib(void) const;
    /// Check whether it is safe or not to call GetAttrib method.
    bool CanGetAttrib(void) const;
    void ResetAttrib(void);
    const TAttrib& GetAttrib(void) const;
    void SetAttrib(const TAttrib& value);
    void SetAttrib(TAttrib&& value);
    TAttrib& SetAttrib(void);

    /// optional
    /// typedef list< CRef< COrgMod > > TMod
    ///  Check whether the Mod data member has been assigned a value.
    bool IsSetMod(void) const;
    /// Check whether it is safe or not to call GetMod method.
    bool CanGetMod(void) const;
    void ResetMod(void);
    const TMod& GetMod(void) const;
    TMod& SetMod(void);

    /// lineage with semicolon separators
    /// optional
    /// typedef string TLineage
    ///  Check whether the Lineage data member has been assigned a value.
    bool IsSetLineage(void) const;
    /// Check whether it is safe or not to call GetLineage method.
    bool CanGetLineage(void) const;
    void ResetLineage(void);
    const TLineage& GetLineage(void) const;
    void SetLineage(const TLineage& value);
    void SetLineage(TLineage&& value);
    TLineage& SetLineage(void);

    /// genetic code (see CdRegion)
    /// optional
    /// typedef int TGcode
    ///  Check whether the Gcode data member has been assigned a value.
    bool IsSetGcode(void) const;
    /// Check whether it is safe or not to call GetGcode method.
    bool CanGetGcode(void) const;
    void ResetGcode(void);
    TGcode GetGcode(void) const;
    void SetGcode(TGcode value);
    TGcode& SetGcode(void);

    /// mitochondrial genetic code
    /// optional
    /// typedef int TMgcode
    ///  Check whether the Mgcode data member has been assigned a value.
    bool IsSetMgcode(void) const;
    /// Check whether it is safe or not to call GetMgcode method.
    bool CanGetMgcode(void) const;
    void ResetMgcode(void);
    TMgcode GetMgcode(void) const;
    void SetMgcode(TMgcode value);
    TMgcode& SetMgcode(void);

    /// GenBank division code
    /// optional
    /// typedef string TDiv
    ///  Check whether the Div data member has been assigned a value.
    bool IsSetDiv(void) const;
    /// Check whether it is safe or not to call GetDiv method.
    bool CanGetDiv(void) const;
    void ResetDiv(void);
    const TDiv& GetDiv(void) const;
    void SetDiv(const TDiv& value);
    void SetDiv(TDiv&& value);
    TDiv& SetDiv(void);

    /// plastid genetic code
    /// optional
    /// typedef int TPgcode
    ///  Check whether the Pgcode data member has been assigned a value.
    bool IsSetPgcode(void) const;
    /// Check whether it is safe or not to call GetPgcode method.
    bool CanGetPgcode(void) const;
    void ResetPgcode(void);
    TPgcode GetPgcode(void) const;
    void SetPgcode(TPgcode value);
    TPgcode& SetPgcode(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    COrgName_Base(const COrgName_Base&);
    COrgName_Base& operator=(const COrgName_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TName > m_Name;
    string m_Attrib;
    list< CRef< COrgMod > > m_Mod;
    string m_Lineage;
    int m_Gcode;
    int m_Mgcode;
    string m_Div;
    int m_Pgcode;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
COrgName_Base::C_Name::E_Choice COrgName_Base::C_Name::Which(void) const
{
    return m_choice;
}

inline
void COrgName_Base::C_Name::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void COrgName_Base::C_Name::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void COrgName_Base::C_Name::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool COrgName_Base::C_Name::IsBinomial(void) const
{
    return m_choice == e_Binomial;
}

inline
bool COrgName_Base::C_Name::IsVirus(void) const
{
    return m_choice == e_Virus;
}

inline
const COrgName_Base::C_Name::TVirus& COrgName_Base::C_Name::GetVirus(void) const
{
    CheckSelected(e_Virus);
    return *m_string;
}

inline
COrgName_Base::C_Name::TVirus& COrgName_Base::C_Name::SetVirus(void)
{
    Select(e_Virus, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool COrgName_Base::C_Name::IsHybrid(void) const
{
    return m_choice == e_Hybrid;
}

inline
bool COrgName_Base::C_Name::IsNamedhybrid(void) const
{
    return m_choice == e_Namedhybrid;
}

inline
bool COrgName_Base::C_Name::IsPartial(void) const
{
    return m_choice == e_Partial;
}

inline
bool COrgName_Base::IsSetName(void) const
{
    return m_Name.NotEmpty();
}

inline
bool COrgName_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const COrgName_Base::TName& COrgName_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return (*m_Name);
}

inline
bool COrgName_Base::IsSetAttrib(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool COrgName_Base::CanGetAttrib(void) const
{
    return IsSetAttrib();
}

inline
const COrgName_Base::TAttrib& COrgName_Base::GetAttrib(void) const
{
    if (!CanGetAttrib()) {
        ThrowUnassigned(1);
    }
    return m_Attrib;
}

inline
void COrgName_Base::SetAttrib(const COrgName_Base::TAttrib& value)
{
    m_Attrib = value;
    m_set_State[0] |= 0xc;
}

inline
void COrgName_Base::SetAttrib(COrgName_Base::TAttrib&& value)
{
    m_Attrib = std::forward<COrgName_Base::TAttrib>(value);
    m_set_State[0] |= 0xc;
}

inline
COrgName_Base::TAttrib& COrgName_Base::SetAttrib(void)
{
#ifdef _DEBUG
    if (!IsSetAttrib()) {
        m_Attrib = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Attrib;
}

inline
bool COrgName_Base::IsSetMod(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool COrgName_Base::CanGetMod(void) const
{
    return true;
}

inline
const COrgName_Base::TMod& COrgName_Base::GetMod(void) const
{
    return m_Mod;
}

inline
COrgName_Base::TMod& COrgName_Base::SetMod(void)
{
    m_set_State[0] |= 0x10;
    return m_Mod;
}

inline
bool COrgName_Base::IsSetLineage(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool COrgName_Base::CanGetLineage(void) const
{
    return IsSetLineage();
}

inline
const COrgName_Base::TLineage& COrgName_Base::GetLineage(void) const
{
    if (!CanGetLineage()) {
        ThrowUnassigned(3);
    }
    return m_Lineage;
}

inline
void COrgName_Base::SetLineage(const COrgName_Base::TLineage& value)
{
    m_Lineage = value;
    m_set_State[0] |= 0xc0;
}

inline
void COrgName_Base::SetLineage(COrgName_Base::TLineage&& value)
{
    m_Lineage = std::forward<COrgName_Base::TLineage>(value);
    m_set_State[0] |= 0xc0;
}

inline
COrgName_Base::TLineage& COrgName_Base::SetLineage(void)
{
#ifdef _DEBUG
    if (!IsSetLineage()) {
        m_Lineage = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Lineage;
}

inline
bool COrgName_Base::IsSetGcode(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool COrgName_Base::CanGetGcode(void) const
{
    return IsSetGcode();
}

inline
void COrgName_Base::ResetGcode(void)
{
    m_Gcode = 0;
    m_set_State[0] &= ~0x300;
}

inline
COrgName_Base::TGcode COrgName_Base::GetGcode(void) const
{
    if (!CanGetGcode()) {
        ThrowUnassigned(4);
    }
    return m_Gcode;
}

inline
void COrgName_Base::SetGcode(COrgName_Base::TGcode value)
{
    m_Gcode = value;
    m_set_State[0] |= 0x300;
}

inline
COrgName_Base::TGcode& COrgName_Base::SetGcode(void)
{
#ifdef _DEBUG
    if (!IsSetGcode()) {
        memset(&m_Gcode,UnassignedByte(),sizeof(m_Gcode));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Gcode;
}

inline
bool COrgName_Base::IsSetMgcode(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool COrgName_Base::CanGetMgcode(void) const
{
    return IsSetMgcode();
}

inline
void COrgName_Base::ResetMgcode(void)
{
    m_Mgcode = 0;
    m_set_State[0] &= ~0xc00;
}

inline
COrgName_Base::TMgcode COrgName_Base::GetMgcode(void) const
{
    if (!CanGetMgcode()) {
        ThrowUnassigned(5);
    }
    return m_Mgcode;
}

inline
void COrgName_Base::SetMgcode(COrgName_Base::TMgcode value)
{
    m_Mgcode = value;
    m_set_State[0] |= 0xc00;
}

inline
COrgName_Base::TMgcode& COrgName_Base::SetMgcode(void)
{
#ifdef _DEBUG
    if (!IsSetMgcode()) {
        memset(&m_Mgcode,UnassignedByte(),sizeof(m_Mgcode));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mgcode;
}

inline
bool COrgName_Base::IsSetDiv(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool COrgName_Base::CanGetDiv(void) const
{
    return IsSetDiv();
}

inline
const COrgName_Base::TDiv& COrgName_Base::GetDiv(void) const
{
    if (!CanGetDiv()) {
        ThrowUnassigned(6);
    }
    return m_Div;
}

inline
void COrgName_Base::SetDiv(const COrgName_Base::TDiv& value)
{
    m_Div = value;
    m_set_State[0] |= 0x3000;
}

inline
void COrgName_Base::SetDiv(COrgName_Base::TDiv&& value)
{
    m_Div = std::forward<COrgName_Base::TDiv>(value);
    m_set_State[0] |= 0x3000;
}

inline
COrgName_Base::TDiv& COrgName_Base::SetDiv(void)
{
#ifdef _DEBUG
    if (!IsSetDiv()) {
        m_Div = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Div;
}

inline
bool COrgName_Base::IsSetPgcode(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool COrgName_Base::CanGetPgcode(void) const
{
    return IsSetPgcode();
}

inline
void COrgName_Base::ResetPgcode(void)
{
    m_Pgcode = 0;
    m_set_State[0] &= ~0xc000;
}

inline
COrgName_Base::TPgcode COrgName_Base::GetPgcode(void) const
{
    if (!CanGetPgcode()) {
        ThrowUnassigned(7);
    }
    return m_Pgcode;
}

inline
void COrgName_Base::SetPgcode(COrgName_Base::TPgcode value)
{
    m_Pgcode = value;
    m_set_State[0] |= 0xc000;
}

inline
COrgName_Base::TPgcode& COrgName_Base::SetPgcode(void)
{
#ifdef _DEBUG
    if (!IsSetPgcode()) {
        memset(&m_Pgcode,UnassignedByte(),sizeof(m_Pgcode));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Pgcode;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_ORGNAME_BASE_HPP
