/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_feat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_SEQ_FEAT_BASE_HPP
#define OBJECTS_SEQFEAT_SEQ_FEAT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CFeat_id;
class CGb_qual;
class CPub_set;
class CSeqFeatData;
class CSeqFeatSupport;
class CSeqFeatXref;
class CSeq_loc;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Seq-feat *******************************************
///*  sequence feature generalization
class NCBI_SEQFEAT_EXPORT CSeq_feat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_feat_Base(void);
    // destructor
    virtual ~CSeq_feat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// evidence for existence of feature
    enum EExp_ev {
        eExp_ev_experimental     = 1,  ///< any reasonable experimental check
        eExp_ev_not_experimental = 2  ///< similarity, pattern, etc
    };
    
    /// Access to EExp_ev's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EExp_ev)(void);
    
    // types
    typedef CFeat_id TId;
    typedef CSeqFeatData TData;
    typedef bool TPartial;
    typedef bool TExcept;
    typedef string TComment;
    typedef CSeq_loc TProduct;
    typedef CSeq_loc TLocation;
    typedef vector< CRef< CGb_qual > > TQual;
    typedef string TTitle;
    typedef CUser_object TExt;
    typedef CPub_set TCit;
    typedef EExp_ev TExp_ev;
    typedef vector< CRef< CSeqFeatXref > > TXref;
    typedef vector< CRef< CDbtag > > TDbxref;
    typedef bool TPseudo;
    typedef string TExcept_text;
    typedef list< CRef< CFeat_id > > TIds;
    typedef list< CRef< CUser_object > > TExts;
    typedef CSeqFeatSupport TSupport;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_data,
        e_partial,
        e_except,
        e_comment,
        e_product,
        e_location,
        e_qual,
        e_title,
        e_ext,
        e_cit,
        e_exp_ev,
        e_xref,
        e_dbxref,
        e_pseudo,
        e_except_text,
        e_ids,
        e_exts,
        e_support
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 20> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CFeat_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// the specific data
    /// mandatory
    /// typedef CSeqFeatData TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// incomplete in some way?
    /// optional
    /// typedef bool TPartial
    ///  Check whether the Partial data member has been assigned a value.
    bool IsSetPartial(void) const;
    /// Check whether it is safe or not to call GetPartial method.
    bool CanGetPartial(void) const;
    void ResetPartial(void);
    TPartial GetPartial(void) const;
    void SetPartial(TPartial value);
    TPartial& SetPartial(void);

    /// something funny about this?
    /// optional
    /// typedef bool TExcept
    ///  Check whether the Except data member has been assigned a value.
    bool IsSetExcept(void) const;
    /// Check whether it is safe or not to call GetExcept method.
    bool CanGetExcept(void) const;
    void ResetExcept(void);
    TExcept GetExcept(void) const;
    void SetExcept(TExcept value);
    TExcept& SetExcept(void);

    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// product of process
    /// optional
    /// typedef CSeq_loc TProduct
    ///  Check whether the Product data member has been assigned a value.
    bool IsSetProduct(void) const;
    /// Check whether it is safe or not to call GetProduct method.
    bool CanGetProduct(void) const;
    void ResetProduct(void);
    const TProduct& GetProduct(void) const;
    void SetProduct(TProduct& value);
    TProduct& SetProduct(void);

    /// feature made from
    /// mandatory
    /// typedef CSeq_loc TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// qualifiers
    /// optional
    /// typedef vector< CRef< CGb_qual > > TQual
    ///  Check whether the Qual data member has been assigned a value.
    bool IsSetQual(void) const;
    /// Check whether it is safe or not to call GetQual method.
    bool CanGetQual(void) const;
    void ResetQual(void);
    const TQual& GetQual(void) const;
    TQual& SetQual(void);

    /// for user defined label
    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// user defined structure extension
    /// optional
    /// typedef CUser_object TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    void SetExt(TExt& value);
    TExt& SetExt(void);

    /// citations for this feature
    /// optional
    /// typedef CPub_set TCit
    ///  Check whether the Cit data member has been assigned a value.
    bool IsSetCit(void) const;
    /// Check whether it is safe or not to call GetCit method.
    bool CanGetCit(void) const;
    void ResetCit(void);
    const TCit& GetCit(void) const;
    void SetCit(TCit& value);
    TCit& SetCit(void);

    /// optional
    /// typedef EExp_ev TExp_ev
    ///  Check whether the Exp_ev data member has been assigned a value.
    bool IsSetExp_ev(void) const;
    /// Check whether it is safe or not to call GetExp_ev method.
    bool CanGetExp_ev(void) const;
    void ResetExp_ev(void);
    TExp_ev GetExp_ev(void) const;
    void SetExp_ev(TExp_ev value);
    TExp_ev& SetExp_ev(void);

    /// cite other relevant features
    /// optional
    /// typedef vector< CRef< CSeqFeatXref > > TXref
    ///  Check whether the Xref data member has been assigned a value.
    bool IsSetXref(void) const;
    /// Check whether it is safe or not to call GetXref method.
    bool CanGetXref(void) const;
    void ResetXref(void);
    const TXref& GetXref(void) const;
    TXref& SetXref(void);

    /// support for xref to other databases
    /// optional
    /// typedef vector< CRef< CDbtag > > TDbxref
    ///  Check whether the Dbxref data member has been assigned a value.
    bool IsSetDbxref(void) const;
    /// Check whether it is safe or not to call GetDbxref method.
    bool CanGetDbxref(void) const;
    void ResetDbxref(void);
    const TDbxref& GetDbxref(void) const;
    TDbxref& SetDbxref(void);

    /// annotated on pseudogene?
    /// optional
    /// typedef bool TPseudo
    ///  Check whether the Pseudo data member has been assigned a value.
    bool IsSetPseudo(void) const;
    /// Check whether it is safe or not to call GetPseudo method.
    bool CanGetPseudo(void) const;
    void ResetPseudo(void);
    TPseudo GetPseudo(void) const;
    void SetPseudo(TPseudo value);
    TPseudo& SetPseudo(void);

    /// explain if except=TRUE
    /// optional
    /// typedef string TExcept_text
    ///  Check whether the Except_text data member has been assigned a value.
    bool IsSetExcept_text(void) const;
    /// Check whether it is safe or not to call GetExcept_text method.
    bool CanGetExcept_text(void) const;
    void ResetExcept_text(void);
    const TExcept_text& GetExcept_text(void) const;
    void SetExcept_text(const TExcept_text& value);
    void SetExcept_text(TExcept_text&& value);
    TExcept_text& SetExcept_text(void);

    /// set of Ids; will replace 'id' field
    /// optional
    /// typedef list< CRef< CFeat_id > > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// set of extensions; will replace 'ext' field
    /// optional
    /// typedef list< CRef< CUser_object > > TExts
    ///  Check whether the Exts data member has been assigned a value.
    bool IsSetExts(void) const;
    /// Check whether it is safe or not to call GetExts method.
    bool CanGetExts(void) const;
    void ResetExts(void);
    const TExts& GetExts(void) const;
    TExts& SetExts(void);

    /// will replace /experiment, /inference, model-evidence
    /// optional
    /// typedef CSeqFeatSupport TSupport
    ///  Check whether the Support data member has been assigned a value.
    bool IsSetSupport(void) const;
    /// Check whether it is safe or not to call GetSupport method.
    bool CanGetSupport(void) const;
    void ResetSupport(void);
    const TSupport& GetSupport(void) const;
    void SetSupport(TSupport& value);
    TSupport& SetSupport(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_feat_Base(const CSeq_feat_Base&);
    CSeq_feat_Base& operator=(const CSeq_feat_Base&);

    // data
    Uint4 m_set_State[2];
    CRef< TId > m_Id;
    CRef< TData > m_Data;
    bool m_Partial;
    bool m_Except;
    string m_Comment;
    CRef< TProduct > m_Product;
    CRef< TLocation > m_Location;
    vector< CRef< CGb_qual > > m_Qual;
    string m_Title;
    CRef< TExt > m_Ext;
    CRef< TCit > m_Cit;
    EExp_ev m_Exp_ev;
    vector< CRef< CSeqFeatXref > > m_Xref;
    vector< CRef< CDbtag > > m_Dbxref;
    bool m_Pseudo;
    string m_Except_text;
    list< CRef< CFeat_id > > m_Ids;
    list< CRef< CUser_object > > m_Exts;
    CRef< TSupport > m_Support;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_feat_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CSeq_feat_Base::TId& CSeq_feat_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return (*m_Id);
}

inline
bool CSeq_feat_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetData(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TData& CSeq_feat_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CSeq_feat_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CSeq_feat_Base::TData& CSeq_feat_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

inline
bool CSeq_feat_Base::IsSetPartial(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_feat_Base::CanGetPartial(void) const
{
    return IsSetPartial();
}

inline
void CSeq_feat_Base::ResetPartial(void)
{
    m_Partial = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeq_feat_Base::TPartial CSeq_feat_Base::GetPartial(void) const
{
    if (!CanGetPartial()) {
        ThrowUnassigned(2);
    }
    return m_Partial;
}

inline
void CSeq_feat_Base::SetPartial(CSeq_feat_Base::TPartial value)
{
    m_Partial = value;
    m_set_State[0] |= 0x30;
}

inline
CSeq_feat_Base::TPartial& CSeq_feat_Base::SetPartial(void)
{
#ifdef _DEBUG
    if (!IsSetPartial()) {
        memset(&m_Partial,UnassignedByte(),sizeof(m_Partial));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Partial;
}

inline
bool CSeq_feat_Base::IsSetExcept(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSeq_feat_Base::CanGetExcept(void) const
{
    return IsSetExcept();
}

inline
void CSeq_feat_Base::ResetExcept(void)
{
    m_Except = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CSeq_feat_Base::TExcept CSeq_feat_Base::GetExcept(void) const
{
    if (!CanGetExcept()) {
        ThrowUnassigned(3);
    }
    return m_Except;
}

inline
void CSeq_feat_Base::SetExcept(CSeq_feat_Base::TExcept value)
{
    m_Except = value;
    m_set_State[0] |= 0xc0;
}

inline
CSeq_feat_Base::TExcept& CSeq_feat_Base::SetExcept(void)
{
#ifdef _DEBUG
    if (!IsSetExcept()) {
        memset(&m_Except,UnassignedByte(),sizeof(m_Except));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Except;
}

inline
bool CSeq_feat_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSeq_feat_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CSeq_feat_Base::TComment& CSeq_feat_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(4);
    }
    return m_Comment;
}

inline
void CSeq_feat_Base::SetComment(const CSeq_feat_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0x300;
}

inline
void CSeq_feat_Base::SetComment(CSeq_feat_Base::TComment&& value)
{
    m_Comment = std::forward<CSeq_feat_Base::TComment>(value);
    m_set_State[0] |= 0x300;
}

inline
CSeq_feat_Base::TComment& CSeq_feat_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Comment;
}

inline
bool CSeq_feat_Base::IsSetProduct(void) const
{
    return m_Product.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetProduct(void) const
{
    return IsSetProduct();
}

inline
const CSeq_feat_Base::TProduct& CSeq_feat_Base::GetProduct(void) const
{
    if (!CanGetProduct()) {
        ThrowUnassigned(5);
    }
    return (*m_Product);
}

inline
bool CSeq_feat_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetLocation(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TLocation& CSeq_feat_Base::GetLocation(void) const
{
    if ( !m_Location ) {
        const_cast<CSeq_feat_Base*>(this)->ResetLocation();
    }
    return (*m_Location);
}

inline
CSeq_feat_Base::TLocation& CSeq_feat_Base::SetLocation(void)
{
    if ( !m_Location ) {
        ResetLocation();
    }
    return (*m_Location);
}

inline
bool CSeq_feat_Base::IsSetQual(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSeq_feat_Base::CanGetQual(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TQual& CSeq_feat_Base::GetQual(void) const
{
    return m_Qual;
}

inline
CSeq_feat_Base::TQual& CSeq_feat_Base::SetQual(void)
{
    m_set_State[0] |= 0x4000;
    return m_Qual;
}

inline
bool CSeq_feat_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CSeq_feat_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CSeq_feat_Base::TTitle& CSeq_feat_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(8);
    }
    return m_Title;
}

inline
void CSeq_feat_Base::SetTitle(const CSeq_feat_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x30000;
}

inline
void CSeq_feat_Base::SetTitle(CSeq_feat_Base::TTitle&& value)
{
    m_Title = std::forward<CSeq_feat_Base::TTitle>(value);
    m_set_State[0] |= 0x30000;
}

inline
CSeq_feat_Base::TTitle& CSeq_feat_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Title;
}

inline
bool CSeq_feat_Base::IsSetExt(void) const
{
    return m_Ext.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetExt(void) const
{
    return IsSetExt();
}

inline
const CSeq_feat_Base::TExt& CSeq_feat_Base::GetExt(void) const
{
    if (!CanGetExt()) {
        ThrowUnassigned(9);
    }
    return (*m_Ext);
}

inline
bool CSeq_feat_Base::IsSetCit(void) const
{
    return m_Cit.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetCit(void) const
{
    return IsSetCit();
}

inline
const CSeq_feat_Base::TCit& CSeq_feat_Base::GetCit(void) const
{
    if (!CanGetCit()) {
        ThrowUnassigned(10);
    }
    return (*m_Cit);
}

inline
bool CSeq_feat_Base::IsSetExp_ev(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CSeq_feat_Base::CanGetExp_ev(void) const
{
    return IsSetExp_ev();
}

inline
void CSeq_feat_Base::ResetExp_ev(void)
{
    m_Exp_ev = (EExp_ev)(0);
    m_set_State[0] &= ~0xc00000;
}

inline
CSeq_feat_Base::TExp_ev CSeq_feat_Base::GetExp_ev(void) const
{
    if (!CanGetExp_ev()) {
        ThrowUnassigned(11);
    }
    return m_Exp_ev;
}

inline
void CSeq_feat_Base::SetExp_ev(CSeq_feat_Base::TExp_ev value)
{
    m_Exp_ev = value;
    m_set_State[0] |= 0xc00000;
}

inline
CSeq_feat_Base::TExp_ev& CSeq_feat_Base::SetExp_ev(void)
{
#ifdef _DEBUG
    if (!IsSetExp_ev()) {
        memset(&m_Exp_ev,UnassignedByte(),sizeof(m_Exp_ev));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Exp_ev;
}

inline
bool CSeq_feat_Base::IsSetXref(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CSeq_feat_Base::CanGetXref(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TXref& CSeq_feat_Base::GetXref(void) const
{
    return m_Xref;
}

inline
CSeq_feat_Base::TXref& CSeq_feat_Base::SetXref(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Xref;
}

inline
bool CSeq_feat_Base::IsSetDbxref(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CSeq_feat_Base::CanGetDbxref(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TDbxref& CSeq_feat_Base::GetDbxref(void) const
{
    return m_Dbxref;
}

inline
CSeq_feat_Base::TDbxref& CSeq_feat_Base::SetDbxref(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Dbxref;
}

inline
bool CSeq_feat_Base::IsSetPseudo(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CSeq_feat_Base::CanGetPseudo(void) const
{
    return IsSetPseudo();
}

inline
void CSeq_feat_Base::ResetPseudo(void)
{
    m_Pseudo = 0;
    m_set_State[0] &= ~0x30000000;
}

inline
CSeq_feat_Base::TPseudo CSeq_feat_Base::GetPseudo(void) const
{
    if (!CanGetPseudo()) {
        ThrowUnassigned(14);
    }
    return m_Pseudo;
}

inline
void CSeq_feat_Base::SetPseudo(CSeq_feat_Base::TPseudo value)
{
    m_Pseudo = value;
    m_set_State[0] |= 0x30000000;
}

inline
CSeq_feat_Base::TPseudo& CSeq_feat_Base::SetPseudo(void)
{
#ifdef _DEBUG
    if (!IsSetPseudo()) {
        memset(&m_Pseudo,UnassignedByte(),sizeof(m_Pseudo));
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Pseudo;
}

inline
bool CSeq_feat_Base::IsSetExcept_text(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CSeq_feat_Base::CanGetExcept_text(void) const
{
    return IsSetExcept_text();
}

inline
const CSeq_feat_Base::TExcept_text& CSeq_feat_Base::GetExcept_text(void) const
{
    if (!CanGetExcept_text()) {
        ThrowUnassigned(15);
    }
    return m_Except_text;
}

inline
void CSeq_feat_Base::SetExcept_text(const CSeq_feat_Base::TExcept_text& value)
{
    m_Except_text = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CSeq_feat_Base::SetExcept_text(CSeq_feat_Base::TExcept_text&& value)
{
    m_Except_text = std::forward<CSeq_feat_Base::TExcept_text>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CSeq_feat_Base::TExcept_text& CSeq_feat_Base::SetExcept_text(void)
{
#ifdef _DEBUG
    if (!IsSetExcept_text()) {
        m_Except_text = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Except_text;
}

inline
bool CSeq_feat_Base::IsSetIds(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CSeq_feat_Base::CanGetIds(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TIds& CSeq_feat_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CSeq_feat_Base::TIds& CSeq_feat_Base::SetIds(void)
{
    m_set_State[1] |= 0x1;
    return m_Ids;
}

inline
bool CSeq_feat_Base::IsSetExts(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CSeq_feat_Base::CanGetExts(void) const
{
    return true;
}

inline
const CSeq_feat_Base::TExts& CSeq_feat_Base::GetExts(void) const
{
    return m_Exts;
}

inline
CSeq_feat_Base::TExts& CSeq_feat_Base::SetExts(void)
{
    m_set_State[1] |= 0x4;
    return m_Exts;
}

inline
bool CSeq_feat_Base::IsSetSupport(void) const
{
    return m_Support.NotEmpty();
}

inline
bool CSeq_feat_Base::CanGetSupport(void) const
{
    return IsSetSupport();
}

inline
const CSeq_feat_Base::TSupport& CSeq_feat_Base::GetSupport(void) const
{
    if (!CanGetSupport()) {
        ThrowUnassigned(18);
    }
    return (*m_Support);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_SEQ_FEAT_BASE_HPP
