/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Seq_annot_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_SEQ_ANNOT_INFO_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_SEQ_ANNOT_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Feat_type_Info;
class CID2S_Seq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Seq_annot_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Seq_annot_Info_Base(void);
    // destructor
    virtual ~CID2S_Seq_annot_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef list< CRef< CID2S_Feat_type_Info > > TFeat;
    typedef CID2S_Seq_loc TSeq_loc;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_align,
        e_graph,
        e_feat,
        e_seq_loc
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// name is set if this is named annot
    /// name may be empty which differ from unnamed annot
    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    ///  Check whether the Align data member has been assigned a value.
    bool IsSetAlign(void) const;
    /// Check whether it is safe or not to call GetAlign method.
    bool CanGetAlign(void) const;
    void ResetAlign(void);
    void SetAlign(void);

    /// optional
    ///  Check whether the Graph data member has been assigned a value.
    bool IsSetGraph(void) const;
    /// Check whether it is safe or not to call GetGraph method.
    bool CanGetGraph(void) const;
    void ResetGraph(void);
    void SetGraph(void);

    /// optional
    /// typedef list< CRef< CID2S_Feat_type_Info > > TFeat
    ///  Check whether the Feat data member has been assigned a value.
    bool IsSetFeat(void) const;
    /// Check whether it is safe or not to call GetFeat method.
    bool CanGetFeat(void) const;
    void ResetFeat(void);
    const TFeat& GetFeat(void) const;
    TFeat& SetFeat(void);

    /// optional
    /// typedef CID2S_Seq_loc TSeq_loc
    ///  Check whether the Seq_loc data member has been assigned a value.
    bool IsSetSeq_loc(void) const;
    /// Check whether it is safe or not to call GetSeq_loc method.
    bool CanGetSeq_loc(void) const;
    void ResetSeq_loc(void);
    const TSeq_loc& GetSeq_loc(void) const;
    void SetSeq_loc(TSeq_loc& value);
    TSeq_loc& SetSeq_loc(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Seq_annot_Info_Base(const CID2S_Seq_annot_Info_Base&);
    CID2S_Seq_annot_Info_Base& operator=(const CID2S_Seq_annot_Info_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    list< CRef< CID2S_Feat_type_Info > > m_Feat;
    CRef< TSeq_loc > m_Seq_loc;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Seq_annot_Info_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2S_Seq_annot_Info_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CID2S_Seq_annot_Info_Base::TName& CID2S_Seq_annot_Info_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CID2S_Seq_annot_Info_Base::SetName(const CID2S_Seq_annot_Info_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CID2S_Seq_annot_Info_Base::SetName(CID2S_Seq_annot_Info_Base::TName&& value)
{
    m_Name = std::forward<CID2S_Seq_annot_Info_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CID2S_Seq_annot_Info_Base::TName& CID2S_Seq_annot_Info_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CID2S_Seq_annot_Info_Base::IsSetAlign(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Seq_annot_Info_Base::CanGetAlign(void) const
{
    return false;
}

inline
void CID2S_Seq_annot_Info_Base::ResetAlign(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CID2S_Seq_annot_Info_Base::SetAlign(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CID2S_Seq_annot_Info_Base::IsSetGraph(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2S_Seq_annot_Info_Base::CanGetGraph(void) const
{
    return false;
}

inline
void CID2S_Seq_annot_Info_Base::ResetGraph(void)
{
    m_set_State[0] &= ~0x30;
}

inline
void CID2S_Seq_annot_Info_Base::SetGraph(void)
{
    m_set_State[0] |= 0x30;
}

inline
bool CID2S_Seq_annot_Info_Base::IsSetFeat(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CID2S_Seq_annot_Info_Base::CanGetFeat(void) const
{
    return true;
}

inline
const CID2S_Seq_annot_Info_Base::TFeat& CID2S_Seq_annot_Info_Base::GetFeat(void) const
{
    return m_Feat;
}

inline
CID2S_Seq_annot_Info_Base::TFeat& CID2S_Seq_annot_Info_Base::SetFeat(void)
{
    m_set_State[0] |= 0x40;
    return m_Feat;
}

inline
bool CID2S_Seq_annot_Info_Base::IsSetSeq_loc(void) const
{
    return m_Seq_loc.NotEmpty();
}

inline
bool CID2S_Seq_annot_Info_Base::CanGetSeq_loc(void) const
{
    return IsSetSeq_loc();
}

inline
const CID2S_Seq_annot_Info_Base::TSeq_loc& CID2S_Seq_annot_Info_Base::GetSeq_loc(void) const
{
    if (!CanGetSeq_loc()) {
        ThrowUnassigned(4);
    }
    return (*m_Seq_loc);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_SEQ_ANNOT_INFO_BASE_HPP
