/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Seq_assembly_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_SEQ_ASSEMBLY_INFO_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_SEQ_ASSEMBLY_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Bioseq_Ids;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Seq_assembly_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Seq_assembly_Info_Base(void);
    // destructor
    virtual ~CID2S_Seq_assembly_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID2S_Bioseq_Ids TBioseqs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_bioseqs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID2S_Bioseq_Ids TBioseqs
    ///  Check whether the Bioseqs data member has been assigned a value.
    bool IsSetBioseqs(void) const;
    /// Check whether it is safe or not to call GetBioseqs method.
    bool CanGetBioseqs(void) const;
    void ResetBioseqs(void);
    const TBioseqs& GetBioseqs(void) const;
    void SetBioseqs(TBioseqs& value);
    TBioseqs& SetBioseqs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Seq_assembly_Info_Base(const CID2S_Seq_assembly_Info_Base&);
    CID2S_Seq_assembly_Info_Base& operator=(const CID2S_Seq_assembly_Info_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBioseqs > m_Bioseqs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Seq_assembly_Info_Base::IsSetBioseqs(void) const
{
    return m_Bioseqs.NotEmpty();
}

inline
bool CID2S_Seq_assembly_Info_Base::CanGetBioseqs(void) const
{
    return true;
}

inline
const CID2S_Seq_assembly_Info_Base::TBioseqs& CID2S_Seq_assembly_Info_Base::GetBioseqs(void) const
{
    if ( !m_Bioseqs ) {
        const_cast<CID2S_Seq_assembly_Info_Base*>(this)->ResetBioseqs();
    }
    return (*m_Bioseqs);
}

inline
CID2S_Seq_assembly_Info_Base::TBioseqs& CID2S_Seq_assembly_Info_Base::SetBioseqs(void)
{
    if ( !m_Bioseqs ) {
        ResetBioseqs();
    }
    return (*m_Bioseqs);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_SEQ_ASSEMBLY_INFO_BASE_HPP
