/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTestResults_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtest.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTEST_SEQTESTRESULTS_BASE_HPP
#define OBJECTS_SEQTEST_SEQTESTRESULTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_align;
class CSeq_feat;
class CSeq_id;
class CSeq_test_result_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQTEST_EXPORT CSeqTestResults_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTestResults_Base(void);
    // destructor
    virtual ~CSeqTestResults_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SEQTEST_EXPORT C_Source : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Source(void);
        // destructor
        ~C_Source(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Seq_id,
            e_Seq_feat,
            e_Seq_align
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Seq_align+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CSeq_id TSeq_id;
        typedef CSeq_feat TSeq_feat;
        typedef CSeq_align TSeq_align;
    
        // getters
        // setters
    
        // typedef CSeq_id TSeq_id
        bool IsSeq_id(void) const;
        const TSeq_id& GetSeq_id(void) const;
        TSeq_id& SetSeq_id(void);
        void SetSeq_id(TSeq_id& value);
    
        // typedef CSeq_feat TSeq_feat
        bool IsSeq_feat(void) const;
        const TSeq_feat& GetSeq_feat(void) const;
        TSeq_feat& SetSeq_feat(void);
        void SetSeq_feat(TSeq_feat& value);
    
        // typedef CSeq_align TSeq_align
        bool IsSeq_align(void) const;
        const TSeq_align& GetSeq_align(void) const;
        TSeq_align& SetSeq_align(void);
        void SetSeq_align(TSeq_align& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Source(const C_Source& );
        C_Source& operator=(const C_Source& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef C_Source TSource;
    typedef CSeq_test_result_set TResults;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_source,
        e_results
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Source TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    void SetSource(TSource& value);
    TSource& SetSource(void);

    /// mandatory
    /// typedef CSeq_test_result_set TResults
    ///  Check whether the Results data member has been assigned a value.
    bool IsSetResults(void) const;
    /// Check whether it is safe or not to call GetResults method.
    bool CanGetResults(void) const;
    void ResetResults(void);
    const TResults& GetResults(void) const;
    void SetResults(TResults& value);
    TResults& SetResults(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqTestResults_Base(const CSeqTestResults_Base&);
    CSeqTestResults_Base& operator=(const CSeqTestResults_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSource > m_Source;
    CRef< TResults > m_Results;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqTestResults_Base::C_Source::E_Choice CSeqTestResults_Base::C_Source::Which(void) const
{
    return m_choice;
}

inline
void CSeqTestResults_Base::C_Source::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqTestResults_Base::C_Source::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqTestResults_Base::C_Source::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqTestResults_Base::C_Source::IsSeq_id(void) const
{
    return m_choice == e_Seq_id;
}

inline
bool CSeqTestResults_Base::C_Source::IsSeq_feat(void) const
{
    return m_choice == e_Seq_feat;
}

inline
bool CSeqTestResults_Base::C_Source::IsSeq_align(void) const
{
    return m_choice == e_Seq_align;
}

inline
bool CSeqTestResults_Base::IsSetSource(void) const
{
    return m_Source.NotEmpty();
}

inline
bool CSeqTestResults_Base::CanGetSource(void) const
{
    return true;
}

inline
const CSeqTestResults_Base::TSource& CSeqTestResults_Base::GetSource(void) const
{
    if ( !m_Source ) {
        const_cast<CSeqTestResults_Base*>(this)->ResetSource();
    }
    return (*m_Source);
}

inline
CSeqTestResults_Base::TSource& CSeqTestResults_Base::SetSource(void)
{
    if ( !m_Source ) {
        ResetSource();
    }
    return (*m_Source);
}

inline
bool CSeqTestResults_Base::IsSetResults(void) const
{
    return m_Results.NotEmpty();
}

inline
bool CSeqTestResults_Base::CanGetResults(void) const
{
    return true;
}

inline
const CSeqTestResults_Base::TResults& CSeqTestResults_Base::GetResults(void) const
{
    if ( !m_Results ) {
        const_cast<CSeqTestResults_Base*>(this)->ResetResults();
    }
    return (*m_Results);
}

inline
CSeqTestResults_Base::TResults& CSeqTestResults_Base::SetResults(void)
{
    if ( !m_Results ) {
        ResetResults();
    }
    return (*m_Results);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTEST_SEQTESTRESULTS_BASE_HPP
