/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_Attribute_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_ATTRIBUTE_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_ATTRIBUTE_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_Attribute_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_Attribute_Base(void);
    // destructor
    virtual ~CTMgr_Attribute_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TKey;
    typedef CStringUTF8 TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_key,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TKey
    ///  Check whether the Key data member has been assigned a value.
    bool IsSetKey(void) const;
    /// Check whether it is safe or not to call GetKey method.
    bool CanGetKey(void) const;
    void ResetKey(void);
    const TKey& GetKey(void) const;
    void SetKey(const TKey& value);
    void SetKey(TKey&& value);
    TKey& SetKey(void);

    /// mandatory
    /// typedef CStringUTF8 TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_Attribute_Base(const CTMgr_Attribute_Base&);
    CTMgr_Attribute_Base& operator=(const CTMgr_Attribute_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Key;
    CStringUTF8 m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_Attribute_Base::IsSetKey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_Attribute_Base::CanGetKey(void) const
{
    return IsSetKey();
}

inline
const CTMgr_Attribute_Base::TKey& CTMgr_Attribute_Base::GetKey(void) const
{
    if (!CanGetKey()) {
        ThrowUnassigned(0);
    }
    return m_Key;
}

inline
void CTMgr_Attribute_Base::SetKey(const CTMgr_Attribute_Base::TKey& value)
{
    m_Key = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_Attribute_Base::SetKey(CTMgr_Attribute_Base::TKey&& value)
{
    m_Key = std::forward<CTMgr_Attribute_Base::TKey>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_Attribute_Base::TKey& CTMgr_Attribute_Base::SetKey(void)
{
#ifdef _DEBUG
    if (!IsSetKey()) {
        m_Key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Key;
}

inline
bool CTMgr_Attribute_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_Attribute_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CTMgr_Attribute_Base::TValue& CTMgr_Attribute_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CTMgr_Attribute_Base::SetValue(const CTMgr_Attribute_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_Attribute_Base::SetValue(CTMgr_Attribute_Base::TValue&& value)
{
    m_Value = std::forward<CTMgr_Attribute_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_Attribute_Base::TValue& CTMgr_Attribute_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_ATTRIBUTE_BASE_HPP
