/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_CreateUserDataItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_CREATEUSERDATAITEM_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_CREATEUSERDATAITEM_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_Attribute;
class CTMgr_DatasetItemSeq;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_CreateUserDataItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_CreateUserDataItem_Base(void);
    // destructor
    virtual ~CTMgr_CreateUserDataItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TDatakey;
    typedef list< string > TSeqids;
    typedef list< CRef< CTMgr_Attribute > > TAttrs;
    typedef list< CRef< CTMgr_DatasetItemSeq > > TSeqs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_datakey,
        e_seqids,
        e_attrs,
        e_seqs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TDatakey
    ///  Check whether the Datakey data member has been assigned a value.
    bool IsSetDatakey(void) const;
    /// Check whether it is safe or not to call GetDatakey method.
    bool CanGetDatakey(void) const;
    void ResetDatakey(void);
    const TDatakey& GetDatakey(void) const;
    void SetDatakey(const TDatakey& value);
    void SetDatakey(TDatakey&& value);
    TDatakey& SetDatakey(void);

    /// mandatory
    /// typedef list< string > TSeqids
    ///  Check whether the Seqids data member has been assigned a value.
    bool IsSetSeqids(void) const;
    /// Check whether it is safe or not to call GetSeqids method.
    bool CanGetSeqids(void) const;
    void ResetSeqids(void);
    const TSeqids& GetSeqids(void) const;
    TSeqids& SetSeqids(void);

    /// optional
    /// typedef list< CRef< CTMgr_Attribute > > TAttrs
    ///  Check whether the Attrs data member has been assigned a value.
    bool IsSetAttrs(void) const;
    /// Check whether it is safe or not to call GetAttrs method.
    bool CanGetAttrs(void) const;
    void ResetAttrs(void);
    const TAttrs& GetAttrs(void) const;
    TAttrs& SetAttrs(void);

    /// optional
    /// typedef list< CRef< CTMgr_DatasetItemSeq > > TSeqs
    ///  Check whether the Seqs data member has been assigned a value.
    bool IsSetSeqs(void) const;
    /// Check whether it is safe or not to call GetSeqs method.
    bool CanGetSeqs(void) const;
    void ResetSeqs(void);
    const TSeqs& GetSeqs(void) const;
    TSeqs& SetSeqs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_CreateUserDataItem_Base(const CTMgr_CreateUserDataItem_Base&);
    CTMgr_CreateUserDataItem_Base& operator=(const CTMgr_CreateUserDataItem_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Datakey;
    list< string > m_Seqids;
    list< CRef< CTMgr_Attribute > > m_Attrs;
    list< CRef< CTMgr_DatasetItemSeq > > m_Seqs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_CreateUserDataItem_Base::IsSetDatakey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_CreateUserDataItem_Base::CanGetDatakey(void) const
{
    return IsSetDatakey();
}

inline
const CTMgr_CreateUserDataItem_Base::TDatakey& CTMgr_CreateUserDataItem_Base::GetDatakey(void) const
{
    if (!CanGetDatakey()) {
        ThrowUnassigned(0);
    }
    return m_Datakey;
}

inline
void CTMgr_CreateUserDataItem_Base::SetDatakey(const CTMgr_CreateUserDataItem_Base::TDatakey& value)
{
    m_Datakey = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_CreateUserDataItem_Base::SetDatakey(CTMgr_CreateUserDataItem_Base::TDatakey&& value)
{
    m_Datakey = std::forward<CTMgr_CreateUserDataItem_Base::TDatakey>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_CreateUserDataItem_Base::TDatakey& CTMgr_CreateUserDataItem_Base::SetDatakey(void)
{
#ifdef _DEBUG
    if (!IsSetDatakey()) {
        m_Datakey = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Datakey;
}

inline
bool CTMgr_CreateUserDataItem_Base::IsSetSeqids(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_CreateUserDataItem_Base::CanGetSeqids(void) const
{
    return true;
}

inline
const CTMgr_CreateUserDataItem_Base::TSeqids& CTMgr_CreateUserDataItem_Base::GetSeqids(void) const
{
    return m_Seqids;
}

inline
CTMgr_CreateUserDataItem_Base::TSeqids& CTMgr_CreateUserDataItem_Base::SetSeqids(void)
{
    m_set_State[0] |= 0x4;
    return m_Seqids;
}

inline
bool CTMgr_CreateUserDataItem_Base::IsSetAttrs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_CreateUserDataItem_Base::CanGetAttrs(void) const
{
    return true;
}

inline
const CTMgr_CreateUserDataItem_Base::TAttrs& CTMgr_CreateUserDataItem_Base::GetAttrs(void) const
{
    return m_Attrs;
}

inline
CTMgr_CreateUserDataItem_Base::TAttrs& CTMgr_CreateUserDataItem_Base::SetAttrs(void)
{
    m_set_State[0] |= 0x10;
    return m_Attrs;
}

inline
bool CTMgr_CreateUserDataItem_Base::IsSetSeqs(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_CreateUserDataItem_Base::CanGetSeqs(void) const
{
    return true;
}

inline
const CTMgr_CreateUserDataItem_Base::TSeqs& CTMgr_CreateUserDataItem_Base::GetSeqs(void) const
{
    return m_Seqs;
}

inline
CTMgr_CreateUserDataItem_Base::TSeqs& CTMgr_CreateUserDataItem_Base::SetSeqs(void)
{
    m_set_State[0] |= 0x40;
    return m_Seqs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_CREATEUSERDATAITEM_BASE_HPP
