/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_ItemResolverRequest_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_ITEMRESOLVERREQUEST_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_ITEMRESOLVERREQUEST_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;
class CTMgr_AttrSpec;
class CTMgr_ClientInfo;
class CTMgr_DTrackId;
class CTMgr_GenomeContext;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_ItemResolverRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_ItemResolverRequest_Base(void);
    // destructor
    virtual ~CTMgr_ItemResolverRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_TRACKMGR_EXPORT C_Flags : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Flags(void);
        // destructor
        ~C_Flags(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef bool TInclude_stats;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_include_stats
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default false
        /// typedef bool TInclude_stats
        ///  Check whether the Include_stats data member has been assigned a value.
        bool IsSetInclude_stats(void) const;
        /// Check whether it is safe or not to call GetInclude_stats method.
        bool CanGetInclude_stats(void) const;
        void ResetInclude_stats(void);
        void SetDefaultInclude_stats(void);
        TInclude_stats GetInclude_stats(void) const;
        void SetInclude_stats(TInclude_stats value);
        TInclude_stats& SetInclude_stats(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Flags(const C_Flags&);
        C_Flags& operator=(const C_Flags&);
    
        // data
        Uint4 m_set_State[1];
        bool m_Include_stats;
    };
    // types
    typedef list< CRef< CTMgr_DTrackId > > TDtrack_ids;
    typedef CTMgr_ClientInfo TClient;
    typedef CTMgr_GenomeContext TGenome_context;
    typedef list< CRef< CTMgr_AttrSpec > > TAttrs;
    typedef CSeq_id TSequence;
    typedef C_Flags TFlags;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dtrack_ids,
        e_client,
        e_genome_context,
        e_attrs,
        e_sequence,
        e_flags
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< CTMgr_DTrackId > > TDtrack_ids
    ///  Check whether the Dtrack_ids data member has been assigned a value.
    bool IsSetDtrack_ids(void) const;
    /// Check whether it is safe or not to call GetDtrack_ids method.
    bool CanGetDtrack_ids(void) const;
    void ResetDtrack_ids(void);
    const TDtrack_ids& GetDtrack_ids(void) const;
    TDtrack_ids& SetDtrack_ids(void);

    /// mandatory
    /// typedef CTMgr_ClientInfo TClient
    ///  Check whether the Client data member has been assigned a value.
    bool IsSetClient(void) const;
    /// Check whether it is safe or not to call GetClient method.
    bool CanGetClient(void) const;
    void ResetClient(void);
    const TClient& GetClient(void) const;
    void SetClient(TClient& value);
    TClient& SetClient(void);

    /// mandatory
    /// typedef CTMgr_GenomeContext TGenome_context
    ///  Check whether the Genome_context data member has been assigned a value.
    bool IsSetGenome_context(void) const;
    /// Check whether it is safe or not to call GetGenome_context method.
    bool CanGetGenome_context(void) const;
    void ResetGenome_context(void);
    const TGenome_context& GetGenome_context(void) const;
    void SetGenome_context(TGenome_context& value);
    TGenome_context& SetGenome_context(void);

    /// optional
    /// typedef list< CRef< CTMgr_AttrSpec > > TAttrs
    ///  Check whether the Attrs data member has been assigned a value.
    bool IsSetAttrs(void) const;
    /// Check whether it is safe or not to call GetAttrs method.
    bool CanGetAttrs(void) const;
    void ResetAttrs(void);
    const TAttrs& GetAttrs(void) const;
    TAttrs& SetAttrs(void);

    /// resolve specifically for this top-level sequence
    /// optional
    /// typedef CSeq_id TSequence
    ///  Check whether the Sequence data member has been assigned a value.
    bool IsSetSequence(void) const;
    /// Check whether it is safe or not to call GetSequence method.
    bool CanGetSequence(void) const;
    void ResetSequence(void);
    const TSequence& GetSequence(void) const;
    void SetSequence(TSequence& value);
    TSequence& SetSequence(void);

    /// optional
    /// typedef C_Flags TFlags
    ///  Check whether the Flags data member has been assigned a value.
    bool IsSetFlags(void) const;
    /// Check whether it is safe or not to call GetFlags method.
    bool CanGetFlags(void) const;
    void ResetFlags(void);
    const TFlags& GetFlags(void) const;
    void SetFlags(TFlags& value);
    TFlags& SetFlags(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_ItemResolverRequest_Base(const CTMgr_ItemResolverRequest_Base&);
    CTMgr_ItemResolverRequest_Base& operator=(const CTMgr_ItemResolverRequest_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CTMgr_DTrackId > > m_Dtrack_ids;
    CRef< TClient > m_Client;
    CRef< TGenome_context > m_Genome_context;
    list< CRef< CTMgr_AttrSpec > > m_Attrs;
    CRef< TSequence > m_Sequence;
    CRef< TFlags > m_Flags;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_ItemResolverRequest_Base::C_Flags::IsSetInclude_stats(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_ItemResolverRequest_Base::C_Flags::CanGetInclude_stats(void) const
{
    return true;
}

inline
void CTMgr_ItemResolverRequest_Base::C_Flags::ResetInclude_stats(void)
{
    m_Include_stats = false;
    m_set_State[0] &= ~0x3;
}

inline
void CTMgr_ItemResolverRequest_Base::C_Flags::SetDefaultInclude_stats(void)
{
    ResetInclude_stats();
}

inline
CTMgr_ItemResolverRequest_Base::C_Flags::TInclude_stats CTMgr_ItemResolverRequest_Base::C_Flags::GetInclude_stats(void) const
{
    return m_Include_stats;
}

inline
void CTMgr_ItemResolverRequest_Base::C_Flags::SetInclude_stats(CTMgr_ItemResolverRequest_Base::C_Flags::TInclude_stats value)
{
    m_Include_stats = value;
    m_set_State[0] |= 0x3;
}

inline
CTMgr_ItemResolverRequest_Base::C_Flags::TInclude_stats& CTMgr_ItemResolverRequest_Base::C_Flags::SetInclude_stats(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_stats()) {
        memset(&m_Include_stats,UnassignedByte(),sizeof(m_Include_stats));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Include_stats;
}

inline
bool CTMgr_ItemResolverRequest_Base::IsSetDtrack_ids(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_ItemResolverRequest_Base::CanGetDtrack_ids(void) const
{
    return true;
}

inline
const CTMgr_ItemResolverRequest_Base::TDtrack_ids& CTMgr_ItemResolverRequest_Base::GetDtrack_ids(void) const
{
    return m_Dtrack_ids;
}

inline
CTMgr_ItemResolverRequest_Base::TDtrack_ids& CTMgr_ItemResolverRequest_Base::SetDtrack_ids(void)
{
    m_set_State[0] |= 0x1;
    return m_Dtrack_ids;
}

inline
bool CTMgr_ItemResolverRequest_Base::IsSetClient(void) const
{
    return m_Client.NotEmpty();
}

inline
bool CTMgr_ItemResolverRequest_Base::CanGetClient(void) const
{
    return true;
}

inline
const CTMgr_ItemResolverRequest_Base::TClient& CTMgr_ItemResolverRequest_Base::GetClient(void) const
{
    if ( !m_Client ) {
        const_cast<CTMgr_ItemResolverRequest_Base*>(this)->ResetClient();
    }
    return (*m_Client);
}

inline
CTMgr_ItemResolverRequest_Base::TClient& CTMgr_ItemResolverRequest_Base::SetClient(void)
{
    if ( !m_Client ) {
        ResetClient();
    }
    return (*m_Client);
}

inline
bool CTMgr_ItemResolverRequest_Base::IsSetGenome_context(void) const
{
    return m_Genome_context.NotEmpty();
}

inline
bool CTMgr_ItemResolverRequest_Base::CanGetGenome_context(void) const
{
    return true;
}

inline
const CTMgr_ItemResolverRequest_Base::TGenome_context& CTMgr_ItemResolverRequest_Base::GetGenome_context(void) const
{
    if ( !m_Genome_context ) {
        const_cast<CTMgr_ItemResolverRequest_Base*>(this)->ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
CTMgr_ItemResolverRequest_Base::TGenome_context& CTMgr_ItemResolverRequest_Base::SetGenome_context(void)
{
    if ( !m_Genome_context ) {
        ResetGenome_context();
    }
    return (*m_Genome_context);
}

inline
bool CTMgr_ItemResolverRequest_Base::IsSetAttrs(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_ItemResolverRequest_Base::CanGetAttrs(void) const
{
    return true;
}

inline
const CTMgr_ItemResolverRequest_Base::TAttrs& CTMgr_ItemResolverRequest_Base::GetAttrs(void) const
{
    return m_Attrs;
}

inline
CTMgr_ItemResolverRequest_Base::TAttrs& CTMgr_ItemResolverRequest_Base::SetAttrs(void)
{
    m_set_State[0] |= 0x40;
    return m_Attrs;
}

inline
bool CTMgr_ItemResolverRequest_Base::IsSetSequence(void) const
{
    return m_Sequence.NotEmpty();
}

inline
bool CTMgr_ItemResolverRequest_Base::CanGetSequence(void) const
{
    return IsSetSequence();
}

inline
const CTMgr_ItemResolverRequest_Base::TSequence& CTMgr_ItemResolverRequest_Base::GetSequence(void) const
{
    if (!CanGetSequence()) {
        ThrowUnassigned(4);
    }
    return (*m_Sequence);
}

inline
bool CTMgr_ItemResolverRequest_Base::IsSetFlags(void) const
{
    return m_Flags.NotEmpty();
}

inline
bool CTMgr_ItemResolverRequest_Base::CanGetFlags(void) const
{
    return IsSetFlags();
}

inline
const CTMgr_ItemResolverRequest_Base::TFlags& CTMgr_ItemResolverRequest_Base::GetFlags(void) const
{
    if (!CanGetFlags()) {
        ThrowUnassigned(5);
    }
    return (*m_Flags);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_ITEMRESOLVERREQUEST_BASE_HPP
