/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file VariantExpression_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_VARIANTEXPRESSION_BASE_HPP
#define OBJECTS_VARREP_VARIANTEXPRESSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSequenceVariant;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///EXPORTS VariantExpression, SimpleVariant;
class CVariantExpression_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CVariantExpression_Base(void);
    // destructor
    virtual ~CVariantExpression_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TInput_expr;
    typedef string TReference_id;
    typedef CSequenceVariant TSequence_variant;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_input_expr,
        e_reference_id,
        e_sequence_variant
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// contains the input expression to be parsed
    /// mandatory
    /// typedef string TInput_expr
    ///  Check whether the Input_expr data member has been assigned a value.
    bool IsSetInput_expr(void) const;
    /// Check whether it is safe or not to call GetInput_expr method.
    bool CanGetInput_expr(void) const;
    void ResetInput_expr(void);
    const TInput_expr& GetInput_expr(void) const;
    void SetInput_expr(const TInput_expr& value);
    void SetInput_expr(TInput_expr&& value);
    TInput_expr& SetInput_expr(void);

    /// contains the accession id or other identifier for the reference sequence
    /// mandatory
    /// typedef string TReference_id
    ///  Check whether the Reference_id data member has been assigned a value.
    bool IsSetReference_id(void) const;
    /// Check whether it is safe or not to call GetReference_id method.
    bool CanGetReference_id(void) const;
    void ResetReference_id(void);
    const TReference_id& GetReference_id(void) const;
    void SetReference_id(const TReference_id& value);
    void SetReference_id(TReference_id&& value);
    TReference_id& SetReference_id(void);

    /// mandatory
    /// typedef CSequenceVariant TSequence_variant
    ///  Check whether the Sequence_variant data member has been assigned a value.
    bool IsSetSequence_variant(void) const;
    /// Check whether it is safe or not to call GetSequence_variant method.
    bool CanGetSequence_variant(void) const;
    void ResetSequence_variant(void);
    const TSequence_variant& GetSequence_variant(void) const;
    void SetSequence_variant(TSequence_variant& value);
    TSequence_variant& SetSequence_variant(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CVariantExpression_Base(const CVariantExpression_Base&);
    CVariantExpression_Base& operator=(const CVariantExpression_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Input_expr;
    string m_Reference_id;
    CRef< TSequence_variant > m_Sequence_variant;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CVariantExpression_Base::IsSetInput_expr(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariantExpression_Base::CanGetInput_expr(void) const
{
    return IsSetInput_expr();
}

inline
const CVariantExpression_Base::TInput_expr& CVariantExpression_Base::GetInput_expr(void) const
{
    if (!CanGetInput_expr()) {
        ThrowUnassigned(0);
    }
    return m_Input_expr;
}

inline
void CVariantExpression_Base::SetInput_expr(const CVariantExpression_Base::TInput_expr& value)
{
    m_Input_expr = value;
    m_set_State[0] |= 0x3;
}

inline
void CVariantExpression_Base::SetInput_expr(CVariantExpression_Base::TInput_expr&& value)
{
    m_Input_expr = std::forward<CVariantExpression_Base::TInput_expr>(value);
    m_set_State[0] |= 0x3;
}

inline
CVariantExpression_Base::TInput_expr& CVariantExpression_Base::SetInput_expr(void)
{
#ifdef _DEBUG
    if (!IsSetInput_expr()) {
        m_Input_expr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Input_expr;
}

inline
bool CVariantExpression_Base::IsSetReference_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariantExpression_Base::CanGetReference_id(void) const
{
    return IsSetReference_id();
}

inline
const CVariantExpression_Base::TReference_id& CVariantExpression_Base::GetReference_id(void) const
{
    if (!CanGetReference_id()) {
        ThrowUnassigned(1);
    }
    return m_Reference_id;
}

inline
void CVariantExpression_Base::SetReference_id(const CVariantExpression_Base::TReference_id& value)
{
    m_Reference_id = value;
    m_set_State[0] |= 0xc;
}

inline
void CVariantExpression_Base::SetReference_id(CVariantExpression_Base::TReference_id&& value)
{
    m_Reference_id = std::forward<CVariantExpression_Base::TReference_id>(value);
    m_set_State[0] |= 0xc;
}

inline
CVariantExpression_Base::TReference_id& CVariantExpression_Base::SetReference_id(void)
{
#ifdef _DEBUG
    if (!IsSetReference_id()) {
        m_Reference_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Reference_id;
}

inline
bool CVariantExpression_Base::IsSetSequence_variant(void) const
{
    return m_Sequence_variant.NotEmpty();
}

inline
bool CVariantExpression_Base::CanGetSequence_variant(void) const
{
    return true;
}

inline
const CVariantExpression_Base::TSequence_variant& CVariantExpression_Base::GetSequence_variant(void) const
{
    if ( !m_Sequence_variant ) {
        const_cast<CVariantExpression_Base*>(this)->ResetSequence_variant();
    }
    return (*m_Sequence_variant);
}

inline
CVariantExpression_Base::TSequence_variant& CVariantExpression_Base::SetSequence_variant(void)
{
    if ( !m_Sequence_variant ) {
        ResetSequence_variant();
    }
    return (*m_Sequence_variant);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_VARIANTEXPRESSION_BASE_HPP
