/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Grant_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_GRANT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_GRANT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAcronym;
class CAgency;
class CCountry;
class CGrantID;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGrant_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CGrant_Base(void);
    // destructor
    virtual ~CGrant_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CGrantID TGrantID;
    typedef CAcronym TAcronym;
    typedef CAgency TAgency;
    typedef CCountry TCountry;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_GrantID,
        e_Acronym,
        e_Agency,
        e_Country
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CGrantID TGrantID
    ///  Check whether the GrantID data member has been assigned a value.
    bool IsSetGrantID(void) const;
    /// Check whether it is safe or not to call GetGrantID method.
    bool CanGetGrantID(void) const;
    void ResetGrantID(void);
    const TGrantID& GetGrantID(void) const;
    void SetGrantID(TGrantID& value);
    TGrantID& SetGrantID(void);

    /// optional
    /// typedef CAcronym TAcronym
    ///  Check whether the Acronym data member has been assigned a value.
    bool IsSetAcronym(void) const;
    /// Check whether it is safe or not to call GetAcronym method.
    bool CanGetAcronym(void) const;
    void ResetAcronym(void);
    const TAcronym& GetAcronym(void) const;
    void SetAcronym(TAcronym& value);
    TAcronym& SetAcronym(void);

    /// mandatory
    /// typedef CAgency TAgency
    ///  Check whether the Agency data member has been assigned a value.
    bool IsSetAgency(void) const;
    /// Check whether it is safe or not to call GetAgency method.
    bool CanGetAgency(void) const;
    void ResetAgency(void);
    const TAgency& GetAgency(void) const;
    void SetAgency(TAgency& value);
    TAgency& SetAgency(void);

    /// mandatory
    /// typedef CCountry TCountry
    ///  Check whether the Country data member has been assigned a value.
    bool IsSetCountry(void) const;
    /// Check whether it is safe or not to call GetCountry method.
    bool CanGetCountry(void) const;
    void ResetCountry(void);
    const TCountry& GetCountry(void) const;
    void SetCountry(TCountry& value);
    TCountry& SetCountry(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGrant_Base(const CGrant_Base&);
    CGrant_Base& operator=(const CGrant_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TGrantID > m_GrantID;
    NCBI_NS_NCBI::CRef< TAcronym > m_Acronym;
    NCBI_NS_NCBI::CRef< TAgency > m_Agency;
    NCBI_NS_NCBI::CRef< TCountry > m_Country;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGrant_Base::IsSetGrantID(void) const
{
    return m_GrantID.NotEmpty();
}

inline
bool CGrant_Base::CanGetGrantID(void) const
{
    return IsSetGrantID();
}

inline
const CGrant_Base::TGrantID& CGrant_Base::GetGrantID(void) const
{
    if (!CanGetGrantID()) {
        ThrowUnassigned(0);
    }
    return (*m_GrantID);
}

inline
bool CGrant_Base::IsSetAcronym(void) const
{
    return m_Acronym.NotEmpty();
}

inline
bool CGrant_Base::CanGetAcronym(void) const
{
    return IsSetAcronym();
}

inline
const CGrant_Base::TAcronym& CGrant_Base::GetAcronym(void) const
{
    if (!CanGetAcronym()) {
        ThrowUnassigned(1);
    }
    return (*m_Acronym);
}

inline
bool CGrant_Base::IsSetAgency(void) const
{
    return m_Agency.NotEmpty();
}

inline
bool CGrant_Base::CanGetAgency(void) const
{
    return true;
}

inline
const CGrant_Base::TAgency& CGrant_Base::GetAgency(void) const
{
    if ( !m_Agency ) {
        const_cast<CGrant_Base*>(this)->ResetAgency();
    }
    return (*m_Agency);
}

inline
CGrant_Base::TAgency& CGrant_Base::SetAgency(void)
{
    if ( !m_Agency ) {
        ResetAgency();
    }
    return (*m_Agency);
}

inline
bool CGrant_Base::IsSetCountry(void) const
{
    return m_Country.NotEmpty();
}

inline
bool CGrant_Base::CanGetCountry(void) const
{
    return true;
}

inline
const CGrant_Base::TCountry& CGrant_Base::GetCountry(void) const
{
    if ( !m_Country ) {
        const_cast<CGrant_Base*>(this)->ResetCountry();
    }
    return (*m_Country);
}

inline
CGrant_Base::TCountry& CGrant_Base::SetCountry(void)
{
    if ( !m_Country ) {
        ResetCountry();
    }
    return (*m_Country);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_GRANT_BASE_HPP
