/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Identifier.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// New methods or data members can be added to it if needed.
/// See also: Identifier_.hpp


#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_IDENTIFIER_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_IDENTIFIER_HPP


// generated includes
#include <objtools/eutils/efetch/Identifier_.hpp>

// generated classes

BEGIN_eutils_SCOPE // namespace eutils::

/////////////////////////////////////////////////////////////////////////////
class CIdentifier : public CIdentifier_Base
{
    typedef CIdentifier_Base Tparent;
public:
    // constructor
    CIdentifier(void);
    CIdentifier(const std::string& value);
    // destructor
    ~CIdentifier(void);

    // typedef std::string TIdentifier;

    /// Conversion operator to 'TIdentifier' type.
    operator const TIdentifier&(void) const;
    /// Assignment operator.
    CIdentifier& operator=(const TIdentifier& value);

private:
    // Prohibit copy constructor and assignment operator
    CIdentifier(const CIdentifier& value);
    CIdentifier& operator=(const CIdentifier& value);

};

/////////////////// CIdentifier inline methods

// constructor
inline
CIdentifier::CIdentifier(void)
{
}

inline
CIdentifier::CIdentifier(const std::string& value)
{
    SetIdentifier(value);
}

inline
CIdentifier::operator const CIdentifier::TIdentifier&(void) const
{
    return GetIdentifier();
}

inline
CIdentifier& CIdentifier::operator=(const TIdentifier& value)
{
    SetIdentifier(value);
    return *this;
}


/////////////////// end of CIdentifier inline methods


END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_IDENTIFIER_HPP
/* Original file checksum: lines: 109, chars: 2970, CRC32: d1045f2e */
