/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mglyph_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MGLYPH_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MGLYPH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMglyph_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMglyph_Base(void);
    // destructor
    virtual ~CMglyph_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_mathvariant {
            eAttlist_mathvariant_normal                 =  1,
            eAttlist_mathvariant_bold                   =  2,
            eAttlist_mathvariant_italic                 =  3,
            eAttlist_mathvariant_bold_italic            =  4,
            eAttlist_mathvariant_double_struck          =  5,
            eAttlist_mathvariant_bold_fraktur           =  6,
            eAttlist_mathvariant_script                 =  7,
            eAttlist_mathvariant_bold_script            =  8,
            eAttlist_mathvariant_fraktur                =  9,
            eAttlist_mathvariant_sans_serif             = 10,
            eAttlist_mathvariant_bold_sans_serif        = 11,
            eAttlist_mathvariant_sans_serif_italic      = 12,
            eAttlist_mathvariant_sans_serif_bold_italic = 13,
            eAttlist_mathvariant_monospace              = 14,
            eAttlist_mathvariant_initial                = 15,
            eAttlist_mathvariant_tailed                 = 16,
            eAttlist_mathvariant_looped                 = 17,
            eAttlist_mathvariant_stretched              = 18
        };
        
        /// Access to EAttlist_mathvariant's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_mathvariant)(void);
        
        enum EAttlist_fontweight {
            eAttlist_fontweight_normal = 1,
            eAttlist_fontweight_bold   = 2
        };
        
        /// Access to EAttlist_fontweight's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontweight)(void);
        
        enum EAttlist_fontstyle {
            eAttlist_fontstyle_normal = 1,
            eAttlist_fontstyle_italic = 2
        };
        
        /// Access to EAttlist_fontstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fontstyle)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TSrc;
        typedef NCBI_NS_STD::string TWidth;
        typedef NCBI_NS_STD::string THeight;
        typedef NCBI_NS_STD::string TValign;
        typedef NCBI_NS_STD::string TAlt;
        typedef NCBI_NS_STD::string TIndex;
        typedef EAttlist_mathvariant TMathvariant;
        typedef NCBI_NS_STD::string TMathsize;
        typedef NCBI_NS_STD::string TFontfamily;
        typedef EAttlist_fontweight TFontweight;
        typedef EAttlist_fontstyle TFontstyle;
        typedef NCBI_NS_STD::string TFontsize;
        typedef NCBI_NS_STD::string TColor;
        typedef NCBI_NS_STD::string TBackground;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_src,
            e_width,
            e_height,
            e_valign,
            e_alt,
            e_index,
            e_mathvariant,
            e_mathsize,
            e_fontfamily,
            e_fontweight,
            e_fontstyle,
            e_fontsize,
            e_color,
            e_background
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 22> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSrc
        ///  Check whether the Src data member has been assigned a value.
        bool IsSetSrc(void) const;
        /// Check whether it is safe or not to call GetSrc method.
        bool CanGetSrc(void) const;
        void ResetSrc(void);
        const TSrc& GetSrc(void) const;
        void SetSrc(const TSrc& value);
        void SetSrc(TSrc&& value);
        TSrc& SetSrc(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TWidth
        ///  Check whether the Width data member has been assigned a value.
        bool IsSetWidth(void) const;
        /// Check whether it is safe or not to call GetWidth method.
        bool CanGetWidth(void) const;
        void ResetWidth(void);
        const TWidth& GetWidth(void) const;
        void SetWidth(const TWidth& value);
        void SetWidth(TWidth&& value);
        TWidth& SetWidth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THeight
        ///  Check whether the Height data member has been assigned a value.
        bool IsSetHeight(void) const;
        /// Check whether it is safe or not to call GetHeight method.
        bool CanGetHeight(void) const;
        void ResetHeight(void);
        const THeight& GetHeight(void) const;
        void SetHeight(const THeight& value);
        void SetHeight(THeight&& value);
        THeight& SetHeight(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TValign
        ///  Check whether the Valign data member has been assigned a value.
        bool IsSetValign(void) const;
        /// Check whether it is safe or not to call GetValign method.
        bool CanGetValign(void) const;
        void ResetValign(void);
        const TValign& GetValign(void) const;
        void SetValign(const TValign& value);
        void SetValign(TValign&& value);
        TValign& SetValign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAlt
        ///  Check whether the Alt data member has been assigned a value.
        bool IsSetAlt(void) const;
        /// Check whether it is safe or not to call GetAlt method.
        bool CanGetAlt(void) const;
        void ResetAlt(void);
        const TAlt& GetAlt(void) const;
        void SetAlt(const TAlt& value);
        void SetAlt(TAlt&& value);
        TAlt& SetAlt(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndex
        ///  Check whether the Index data member has been assigned a value.
        bool IsSetIndex(void) const;
        /// Check whether it is safe or not to call GetIndex method.
        bool CanGetIndex(void) const;
        void ResetIndex(void);
        const TIndex& GetIndex(void) const;
        void SetIndex(const TIndex& value);
        void SetIndex(TIndex&& value);
        TIndex& SetIndex(void);
    
        /// optional
        /// typedef EAttlist_mathvariant TMathvariant
        ///  Check whether the Mathvariant data member has been assigned a value.
        bool IsSetMathvariant(void) const;
        /// Check whether it is safe or not to call GetMathvariant method.
        bool CanGetMathvariant(void) const;
        void ResetMathvariant(void);
        TMathvariant GetMathvariant(void) const;
        void SetMathvariant(TMathvariant value);
        TMathvariant& SetMathvariant(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathsize
        ///  Check whether the Mathsize data member has been assigned a value.
        bool IsSetMathsize(void) const;
        /// Check whether it is safe or not to call GetMathsize method.
        bool CanGetMathsize(void) const;
        void ResetMathsize(void);
        const TMathsize& GetMathsize(void) const;
        void SetMathsize(const TMathsize& value);
        void SetMathsize(TMathsize&& value);
        TMathsize& SetMathsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontfamily
        ///  Check whether the Fontfamily data member has been assigned a value.
        bool IsSetFontfamily(void) const;
        /// Check whether it is safe or not to call GetFontfamily method.
        bool CanGetFontfamily(void) const;
        void ResetFontfamily(void);
        const TFontfamily& GetFontfamily(void) const;
        void SetFontfamily(const TFontfamily& value);
        void SetFontfamily(TFontfamily&& value);
        TFontfamily& SetFontfamily(void);
    
        /// optional
        /// typedef EAttlist_fontweight TFontweight
        ///  Check whether the Fontweight data member has been assigned a value.
        bool IsSetFontweight(void) const;
        /// Check whether it is safe or not to call GetFontweight method.
        bool CanGetFontweight(void) const;
        void ResetFontweight(void);
        TFontweight GetFontweight(void) const;
        void SetFontweight(TFontweight value);
        TFontweight& SetFontweight(void);
    
        /// optional
        /// typedef EAttlist_fontstyle TFontstyle
        ///  Check whether the Fontstyle data member has been assigned a value.
        bool IsSetFontstyle(void) const;
        /// Check whether it is safe or not to call GetFontstyle method.
        bool CanGetFontstyle(void) const;
        void ResetFontstyle(void);
        TFontstyle GetFontstyle(void) const;
        void SetFontstyle(TFontstyle value);
        TFontstyle& SetFontstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFontsize
        ///  Check whether the Fontsize data member has been assigned a value.
        bool IsSetFontsize(void) const;
        /// Check whether it is safe or not to call GetFontsize method.
        bool CanGetFontsize(void) const;
        void ResetFontsize(void);
        const TFontsize& GetFontsize(void) const;
        void SetFontsize(const TFontsize& value);
        void SetFontsize(TFontsize&& value);
        TFontsize& SetFontsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColor
        ///  Check whether the Color data member has been assigned a value.
        bool IsSetColor(void) const;
        /// Check whether it is safe or not to call GetColor method.
        bool CanGetColor(void) const;
        void ResetColor(void);
        const TColor& GetColor(void) const;
        void SetColor(const TColor& value);
        void SetColor(TColor&& value);
        TColor& SetColor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TBackground
        ///  Check whether the Background data member has been assigned a value.
        bool IsSetBackground(void) const;
        /// Check whether it is safe or not to call GetBackground method.
        bool CanGetBackground(void) const;
        void ResetBackground(void);
        const TBackground& GetBackground(void) const;
        void SetBackground(const TBackground& value);
        void SetBackground(TBackground&& value);
        TBackground& SetBackground(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[2];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Src;
        NCBI_NS_STD::string m_Width;
        NCBI_NS_STD::string m_Height;
        NCBI_NS_STD::string m_Valign;
        NCBI_NS_STD::string m_Alt;
        NCBI_NS_STD::string m_Index;
        EAttlist_mathvariant m_Mathvariant;
        NCBI_NS_STD::string m_Mathsize;
        NCBI_NS_STD::string m_Fontfamily;
        EAttlist_fontweight m_Fontweight;
        EAttlist_fontstyle m_Fontstyle;
        NCBI_NS_STD::string m_Fontsize;
        NCBI_NS_STD::string m_Color;
        NCBI_NS_STD::string m_Background;
    };
    // types
    typedef C_Attlist TAttlist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_mglyph
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    ///  Check whether the Mglyph data member has been assigned a value.
    bool IsSetMglyph(void) const;
    /// Check whether it is safe or not to call GetMglyph method.
    bool CanGetMglyph(void) const;
    void ResetMglyph(void);
    void SetMglyph(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMglyph_Base(const CMglyph_Base&);
    CMglyph_Base& operator=(const CMglyph_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMglyph_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMglyph_Base::C_Attlist::TId& CMglyph_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMglyph_Base::C_Attlist::SetId(const CMglyph_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMglyph_Base::C_Attlist::SetId(CMglyph_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMglyph_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMglyph_Base::C_Attlist::TId& CMglyph_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMglyph_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMglyph_Base::C_Attlist::TXref& CMglyph_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMglyph_Base::C_Attlist::SetXref(const CMglyph_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMglyph_Base::C_Attlist::SetXref(CMglyph_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMglyph_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMglyph_Base::C_Attlist::TXref& CMglyph_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMglyph_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMglyph_Base::C_Attlist::TClass& CMglyph_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMglyph_Base::C_Attlist::SetClass(const CMglyph_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMglyph_Base::C_Attlist::SetClass(CMglyph_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMglyph_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMglyph_Base::C_Attlist::TClass& CMglyph_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMglyph_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMglyph_Base::C_Attlist::TStyle& CMglyph_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMglyph_Base::C_Attlist::SetStyle(const CMglyph_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMglyph_Base::C_Attlist::SetStyle(CMglyph_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMglyph_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMglyph_Base::C_Attlist::TStyle& CMglyph_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMglyph_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMglyph_Base::C_Attlist::THref& CMglyph_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMglyph_Base::C_Attlist::SetHref(const CMglyph_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMglyph_Base::C_Attlist::SetHref(CMglyph_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMglyph_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMglyph_Base::C_Attlist::THref& CMglyph_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMglyph_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMglyph_Base::C_Attlist::TMathcolor& CMglyph_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMglyph_Base::C_Attlist::SetMathcolor(const CMglyph_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMglyph_Base::C_Attlist::SetMathcolor(CMglyph_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMglyph_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMglyph_Base::C_Attlist::TMathcolor& CMglyph_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMglyph_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMglyph_Base::C_Attlist::TMathbackground& CMglyph_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMglyph_Base::C_Attlist::SetMathbackground(const CMglyph_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMglyph_Base::C_Attlist::SetMathbackground(CMglyph_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMglyph_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMglyph_Base::C_Attlist::TMathbackground& CMglyph_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMglyph_Base::C_Attlist::IsSetSrc(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetSrc(void) const
{
    return IsSetSrc();
}

inline
const CMglyph_Base::C_Attlist::TSrc& CMglyph_Base::C_Attlist::GetSrc(void) const
{
    if (!CanGetSrc()) {
        ThrowUnassigned(7);
    }
    return m_Src;
}

inline
void CMglyph_Base::C_Attlist::SetSrc(const CMglyph_Base::C_Attlist::TSrc& value)
{
    m_Src = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMglyph_Base::C_Attlist::SetSrc(CMglyph_Base::C_Attlist::TSrc&& value)
{
    m_Src = std::forward<CMglyph_Base::C_Attlist::TSrc>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMglyph_Base::C_Attlist::TSrc& CMglyph_Base::C_Attlist::SetSrc(void)
{
#ifdef _DEBUG
    if (!IsSetSrc()) {
        m_Src = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Src;
}

inline
bool CMglyph_Base::C_Attlist::IsSetWidth(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetWidth(void) const
{
    return IsSetWidth();
}

inline
const CMglyph_Base::C_Attlist::TWidth& CMglyph_Base::C_Attlist::GetWidth(void) const
{
    if (!CanGetWidth()) {
        ThrowUnassigned(8);
    }
    return m_Width;
}

inline
void CMglyph_Base::C_Attlist::SetWidth(const CMglyph_Base::C_Attlist::TWidth& value)
{
    m_Width = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMglyph_Base::C_Attlist::SetWidth(CMglyph_Base::C_Attlist::TWidth&& value)
{
    m_Width = std::forward<CMglyph_Base::C_Attlist::TWidth>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMglyph_Base::C_Attlist::TWidth& CMglyph_Base::C_Attlist::SetWidth(void)
{
#ifdef _DEBUG
    if (!IsSetWidth()) {
        m_Width = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Width;
}

inline
bool CMglyph_Base::C_Attlist::IsSetHeight(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetHeight(void) const
{
    return IsSetHeight();
}

inline
const CMglyph_Base::C_Attlist::THeight& CMglyph_Base::C_Attlist::GetHeight(void) const
{
    if (!CanGetHeight()) {
        ThrowUnassigned(9);
    }
    return m_Height;
}

inline
void CMglyph_Base::C_Attlist::SetHeight(const CMglyph_Base::C_Attlist::THeight& value)
{
    m_Height = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMglyph_Base::C_Attlist::SetHeight(CMglyph_Base::C_Attlist::THeight&& value)
{
    m_Height = std::forward<CMglyph_Base::C_Attlist::THeight>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMglyph_Base::C_Attlist::THeight& CMglyph_Base::C_Attlist::SetHeight(void)
{
#ifdef _DEBUG
    if (!IsSetHeight()) {
        m_Height = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Height;
}

inline
bool CMglyph_Base::C_Attlist::IsSetValign(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetValign(void) const
{
    return IsSetValign();
}

inline
const CMglyph_Base::C_Attlist::TValign& CMglyph_Base::C_Attlist::GetValign(void) const
{
    if (!CanGetValign()) {
        ThrowUnassigned(10);
    }
    return m_Valign;
}

inline
void CMglyph_Base::C_Attlist::SetValign(const CMglyph_Base::C_Attlist::TValign& value)
{
    m_Valign = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMglyph_Base::C_Attlist::SetValign(CMglyph_Base::C_Attlist::TValign&& value)
{
    m_Valign = std::forward<CMglyph_Base::C_Attlist::TValign>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMglyph_Base::C_Attlist::TValign& CMglyph_Base::C_Attlist::SetValign(void)
{
#ifdef _DEBUG
    if (!IsSetValign()) {
        m_Valign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Valign;
}

inline
bool CMglyph_Base::C_Attlist::IsSetAlt(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetAlt(void) const
{
    return IsSetAlt();
}

inline
const CMglyph_Base::C_Attlist::TAlt& CMglyph_Base::C_Attlist::GetAlt(void) const
{
    if (!CanGetAlt()) {
        ThrowUnassigned(11);
    }
    return m_Alt;
}

inline
void CMglyph_Base::C_Attlist::SetAlt(const CMglyph_Base::C_Attlist::TAlt& value)
{
    m_Alt = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMglyph_Base::C_Attlist::SetAlt(CMglyph_Base::C_Attlist::TAlt&& value)
{
    m_Alt = std::forward<CMglyph_Base::C_Attlist::TAlt>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMglyph_Base::C_Attlist::TAlt& CMglyph_Base::C_Attlist::SetAlt(void)
{
#ifdef _DEBUG
    if (!IsSetAlt()) {
        m_Alt = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Alt;
}

inline
bool CMglyph_Base::C_Attlist::IsSetIndex(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetIndex(void) const
{
    return IsSetIndex();
}

inline
const CMglyph_Base::C_Attlist::TIndex& CMglyph_Base::C_Attlist::GetIndex(void) const
{
    if (!CanGetIndex()) {
        ThrowUnassigned(12);
    }
    return m_Index;
}

inline
void CMglyph_Base::C_Attlist::SetIndex(const CMglyph_Base::C_Attlist::TIndex& value)
{
    m_Index = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CMglyph_Base::C_Attlist::SetIndex(CMglyph_Base::C_Attlist::TIndex&& value)
{
    m_Index = std::forward<CMglyph_Base::C_Attlist::TIndex>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CMglyph_Base::C_Attlist::TIndex& CMglyph_Base::C_Attlist::SetIndex(void)
{
#ifdef _DEBUG
    if (!IsSetIndex()) {
        m_Index = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Index;
}

inline
bool CMglyph_Base::C_Attlist::IsSetMathvariant(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetMathvariant(void) const
{
    return IsSetMathvariant();
}

inline
void CMglyph_Base::C_Attlist::ResetMathvariant(void)
{
    m_Mathvariant = (EAttlist_mathvariant)(0);
    m_set_State[0] &= ~0xc000000;
}

inline
CMglyph_Base::C_Attlist::TMathvariant CMglyph_Base::C_Attlist::GetMathvariant(void) const
{
    if (!CanGetMathvariant()) {
        ThrowUnassigned(13);
    }
    return m_Mathvariant;
}

inline
void CMglyph_Base::C_Attlist::SetMathvariant(CMglyph_Base::C_Attlist::TMathvariant value)
{
    m_Mathvariant = value;
    m_set_State[0] |= 0xc000000;
}

inline
CMglyph_Base::C_Attlist::TMathvariant& CMglyph_Base::C_Attlist::SetMathvariant(void)
{
#ifdef _DEBUG
    if (!IsSetMathvariant()) {
        memset(&m_Mathvariant,UnassignedByte(),sizeof(m_Mathvariant));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Mathvariant;
}

inline
bool CMglyph_Base::C_Attlist::IsSetMathsize(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetMathsize(void) const
{
    return IsSetMathsize();
}

inline
const CMglyph_Base::C_Attlist::TMathsize& CMglyph_Base::C_Attlist::GetMathsize(void) const
{
    if (!CanGetMathsize()) {
        ThrowUnassigned(14);
    }
    return m_Mathsize;
}

inline
void CMglyph_Base::C_Attlist::SetMathsize(const CMglyph_Base::C_Attlist::TMathsize& value)
{
    m_Mathsize = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMglyph_Base::C_Attlist::SetMathsize(CMglyph_Base::C_Attlist::TMathsize&& value)
{
    m_Mathsize = std::forward<CMglyph_Base::C_Attlist::TMathsize>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMglyph_Base::C_Attlist::TMathsize& CMglyph_Base::C_Attlist::SetMathsize(void)
{
#ifdef _DEBUG
    if (!IsSetMathsize()) {
        m_Mathsize = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Mathsize;
}

inline
bool CMglyph_Base::C_Attlist::IsSetFontfamily(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetFontfamily(void) const
{
    return IsSetFontfamily();
}

inline
const CMglyph_Base::C_Attlist::TFontfamily& CMglyph_Base::C_Attlist::GetFontfamily(void) const
{
    if (!CanGetFontfamily()) {
        ThrowUnassigned(15);
    }
    return m_Fontfamily;
}

inline
void CMglyph_Base::C_Attlist::SetFontfamily(const CMglyph_Base::C_Attlist::TFontfamily& value)
{
    m_Fontfamily = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMglyph_Base::C_Attlist::SetFontfamily(CMglyph_Base::C_Attlist::TFontfamily&& value)
{
    m_Fontfamily = std::forward<CMglyph_Base::C_Attlist::TFontfamily>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMglyph_Base::C_Attlist::TFontfamily& CMglyph_Base::C_Attlist::SetFontfamily(void)
{
#ifdef _DEBUG
    if (!IsSetFontfamily()) {
        m_Fontfamily = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Fontfamily;
}

inline
bool CMglyph_Base::C_Attlist::IsSetFontweight(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetFontweight(void) const
{
    return IsSetFontweight();
}

inline
void CMglyph_Base::C_Attlist::ResetFontweight(void)
{
    m_Fontweight = (EAttlist_fontweight)(0);
    m_set_State[1] &= ~0x3;
}

inline
CMglyph_Base::C_Attlist::TFontweight CMglyph_Base::C_Attlist::GetFontweight(void) const
{
    if (!CanGetFontweight()) {
        ThrowUnassigned(16);
    }
    return m_Fontweight;
}

inline
void CMglyph_Base::C_Attlist::SetFontweight(CMglyph_Base::C_Attlist::TFontweight value)
{
    m_Fontweight = value;
    m_set_State[1] |= 0x3;
}

inline
CMglyph_Base::C_Attlist::TFontweight& CMglyph_Base::C_Attlist::SetFontweight(void)
{
#ifdef _DEBUG
    if (!IsSetFontweight()) {
        memset(&m_Fontweight,UnassignedByte(),sizeof(m_Fontweight));
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Fontweight;
}

inline
bool CMglyph_Base::C_Attlist::IsSetFontstyle(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetFontstyle(void) const
{
    return IsSetFontstyle();
}

inline
void CMglyph_Base::C_Attlist::ResetFontstyle(void)
{
    m_Fontstyle = (EAttlist_fontstyle)(0);
    m_set_State[1] &= ~0xc;
}

inline
CMglyph_Base::C_Attlist::TFontstyle CMglyph_Base::C_Attlist::GetFontstyle(void) const
{
    if (!CanGetFontstyle()) {
        ThrowUnassigned(17);
    }
    return m_Fontstyle;
}

inline
void CMglyph_Base::C_Attlist::SetFontstyle(CMglyph_Base::C_Attlist::TFontstyle value)
{
    m_Fontstyle = value;
    m_set_State[1] |= 0xc;
}

inline
CMglyph_Base::C_Attlist::TFontstyle& CMglyph_Base::C_Attlist::SetFontstyle(void)
{
#ifdef _DEBUG
    if (!IsSetFontstyle()) {
        memset(&m_Fontstyle,UnassignedByte(),sizeof(m_Fontstyle));
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Fontstyle;
}

inline
bool CMglyph_Base::C_Attlist::IsSetFontsize(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetFontsize(void) const
{
    return IsSetFontsize();
}

inline
const CMglyph_Base::C_Attlist::TFontsize& CMglyph_Base::C_Attlist::GetFontsize(void) const
{
    if (!CanGetFontsize()) {
        ThrowUnassigned(18);
    }
    return m_Fontsize;
}

inline
void CMglyph_Base::C_Attlist::SetFontsize(const CMglyph_Base::C_Attlist::TFontsize& value)
{
    m_Fontsize = value;
    m_set_State[1] |= 0x30;
}

inline
void CMglyph_Base::C_Attlist::SetFontsize(CMglyph_Base::C_Attlist::TFontsize&& value)
{
    m_Fontsize = std::forward<CMglyph_Base::C_Attlist::TFontsize>(value);
    m_set_State[1] |= 0x30;
}

inline
CMglyph_Base::C_Attlist::TFontsize& CMglyph_Base::C_Attlist::SetFontsize(void)
{
#ifdef _DEBUG
    if (!IsSetFontsize()) {
        m_Fontsize = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Fontsize;
}

inline
bool CMglyph_Base::C_Attlist::IsSetColor(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetColor(void) const
{
    return IsSetColor();
}

inline
const CMglyph_Base::C_Attlist::TColor& CMglyph_Base::C_Attlist::GetColor(void) const
{
    if (!CanGetColor()) {
        ThrowUnassigned(19);
    }
    return m_Color;
}

inline
void CMglyph_Base::C_Attlist::SetColor(const CMglyph_Base::C_Attlist::TColor& value)
{
    m_Color = value;
    m_set_State[1] |= 0xc0;
}

inline
void CMglyph_Base::C_Attlist::SetColor(CMglyph_Base::C_Attlist::TColor&& value)
{
    m_Color = std::forward<CMglyph_Base::C_Attlist::TColor>(value);
    m_set_State[1] |= 0xc0;
}

inline
CMglyph_Base::C_Attlist::TColor& CMglyph_Base::C_Attlist::SetColor(void)
{
#ifdef _DEBUG
    if (!IsSetColor()) {
        m_Color = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Color;
}

inline
bool CMglyph_Base::C_Attlist::IsSetBackground(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMglyph_Base::C_Attlist::CanGetBackground(void) const
{
    return IsSetBackground();
}

inline
const CMglyph_Base::C_Attlist::TBackground& CMglyph_Base::C_Attlist::GetBackground(void) const
{
    if (!CanGetBackground()) {
        ThrowUnassigned(20);
    }
    return m_Background;
}

inline
void CMglyph_Base::C_Attlist::SetBackground(const CMglyph_Base::C_Attlist::TBackground& value)
{
    m_Background = value;
    m_set_State[1] |= 0x300;
}

inline
void CMglyph_Base::C_Attlist::SetBackground(CMglyph_Base::C_Attlist::TBackground&& value)
{
    m_Background = std::forward<CMglyph_Base::C_Attlist::TBackground>(value);
    m_set_State[1] |= 0x300;
}

inline
CMglyph_Base::C_Attlist::TBackground& CMglyph_Base::C_Attlist::SetBackground(void)
{
#ifdef _DEBUG
    if (!IsSetBackground()) {
        m_Background = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Background;
}

inline
bool CMglyph_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMglyph_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMglyph_Base::TAttlist& CMglyph_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMglyph_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMglyph_Base::TAttlist& CMglyph_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    SetMglyph();
    return (*m_Attlist);
}

inline
bool CMglyph_Base::IsSetMglyph(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMglyph_Base::CanGetMglyph(void) const
{
    return false;
}

inline
void CMglyph_Base::ResetMglyph(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CMglyph_Base::SetMglyph(void)
{
    m_set_State[0] |= 0xc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MGLYPH_BASE_HPP
