/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file QualifierName_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_QUALIFIERNAME_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_QUALIFIERNAME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CQualifierName_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CQualifierName_Base(void);
    // destructor
    virtual ~CQualifierName_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_MajorTopicYN {
            eAttlist_MajorTopicYN_Y = 1,
            eAttlist_MajorTopicYN_N = 2
        };
        
        /// Access to EAttlist_MajorTopicYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_MajorTopicYN)(void);
        
        // types
        typedef EAttlist_MajorTopicYN TMajorTopicYN;
        typedef NCBI_NS_STD::string TUI;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_MajorTopicYN,
            e_UI
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_MajorTopicYN_N
        /// typedef EAttlist_MajorTopicYN TMajorTopicYN
        ///  Check whether the MajorTopicYN data member has been assigned a value.
        bool IsSetMajorTopicYN(void) const;
        /// Check whether it is safe or not to call GetMajorTopicYN method.
        bool CanGetMajorTopicYN(void) const;
        void ResetMajorTopicYN(void);
        void SetDefaultMajorTopicYN(void);
        TMajorTopicYN GetMajorTopicYN(void) const;
        void SetMajorTopicYN(TMajorTopicYN value);
        TMajorTopicYN& SetMajorTopicYN(void);
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TUI
        ///  Check whether the UI data member has been assigned a value.
        bool IsSetUI(void) const;
        /// Check whether it is safe or not to call GetUI method.
        bool CanGetUI(void) const;
        void ResetUI(void);
        const TUI& GetUI(void) const;
        void SetUI(const TUI& value);
        void SetUI(TUI&& value);
        TUI& SetUI(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_MajorTopicYN m_MajorTopicYN;
        NCBI_NS_STD::string m_UI;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TQualifierName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_QualifierName
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TQualifierName
    ///  Check whether the QualifierName data member has been assigned a value.
    bool IsSetQualifierName(void) const;
    /// Check whether it is safe or not to call GetQualifierName method.
    bool CanGetQualifierName(void) const;
    void ResetQualifierName(void);
    const TQualifierName& GetQualifierName(void) const;
    void SetQualifierName(const TQualifierName& value);
    void SetQualifierName(TQualifierName&& value);
    TQualifierName& SetQualifierName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CQualifierName_Base(const CQualifierName_Base&);
    CQualifierName_Base& operator=(const CQualifierName_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_QualifierName;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CQualifierName_Base::C_Attlist::IsSetMajorTopicYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CQualifierName_Base::C_Attlist::CanGetMajorTopicYN(void) const
{
    return true;
}

inline
void CQualifierName_Base::C_Attlist::ResetMajorTopicYN(void)
{
    m_MajorTopicYN = eAttlist_MajorTopicYN_N;
    m_set_State[0] &= ~0x3;
}

inline
void CQualifierName_Base::C_Attlist::SetDefaultMajorTopicYN(void)
{
    ResetMajorTopicYN();
    m_set_State[0] |= 0x1;
}

inline
CQualifierName_Base::C_Attlist::TMajorTopicYN CQualifierName_Base::C_Attlist::GetMajorTopicYN(void) const
{
    return m_MajorTopicYN;
}

inline
void CQualifierName_Base::C_Attlist::SetMajorTopicYN(CQualifierName_Base::C_Attlist::TMajorTopicYN value)
{
    m_MajorTopicYN = value;
    m_set_State[0] |= 0x3;
}

inline
CQualifierName_Base::C_Attlist::TMajorTopicYN& CQualifierName_Base::C_Attlist::SetMajorTopicYN(void)
{
#ifdef _DEBUG
    if (!IsSetMajorTopicYN()) {
        memset(&m_MajorTopicYN,UnassignedByte(),sizeof(m_MajorTopicYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_MajorTopicYN;
}

inline
bool CQualifierName_Base::C_Attlist::IsSetUI(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CQualifierName_Base::C_Attlist::CanGetUI(void) const
{
    return IsSetUI();
}

inline
const CQualifierName_Base::C_Attlist::TUI& CQualifierName_Base::C_Attlist::GetUI(void) const
{
    if (!CanGetUI()) {
        ThrowUnassigned(1);
    }
    return m_UI;
}

inline
void CQualifierName_Base::C_Attlist::SetUI(const CQualifierName_Base::C_Attlist::TUI& value)
{
    m_UI = value;
    m_set_State[0] |= 0xc;
}

inline
void CQualifierName_Base::C_Attlist::SetUI(CQualifierName_Base::C_Attlist::TUI&& value)
{
    m_UI = std::forward<CQualifierName_Base::C_Attlist::TUI>(value);
    m_set_State[0] |= 0xc;
}

inline
CQualifierName_Base::C_Attlist::TUI& CQualifierName_Base::C_Attlist::SetUI(void)
{
#ifdef _DEBUG
    if (!IsSetUI()) {
        m_UI = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_UI;
}

inline
bool CQualifierName_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CQualifierName_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CQualifierName_Base::TAttlist& CQualifierName_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CQualifierName_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CQualifierName_Base::TAttlist& CQualifierName_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CQualifierName_Base::IsSetQualifierName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CQualifierName_Base::CanGetQualifierName(void) const
{
    return IsSetQualifierName();
}

inline
const CQualifierName_Base::TQualifierName& CQualifierName_Base::GetQualifierName(void) const
{
    if (!CanGetQualifierName()) {
        ThrowUnassigned(1);
    }
    return m_QualifierName;
}

inline
void CQualifierName_Base::SetQualifierName(const CQualifierName_Base::TQualifierName& value)
{
    m_QualifierName = value;
    m_set_State[0] |= 0xc;
}

inline
void CQualifierName_Base::SetQualifierName(CQualifierName_Base::TQualifierName&& value)
{
    m_QualifierName = std::forward<CQualifierName_Base::TQualifierName>(value);
    m_set_State[0] |= 0xc;
}

inline
CQualifierName_Base::TQualifierName& CQualifierName_Base::SetQualifierName(void)
{
#ifdef _DEBUG
    if (!IsSetQualifierName()) {
        m_QualifierName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_QualifierName;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_QUALIFIERNAME_BASE_HPP
