/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TableRowExpression_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_TABLEROWEXPRESSION_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_TABLEROWEXPRESSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMlabeledtr;
class CMtr;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CTableRowExpression_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CTableRowExpression_Base(void);
    // destructor
    virtual ~CTableRowExpression_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Mtr,
        e_Mlabeledtr
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_Mlabeledtr+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static NCBI_NS_STD::string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                NCBI_NS_NCBI::EResetVariant reset,
                NCBI_NS_NCBI::CObjectMemoryPool* pool);

    // types
    typedef CMtr TMtr;
    typedef CMlabeledtr TMlabeledtr;

    // getters
    // setters

    // typedef CMtr TMtr
    bool IsMtr(void) const;
    const TMtr& GetMtr(void) const;
    TMtr& SetMtr(void);
    void SetMtr(TMtr& value);

    // typedef CMlabeledtr TMlabeledtr
    bool IsMlabeledtr(void) const;
    const TMlabeledtr& GetMlabeledtr(void) const;
    TMlabeledtr& SetMlabeledtr(void);
    void SetMlabeledtr(TMlabeledtr& value);


private:
    // copy constructor and assignment operator
    CTableRowExpression_Base(const CTableRowExpression_Base& );
    CTableRowExpression_Base& operator=(const CTableRowExpression_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTableRowExpression_Base::E_Choice CTableRowExpression_Base::Which(void) const
{
    return m_choice;
}

inline
void CTableRowExpression_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTableRowExpression_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTableRowExpression_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTableRowExpression_Base::IsMtr(void) const
{
    return m_choice == e_Mtr;
}

inline
bool CTableRowExpression_Base::IsMlabeledtr(void) const
{
    return m_choice == e_Mlabeledtr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_TABLEROWEXPRESSION_BASE_HPP
