/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file IdCheckList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_IDCHECKLIST_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_IDCHECKLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CId;
class CIdLinkSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CIdCheckList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CIdCheckList_Base(void);
    // destructor
    virtual ~CIdCheckList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// cmd=ncheck & lcheck & acheck 
    class NCBI_EUTILS_EXPORT C_II : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_II(void);
        // destructor
        ~C_II(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        /// cmd=ncheck & lcheck & acheck 
        class NCBI_EUTILS_EXPORT C_E_II : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_E_II(void);
            // destructor
            ~C_E_II(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,  ///< No variant selected
                e_Id,           ///< \d+ 
                e_IdLinkSet
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 3 ///< == e_IdLinkSet+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef CId TId;
            typedef CIdLinkSet TIdLinkSet;
        
            // getters
            // setters
        
            // typedef CId TId
            bool IsId(void) const;
            const TId& GetId(void) const;
            TId& SetId(void);
            void SetId(TId& value);
        
            // typedef CIdLinkSet TIdLinkSet
            bool IsIdLinkSet(void) const;
            const TIdLinkSet& GetIdLinkSet(void) const;
            TIdLinkSet& SetIdLinkSet(void);
            void SetIdLinkSet(TIdLinkSet& value);
        
        
        private:
            // copy constructor and assignment operator
            C_E_II(const C_E_II& );
            C_E_II& operator=(const C_E_II& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef C_E_II C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_II > > TII;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_II
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_II > > TII
        ///  Check whether the II data member has been assigned a value.
        bool IsSetII(void) const;
        /// Check whether it is safe or not to call GetII method.
        bool CanGetII(void) const;
        void ResetII(void);
        const TII& GetII(void) const;
        TII& SetII(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_II(const C_II&);
        C_II& operator=(const C_II&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_II > > m_II;
    };
    // types
    typedef C_II TII;
    typedef NCBI_NS_STD::string TERROR;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_II,
        e_ERROR
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// cmd=ncheck & lcheck & acheck 
    /// optional
    /// typedef C_II TII
    ///  Check whether the II data member has been assigned a value.
    bool IsSetII(void) const;
    /// Check whether it is safe or not to call GetII method.
    bool CanGetII(void) const;
    void ResetII(void);
    const TII& GetII(void) const;
    void SetII(TII& value);
    TII& SetII(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TERROR
    ///  Check whether the ERROR data member has been assigned a value.
    bool IsSetERROR(void) const;
    /// Check whether it is safe or not to call GetERROR method.
    bool CanGetERROR(void) const;
    void ResetERROR(void);
    const TERROR& GetERROR(void) const;
    void SetERROR(const TERROR& value);
    void SetERROR(TERROR&& value);
    TERROR& SetERROR(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CIdCheckList_Base(const CIdCheckList_Base&);
    CIdCheckList_Base& operator=(const CIdCheckList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TII > m_II;
    NCBI_NS_STD::string m_ERROR;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CIdCheckList_Base::C_II::C_E_II::E_Choice CIdCheckList_Base::C_II::C_E_II::Which(void) const
{
    return m_choice;
}

inline
void CIdCheckList_Base::C_II::C_E_II::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CIdCheckList_Base::C_II::C_E_II::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CIdCheckList_Base::C_II::C_E_II::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CIdCheckList_Base::C_II::C_E_II::IsId(void) const
{
    return m_choice == e_Id;
}

inline
bool CIdCheckList_Base::C_II::C_E_II::IsIdLinkSet(void) const
{
    return m_choice == e_IdLinkSet;
}

inline
bool CIdCheckList_Base::C_II::IsSetII(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CIdCheckList_Base::C_II::CanGetII(void) const
{
    return true;
}

inline
const CIdCheckList_Base::C_II::TII& CIdCheckList_Base::C_II::GetII(void) const
{
    return m_II;
}

inline
CIdCheckList_Base::C_II::TII& CIdCheckList_Base::C_II::SetII(void)
{
    m_set_State[0] |= 0x1;
    return m_II;
}

inline
bool CIdCheckList_Base::IsSetII(void) const
{
    return m_II.NotEmpty();
}

inline
bool CIdCheckList_Base::CanGetII(void) const
{
    return IsSetII();
}

inline
const CIdCheckList_Base::TII& CIdCheckList_Base::GetII(void) const
{
    if (!CanGetII()) {
        ThrowUnassigned(0);
    }
    return (*m_II);
}

inline
bool CIdCheckList_Base::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CIdCheckList_Base::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CIdCheckList_Base::TERROR& CIdCheckList_Base::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(1);
    }
    return m_ERROR;
}

inline
void CIdCheckList_Base::SetERROR(const CIdCheckList_Base::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0xc;
}

inline
void CIdCheckList_Base::SetERROR(CIdCheckList_Base::TERROR&& value)
{
    m_ERROR = std::forward<CIdCheckList_Base::TERROR>(value);
    m_set_State[0] |= 0xc;
}

inline
CIdCheckList_Base::TERROR& CIdCheckList_Base::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ERROR;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_IDCHECKLIST_BASE_HPP
